/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.function.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.map.storage.chm.CriteriaOperator;

public class CriteriaOperatorTest {
    @Test
    public void shouldCompareLongs() {
        Predicate predicate = CriteriaOperator.ge((Object[])new Long[]{0L});
        Assert.assertTrue((boolean)predicate.test(1L));
    }

    @Test
    public void shouldCompareInts() {
        Predicate predicate = CriteriaOperator.ge((Object[])new Integer[]{0});
        Assert.assertTrue((boolean)predicate.test(1));
    }

    @Test
    public void shouldThrowAnExceptionOnIncompatibleTypes() {
        Predicate predicate = CriteriaOperator.ge((Object[])new Long[]{0L});
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> predicate.test(1));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Incomparable argument type for comparison operation"));
    }
}

