/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.criteria;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.storage.criteria.DescriptiveModelCriteria;

public class DefaultModelCriteriaTest {
    @Test
    public void testSimpleCompare() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{3})), (Matcher)Matchers.hasToString((String)"clientId EQ [3]"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] && id EQ [5])"));
    }

    @Test
    public void testSimpleCompareAnd() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[0])), (Matcher)Matchers.hasToString((String)"__TRUE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[0])})), (Matcher)Matchers.hasToString((String)"__FALSE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{3})})), (Matcher)Matchers.hasToString((String)"clientId EQ [3]"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{3}), (DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[0])})), (Matcher)Matchers.hasToString((String)"__FALSE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] && id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] && id EQ [5])"));
    }

    @Test
    public void testSimpleCompareOr() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[0])), (Matcher)Matchers.hasToString((String)"__FALSE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[0])})), (Matcher)Matchers.hasToString((String)"__TRUE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{3})})), (Matcher)Matchers.hasToString((String)"clientId EQ [3]"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{3}), (DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[0])})), (Matcher)Matchers.hasToString((String)"__TRUE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] && id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] || id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] || id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})})), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] || id EQ [5])"));
    }

    @Test
    public void testSimpleCompareAndOr() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ATTRIBUTE, ModelCriteriaBuilder.Operator.EQ, new Object[]{"city", "Ankh-Morpork"})))))})), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && id EQ [5]) || attribute EQ [city, Ankh-Morpork])"));
        DefaultModelCriteria mcb = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)mcb.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"realmId"}), (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"clientId"}), (DefaultModelCriteria)mcb.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%search%"}), (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%search%"})})})), (Matcher)Matchers.hasToString((String)"(realmId EQ [realmId] && clientId EQ [clientId] && (name ILIKE [%search%] || description ILIKE [%search%]))"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"realmId"})).compare(RoleModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"clientId"})).or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%search%"}), (DefaultModelCriteria)mcb.compare(RoleModel.SearchableFields.DESCRIPTION, ModelCriteriaBuilder.Operator.ILIKE, new Object[]{"%search%"})})), (Matcher)Matchers.hasToString((String)"(realmId EQ [realmId] && clientId EQ [clientId] && (name ILIKE [%search%] || description ILIKE [%search%]))"));
    }

    @Test
    public void testComplexCompareAndOr() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))})), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || ! id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))).compare(ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{"true"})})), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || (! id EQ [5] && enabled EQ [true]))"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))).compare(ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{"true"})))})), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || ! (! id EQ [5] && enabled EQ [true]))"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})).compare(ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{"true"})})))))})), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || (id EQ [5] && enabled EQ [true]))"));
    }

    @Test
    public void testFlashingToAnotherMCB() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))})).flashToModelCriteriaBuilder((ModelCriteriaBuilder)DefaultModelCriteria.criteria())), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || ! id EQ [5])"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))).compare(ClientModel.SearchableFields.ENABLED, ModelCriteriaBuilder.Operator.EQ, new Object[]{"true"})})).flashToModelCriteriaBuilder((ModelCriteriaBuilder)DefaultModelCriteria.criteria())), (Matcher)Matchers.hasToString((String)"((clientId EQ [4] && realmId EQ [aa]) || (! id EQ [5] && enabled EQ [true]))"));
    }

    @Test
    public void testCloning() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})).partiallyEvaluate((field, operator, operatorArguments) -> field == ClientModel.SearchableFields.CLIENT_ID && operator == ModelCriteriaBuilder.Operator.EQ && Arrays.asList(operatorArguments).contains(4) || field == ClientModel.SearchableFields.ID && operator == ModelCriteriaBuilder.Operator.EQ && Arrays.asList(operatorArguments).contains(5) ? Boolean.valueOf(true) : null)), (Matcher)Matchers.hasToString((String)"(__TRUE__ && __TRUE__)"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})).partiallyEvaluate((field, operator, operatorArguments) -> field == ClientModel.SearchableFields.CLIENT_ID && operator == ModelCriteriaBuilder.Operator.EQ && Arrays.asList(operatorArguments).contains(4) || field == ClientModel.SearchableFields.ID && operator == ModelCriteriaBuilder.Operator.EQ && Arrays.asList(operatorArguments).contains(5) ? Boolean.valueOf(true) : null)).optimize()), (Matcher)Matchers.hasToString((String)"__TRUE__"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4})).compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})})).partiallyEvaluate((field, operator, operatorArguments) -> field == ClientModel.SearchableFields.CLIENT_ID && operator == ModelCriteriaBuilder.Operator.EQ && Arrays.asList(operatorArguments).contains(6) ? Boolean.valueOf(true) : null)), (Matcher)Matchers.hasToString((String)"(clientId EQ [4] && id EQ [5])"));
    }

    @Test
    public void testGetFieldCriteriaSingleArgument() {
        DefaultModelCriteria v = DefaultModelCriteria.criteria();
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.hasToString((String)"aa"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})))).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})))))).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.hasToString((String)"aa"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})})})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.hasToString((String)"aa"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{123}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})})})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.hasToString((String)"aa"));
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"bb"})})})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.or((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)((DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.and((DescriptiveModelCriteria[])new DefaultModelCriteria[]{(DefaultModelCriteria)v.compare(ClientModel.SearchableFields.CLIENT_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{4}), (DefaultModelCriteria)v.compare(ClientModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{"aa"})}), (DefaultModelCriteria)v.not((DescriptiveModelCriteria)((DefaultModelCriteria)v.compare(ClientModel.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, new Object[]{5})))})).getSingleRestrictionArgument(ClientModel.SearchableFields.REALM_ID.getName()), (Matcher)Matchers.hasToString((String)"aa"));
    }
}

