/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.map.storage.tree.DefaultTreeNode;
import org.keycloak.models.map.storage.tree.TreeNode;

public class DefaultTreeNodeTest {
    private static final String KEY_1 = "key1";
    private static final String VALUE_1 = "value";
    private static final String KEY_2 = "key2";
    private static final Date VALUE_2 = new Date();
    private static final String KEY_3 = "key3";
    private static final Integer VALUE_3 = 12345;
    public Map<String, Object> treeProperties = new HashMap<String, Object>();

    public DefaultTreeNodeTest() {
        this.treeProperties.put(KEY_1, VALUE_1);
        this.treeProperties.put(KEY_2, VALUE_2);
    }

    @Test
    public void testSingleNodeTree() {
        Node root = new Node();
        root.setNodeProperty(KEY_1, VALUE_1);
        root.setEdgeProperty(KEY_2, VALUE_2);
        MatcherAssert.assertThat((Object)root.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.empty());
        this.assertNodeProperty(root, KEY_1, VALUE_1);
        this.assertNodeProperty(root, KEY_2, null);
        this.assertEdgeProperty(root, KEY_1, null);
        this.assertEdgeProperty(root, KEY_2, VALUE_2);
        this.assertTreeProperties(root);
    }

    @Test
    public void testSimpleTwoNodeTree() {
        Node root = new Node();
        Node child = new Node();
        root.setNodeProperty(KEY_1, VALUE_1);
        child.setParent(root);
        child.setId("my-id");
        child.setEdgeProperty(KEY_2, VALUE_2);
        MatcherAssert.assertThat((Object)root.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)child.getParent(), (Matcher)Matchers.is(Optional.of(root)));
        MatcherAssert.assertThat((Object)child.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(root.getNodeProperties().keySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(root.getEdgeProperties().keySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(child.getNodeProperties().keySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(child.getEdgeProperties().keySet(), (Matcher)Matchers.hasSize((int)1));
        this.assertTreeProperties(root);
        this.assertTreeProperties(child);
    }

    @Test
    public void testSimpleTwoNodeTreeSwapped() {
        Node root = new Node();
        Node child = new Node();
        child.setParent(root);
        child.setId("my-id");
        root.setParent(child);
        MatcherAssert.assertThat((Object)child.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)child.getChildren(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)root.getParent(), (Matcher)Matchers.is(Optional.of(child)));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.empty());
        root.setNodeProperty(KEY_1, VALUE_1);
        child.setEdgeProperty(KEY_2, VALUE_2);
        MatcherAssert.assertThat(root.getNodeProperties().keySet(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(root.getEdgeProperties().keySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(child.getNodeProperties().keySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(child.getEdgeProperties().keySet(), (Matcher)Matchers.hasSize((int)1));
        this.assertTreeProperties(root);
        this.assertTreeProperties(child);
    }

    @Test
    public void testStructureLinearThreeNodeSwapped() {
        Node level1 = new Node();
        Node level2 = new Node();
        Node level3 = new Node();
        level2.setParent(level1);
        level3.setParent(level2);
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level2}));
        MatcherAssert.assertThat((Object)level2.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level2.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level3}));
        MatcherAssert.assertThat((Object)level3.getParent(), (Matcher)Matchers.is(Optional.of(level2)));
        MatcherAssert.assertThat((Object)level3.getChildren(), (Matcher)Matchers.empty());
        level1.setParent(level3);
        MatcherAssert.assertThat((Object)level3.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level3.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level1}));
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.of(level3)));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level2}));
        MatcherAssert.assertThat((Object)level2.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level2.getChildren(), (Matcher)Matchers.empty());
    }

    @Test
    public void testStructureAThreeNodeSwapped() {
        Node level1 = new Node();
        Node level21 = new Node();
        Node level22 = new Node();
        Node level23 = new Node();
        level21.setParent(level1);
        level22.setParent(level1);
        level23.setParent(level1);
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level21, level22, level23}));
        MatcherAssert.assertThat((Object)level21.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level21.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)level22.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level22.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)level23.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level23.getChildren(), (Matcher)Matchers.empty());
        level1.setParent(level22);
        MatcherAssert.assertThat((Object)level22.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level22.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level1}));
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.of(level22)));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level21, level23}));
        MatcherAssert.assertThat((Object)level21.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level21.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)level23.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level23.getChildren(), (Matcher)Matchers.empty());
        level21.setParent(level22);
        MatcherAssert.assertThat((Object)level22.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level22.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level1, level21}));
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.of(level22)));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level23}));
        MatcherAssert.assertThat((Object)level21.getParent(), (Matcher)Matchers.is(Optional.of(level22)));
        MatcherAssert.assertThat((Object)level21.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)level23.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level23.getChildren(), (Matcher)Matchers.empty());
        level21.setParent(null);
        MatcherAssert.assertThat((Object)level22.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level22.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level1}));
        MatcherAssert.assertThat((Object)level1.getParent(), (Matcher)Matchers.is(Optional.of(level22)));
        MatcherAssert.assertThat((Object)level1.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{level23}));
        MatcherAssert.assertThat((Object)level21.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)level21.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)level23.getParent(), (Matcher)Matchers.is(Optional.of(level1)));
        MatcherAssert.assertThat((Object)level23.getChildren(), (Matcher)Matchers.empty());
    }

    @Test
    public void testChangeId() {
        Node root = new Node();
        Node child1 = new Node();
        child1.setParent(root);
        child1.setId("my-id1");
        Node child2 = new Node();
        child2.setParent(root);
        child2.setId("my-id2");
        MatcherAssert.assertThat((Object)root.getChild("my-id1"), (Matcher)Matchers.is(Optional.of(child1)));
        MatcherAssert.assertThat((Object)root.getChild("my-id2"), (Matcher)Matchers.is(Optional.of(child2)));
        child1.setId("my-id3");
        MatcherAssert.assertThat((Object)root.getChild("my-id1"), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)root.getChild("my-id3"), (Matcher)Matchers.is(Optional.of(child1)));
    }

    @Test
    public void testRemoveChildDirectly() {
        Node root = new Node();
        Node child1 = new Node();
        child1.setParent(root);
        child1.setId("my-id1");
        Node child2 = new Node();
        child2.setParent(root);
        child2.setId("my-id2");
        MatcherAssert.assertThat((Object)root.getChild("my-id1"), (Matcher)Matchers.is(Optional.of(child1)));
        MatcherAssert.assertThat((Object)root.getChild("my-id2"), (Matcher)Matchers.is(Optional.of(child2)));
        MatcherAssert.assertThat((Object)root.removeChild(child1), (Matcher)Matchers.is(Optional.of(child1)));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{child2}));
        MatcherAssert.assertThat((Object)child1.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)root.removeChild(child1), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{child2}));
        MatcherAssert.assertThat((Object)child1.getParent(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testRemoveChildViaPredicate() {
        Node root = new Node();
        Node child1 = new Node();
        child1.setParent(root);
        child1.setId("my-id1");
        Node child2 = new Node();
        child2.setParent(root);
        child2.setId("my-id2");
        Node child3 = new Node();
        child3.setParent(root);
        child3.setId("my-id3");
        MatcherAssert.assertThat((Object)root.removeChild(node -> "my-id1".equals(node.getId())), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{child2, child3}));
        MatcherAssert.assertThat((Object)child1.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)child2.getParent(), (Matcher)Matchers.is(Optional.of(root)));
        MatcherAssert.assertThat((Object)child3.getParent(), (Matcher)Matchers.is(Optional.of(root)));
        MatcherAssert.assertThat((Object)root.removeChild(node -> true), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)child1.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)child2.getParent(), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)child3.getParent(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testRemoveChild() {
        Node root = new Node();
        Node child1 = new Node();
        child1.setParent(root);
        child1.setId("my-id1");
        Node child2 = new Node();
        child2.setParent(root);
        child2.setId("my-id2");
        MatcherAssert.assertThat((Object)root.getChild("my-id1"), (Matcher)Matchers.is(Optional.of(child1)));
        MatcherAssert.assertThat((Object)root.getChild("my-id2"), (Matcher)Matchers.is(Optional.of(child2)));
        root.removeChild(child1);
        MatcherAssert.assertThat((Object)root.getChildren(), (Matcher)Matchers.containsInAnyOrder((Object[])new Node[]{child2}));
        MatcherAssert.assertThat((Object)child1.getParent(), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testDfs() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        LinkedList res = new LinkedList();
        MatcherAssert.assertThat((Object)root.findFirstDfs(n -> {
            res.add(n);
            return false;
        }), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121, child12, child121, child122, child123}));
        res.clear();
        MatcherAssert.assertThat((Object)root.findFirstDfs(n -> {
            res.add(n);
            return n == child12;
        }), (Matcher)Matchers.is(Optional.of(child12)));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121, child12}));
    }

    @Test
    public void testDfsBottommost() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child13 = new Node(root, "1.3");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        Node child131 = new Node(child13, "1.3.1");
        Node child132 = new Node(child13, "1.3.2");
        LinkedList res = new LinkedList();
        MatcherAssert.assertThat((Object)root.findFirstBottommostDfs(n -> {
            res.add(n);
            return false;
        }), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121, child12, child121, child122, child123, child13, child131, child132}));
        res.clear();
        MatcherAssert.assertThat((Object)root.findFirstBottommostDfs(n -> {
            res.add(n);
            return n == child12;
        }), (Matcher)Matchers.is(Optional.of(child12)));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121, child12, child121, child122, child123}));
        res.clear();
        MatcherAssert.assertThat((Object)root.findFirstBottommostDfs(n -> {
            res.add(n);
            return n.getId().startsWith("1.1.2");
        }), (Matcher)Matchers.is(Optional.of(child1121)));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121}));
    }

    @Test
    public void testBfs() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        LinkedList res = new LinkedList();
        MatcherAssert.assertThat((Object)root.findFirstBfs(n -> {
            res.add(n);
            return false;
        }), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child12, child111, child112, child121, child122, child123, child1121}));
        res.clear();
        MatcherAssert.assertThat((Object)root.findFirstBfs(n -> {
            res.add(n);
            return n == child12;
        }), (Matcher)Matchers.is(Optional.of(child12)));
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child12}));
    }

    @Test
    public void testWalkBfs() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        LinkedList res = new LinkedList();
        root.walkBfs(res::add);
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child12, child111, child112, child121, child122, child123, child1121}));
    }

    @Test
    public void testWalkDfs() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        LinkedList uponEntry = new LinkedList();
        LinkedList afterChildren = new LinkedList();
        root.walkDfs(uponEntry::add, afterChildren::add);
        MatcherAssert.assertThat(uponEntry, (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child111, child112, child1121, child12, child121, child122, child123}));
        MatcherAssert.assertThat(afterChildren, (Matcher)Matchers.contains((Object[])new Node[]{child111, child1121, child112, child11, child121, child122, child123, child12, root}));
    }

    @Test
    public void testForEachParent() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        LinkedList res = new LinkedList();
        res.clear();
        root.forEachParent(res::add);
        MatcherAssert.assertThat(res, (Matcher)Matchers.empty());
        res.clear();
        child1121.forEachParent(res::add);
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{child112, child11, root}));
        res.clear();
        child123.forEachParent(res::add);
        MatcherAssert.assertThat(res, (Matcher)Matchers.contains((Object[])new Node[]{child12, root}));
    }

    @Test
    public void testPathToRoot() {
        Node root = new Node("1");
        Node child11 = new Node(root, "1.1");
        Node child12 = new Node(root, "1.2");
        Node child111 = new Node(child11, "1.1.1");
        Node child112 = new Node(child11, "1.1.2");
        Node child121 = new Node(child12, "1.2.1");
        Node child122 = new Node(child12, "1.2.2");
        Node child123 = new Node(child12, "1.2.3");
        Node child1121 = new Node(child112, "1.1.2.1");
        MatcherAssert.assertThat((Object)child1121.getPathToRoot(TreeNode.PathOrientation.TOP_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{root, child11, child112, child1121}));
        MatcherAssert.assertThat((Object)child123.getPathToRoot(TreeNode.PathOrientation.TOP_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{root, child12, child123}));
        MatcherAssert.assertThat((Object)root.getPathToRoot(TreeNode.PathOrientation.TOP_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{root}));
        MatcherAssert.assertThat((Object)child1121.getPathToRoot(TreeNode.PathOrientation.BOTTOM_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{child1121, child112, child11, root}));
        MatcherAssert.assertThat((Object)child123.getPathToRoot(TreeNode.PathOrientation.BOTTOM_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{child123, child12, root}));
        MatcherAssert.assertThat((Object)root.getPathToRoot(TreeNode.PathOrientation.BOTTOM_FIRST), (Matcher)Matchers.contains((Object[])new Node[]{root}));
    }

    @Test
    public void testToStringStackOverflow() {
        Node n = new Node("1");
        n.setNodeProperty("prop", (Object)n);
        MatcherAssert.assertThat((Object)n.toString().length(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(255)));
    }

    private void assertTreeProperties(Node node) {
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_1, String.class), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_1, Date.class), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_1, String.class), (Matcher)Matchers.is(Optional.of(VALUE_1)));
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_1, Date.class), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_2, String.class), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_2, Date.class), (Matcher)Matchers.is(Optional.of(VALUE_2)));
        MatcherAssert.assertThat((Object)node.getTreeProperties().size(), (Matcher)Matchers.is((Object)2));
        this.treeProperties.put(KEY_3, VALUE_3);
        MatcherAssert.assertThat((Object)node.getTreeProperties().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_3, String.class), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)node.getTreeProperty(KEY_3, Integer.class), (Matcher)Matchers.is(Optional.of(VALUE_3)));
        this.treeProperties.remove(KEY_3);
        MatcherAssert.assertThat((Object)node.getTreeProperties().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)node.getTreeProperties(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)KEY_3)));
    }

    private void assertNodeProperty(Node node, String key, Object value) {
        if (value != null) {
            MatcherAssert.assertThat((Object)node.getNodeProperty(key, value.getClass()), (Matcher)Matchers.is(Optional.of(value)));
            MatcherAssert.assertThat((Object)node.getNodeProperty(key, Object.class), (Matcher)Matchers.is(Optional.of(value)));
            MatcherAssert.assertThat((Object)node.getNodeProperty(key, Throwable.class), (Matcher)Matchers.is(Optional.empty()));
        } else {
            MatcherAssert.assertThat((Object)node.getNodeProperty(key, Object.class), (Matcher)Matchers.is(Optional.empty()));
        }
    }

    private void assertEdgeProperty(Node node, String key, Object value) {
        if (value != null) {
            MatcherAssert.assertThat((Object)node.getEdgeProperty(key, value.getClass()), (Matcher)Matchers.is(Optional.of(value)));
            MatcherAssert.assertThat((Object)node.getEdgeProperty(key, Object.class), (Matcher)Matchers.is(Optional.of(value)));
            MatcherAssert.assertThat((Object)node.getEdgeProperty(key, Throwable.class), (Matcher)Matchers.is(Optional.empty()));
        } else {
            MatcherAssert.assertThat((Object)node.getEdgeProperty(key, Object.class), (Matcher)Matchers.is(Optional.empty()));
        }
    }

    private class Node
    extends DefaultTreeNode<Node> {
        public Node() {
            super(DefaultTreeNodeTest.this.treeProperties);
        }

        public Node(String id) {
            super(DefaultTreeNodeTest.this.treeProperties);
            this.setId(id);
        }

        public Node(Node parent, String id) {
            super(DefaultTreeNodeTest.this.treeProperties);
            this.setId(id);
            this.setParent(parent);
        }

        public String getLabel() {
            return this.getId() == null ? "Node:" + System.identityHashCode((Object)this) : this.getId();
        }
    }
}

