/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.tree;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityFields;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.realm.MapRealmEntity;
import org.keycloak.models.map.storage.ModelEntityUtil;
import org.keycloak.models.map.storage.tree.TreeStorageNodePrescription;

public class TreeStorageNodePrescriptionTest {
    @Test
    public void testEmpty() {
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(null);
        TreeStorageNodePrescription c1 = n.forEntityClass(MapClientEntity.class);
        TreeStorageNodePrescription c2 = n.forEntityClass(MapClientEntity.class);
        TreeStorageNodePrescription r1 = n.forEntityClass(MapRealmEntity.class);
        MatcherAssert.assertThat((Object)c1, (Matcher)Matchers.sameInstance((Object)c2));
        MatcherAssert.assertThat((Object)c1, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)r1)));
        MatcherAssert.assertThat(c1.getNodeProperties().entrySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat(c1.getEdgeProperties().entrySet(), (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)c1.getTreeProperties().size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)c1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"model-class", ClientModel.class));
        MatcherAssert.assertThat((Object)r1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"model-class", RealmModel.class));
    }

    @Test
    public void testTreePropertyProjection() {
        HashMap<Object, String> treeProperties = new HashMap<Object, String>();
        treeProperties.put("prop[" + ModelEntityUtil.getModelName(ClientModel.class) + "]", "propClientValue");
        treeProperties.put("prop[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmValue");
        treeProperties.put("propRealmOnly[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmOnlyValue");
        treeProperties.put("propBoth", "propBothValue");
        HashMap<Object, String> nodeProperties = new HashMap<Object, String>();
        nodeProperties.put("nprop[" + ModelEntityUtil.getModelName(ClientModel.class) + "]", "propClientValue");
        nodeProperties.put("nprop[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmValue");
        nodeProperties.put("npropRealmOnly[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmOnlyValue");
        nodeProperties.put("npropBoth", "propBothValue");
        HashMap<Object, String> edgeProperties = new HashMap<Object, String>();
        edgeProperties.put("eprop[" + ModelEntityUtil.getModelName(ClientModel.class) + "]", "propClientValue");
        edgeProperties.put("eprop[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmValue");
        edgeProperties.put("epropRealmOnly[" + ModelEntityUtil.getModelName(RealmModel.class) + "]", "propRealmOnlyValue");
        edgeProperties.put("epropBoth", "propBothValue");
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, edgeProperties, treeProperties);
        TreeStorageNodePrescription c1 = n.forEntityClass(MapClientEntity.class);
        TreeStorageNodePrescription r1 = n.forEntityClass(MapRealmEntity.class);
        MatcherAssert.assertThat((Object)c1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"model-class", ClientModel.class));
        MatcherAssert.assertThat((Object)c1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"prop", (Object)"propClientValue"));
        MatcherAssert.assertThat((Object)c1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"propBoth", (Object)"propBothValue"));
        MatcherAssert.assertThat((Object)c1.getTreeProperties().size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)c1.getNodeProperties(), (Matcher)Matchers.hasEntry((Object)"nprop", (Object)"propClientValue"));
        MatcherAssert.assertThat((Object)c1.getNodeProperties(), (Matcher)Matchers.hasEntry((Object)"npropBoth", (Object)"propBothValue"));
        MatcherAssert.assertThat((Object)c1.getNodeProperties().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)c1.getEdgeProperties(), (Matcher)Matchers.hasEntry((Object)"eprop", (Object)"propClientValue"));
        MatcherAssert.assertThat((Object)c1.getEdgeProperties(), (Matcher)Matchers.hasEntry((Object)"epropBoth", (Object)"propBothValue"));
        MatcherAssert.assertThat((Object)c1.getEdgeProperties().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)r1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"model-class", RealmModel.class));
        MatcherAssert.assertThat((Object)r1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"prop", (Object)"propRealmValue"));
        MatcherAssert.assertThat((Object)r1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"propRealmOnly", (Object)"propRealmOnlyValue"));
        MatcherAssert.assertThat((Object)r1.getTreeProperties(), (Matcher)Matchers.hasEntry((Object)"propBoth", (Object)"propBothValue"));
        MatcherAssert.assertThat((Object)r1.getTreeProperties().size(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testPrimarySourceForBasicUnset() {
        HashMap nodeProperties = new HashMap();
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, null, null);
        for (MapClientEntityFields field : MapClientEntityFields.values()) {
            MatcherAssert.assertThat((String)("Field " + field + " has primary source in this node"), (Object)n.isPrimarySourceFor((EntityField)field, null), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.FULLY));
        }
    }

    @Test
    public void testPrimarySourceForBasicSet() {
        HashMap nodeProperties = new HashMap();
        EnumMap<MapClientEntityFields, Object> primarySourceFor = new EnumMap<MapClientEntityFields, Object>(MapClientEntityFields.class);
        for (MapClientEntityFields field : MapClientEntityFields.values()) {
            primarySourceFor.put(field, (Object)null);
        }
        nodeProperties.put("___primary-source-for___", primarySourceFor);
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, null, null);
        for (MapClientEntityFields field : MapClientEntityFields.values()) {
            MatcherAssert.assertThat((String)("Field " + field + " has primary source in this node"), (Object)n.isPrimarySourceFor((EntityField)field, null), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.FULLY));
        }
    }

    @Test
    public void testPrimarySourceForBasicSetId() {
        HashMap nodeProperties = new HashMap();
        EnumMap<MapClientEntityFields, Object> primarySourceFor = new EnumMap<MapClientEntityFields, Object>(MapClientEntityFields.class);
        nodeProperties.put("___primary-source-for___", primarySourceFor);
        primarySourceFor.put(MapClientEntityFields.ID, (Object)null);
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, null, null);
        for (MapClientEntityFields field : MapClientEntityFields.values()) {
            MatcherAssert.assertThat((Object)n.isPrimarySourceFor((EntityField)field, null), (Matcher)Matchers.is((Object)(field == MapClientEntityFields.ID ? TreeStorageNodePrescription.FieldContainedStatus.FULLY : TreeStorageNodePrescription.FieldContainedStatus.NOT_CONTAINED)));
        }
    }

    @Test
    public void testPrimarySourceForWithExcluded() {
        HashMap nodeProperties = new HashMap();
        EnumMap<MapClientEntityFields, Object> primarySourceForExcluded = new EnumMap<MapClientEntityFields, Object>(MapClientEntityFields.class);
        nodeProperties.put("___primary-source-for-excluded___", primarySourceForExcluded);
        primarySourceForExcluded.put(MapClientEntityFields.ATTRIBUTES, (Object)null);
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, null, null);
        for (MapClientEntityFields field : MapClientEntityFields.values()) {
            MatcherAssert.assertThat((Object)n.isPrimarySourceFor((EntityField)field, null), (Matcher)Matchers.is((Object)(field == MapClientEntityFields.ATTRIBUTES ? TreeStorageNodePrescription.FieldContainedStatus.NOT_CONTAINED : TreeStorageNodePrescription.FieldContainedStatus.FULLY)));
        }
    }

    @Test
    public void testPrimarySourceForWithExcludedTwoAttributes() {
        HashMap nodeProperties = new HashMap();
        EnumMap<MapClientEntityFields, Object> primarySourceFor = new EnumMap<MapClientEntityFields, Object>(MapClientEntityFields.class);
        nodeProperties.put("___primary-source-for___", primarySourceFor);
        primarySourceFor.put(MapClientEntityFields.ATTRIBUTES, (Object)null);
        EnumMap<MapClientEntityFields, List<String>> primarySourceForExcluded = new EnumMap<MapClientEntityFields, List<String>>(MapClientEntityFields.class);
        nodeProperties.put("___primary-source-for-excluded___", primarySourceForExcluded);
        primarySourceForExcluded.put(MapClientEntityFields.ATTRIBUTES, Arrays.asList("attr1", "attr2"));
        TreeStorageNodePrescription n = new TreeStorageNodePrescription(nodeProperties, null, null);
        MatcherAssert.assertThat((String)"Field ID has NOT primary source in this node", (Object)n.isPrimarySourceFor((EntityField)MapClientEntityFields.ID, null), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.NOT_CONTAINED));
        MatcherAssert.assertThat((String)"Attribute attr1 has NOT primary source in this node", (Object)n.isPrimarySourceFor((EntityField)MapClientEntityFields.ATTRIBUTES, (Object)"attr1"), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.NOT_CONTAINED));
        MatcherAssert.assertThat((String)"Attribute attr2 has NOT primary source in this node", (Object)n.isPrimarySourceFor((EntityField)MapClientEntityFields.ATTRIBUTES, (Object)"attr2"), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.NOT_CONTAINED));
        MatcherAssert.assertThat((String)"Attribute attr3 has primary source in this node", (Object)n.isPrimarySourceFor((EntityField)MapClientEntityFields.ATTRIBUTES, (Object)"attr3"), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.FULLY));
        MatcherAssert.assertThat((String)"Attributes have primary source in this node and other source in some other nodes", (Object)n.isPrimarySourceFor((EntityField)MapClientEntityFields.ATTRIBUTES, null), (Matcher)Matchers.is((Object)TreeStorageNodePrescription.FieldContainedStatus.PARTIALLY));
    }
}

