/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.user;

import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserCredentialEntityImpl;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserEntityImpl;

public class MapUserEntityImplCredentialsOrderTest {
    private MapUserEntity user;
    private static final DeepCloner CLONER = new DeepCloner.Builder().constructor(MapUserCredentialEntityImpl.class, MapUserCredentialEntityImpl::new).build();

    @Before
    public void init() {
        this.user = new MapUserEntityImpl(CLONER);
        for (int i = 1; i <= 5; ++i) {
            MapUserCredentialEntity credentialModel = (MapUserCredentialEntity)DeepCloner.DUMB_CLONER.newInstance(MapUserCredentialEntity.class);
            credentialModel.setId(Integer.toString(i));
            this.user.addCredential(credentialModel);
        }
        this.user.clearUpdatedFlag();
    }

    private void assertOrder(Integer ... ids) {
        List currentList = this.user.getCredentials().stream().map(entity -> Integer.valueOf(entity.getId())).collect(Collectors.toList());
        MatcherAssert.assertThat(currentList, (Matcher)Matchers.contains((Object[])ids));
    }

    @Test
    public void testCorrectOrder() {
        this.assertOrder(1, 2, 3, 4, 5);
    }

    @Test
    public void testMoveToZero() {
        this.user.moveCredential("3", null);
        this.assertOrder(3, 1, 2, 4, 5);
        MatcherAssert.assertThat((Object)this.user.isUpdated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testMoveBack() {
        this.user.moveCredential("4", "1");
        this.assertOrder(1, 4, 2, 3, 5);
        MatcherAssert.assertThat((Object)this.user.isUpdated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testMoveForward() {
        this.user.moveCredential("2", "4");
        this.assertOrder(1, 3, 4, 2, 5);
        MatcherAssert.assertThat((Object)this.user.isUpdated(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testSamePosition() {
        this.user.moveCredential("2", "1");
        this.assertOrder(1, 2, 3, 4, 5);
        MatcherAssert.assertThat((Object)this.user.isUpdated(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testSamePositionZero() {
        this.user.moveCredential("1", null);
        this.assertOrder(1, 2, 3, 4, 5);
        MatcherAssert.assertThat((Object)this.user.isUpdated(), (Matcher)CoreMatchers.is((Object)false));
    }
}

