/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.impl.types;

import com.mongodb.BasicDBObject;
import java.util.Collection;
import org.keycloak.models.mongo.api.MongoEntity;
import org.keycloak.models.mongo.api.types.Mapper;
import org.keycloak.models.mongo.api.types.MapperContext;
import org.keycloak.models.mongo.api.types.MapperRegistry;
import org.keycloak.models.mongo.impl.EntityInfo;
import org.keycloak.models.mongo.impl.MongoStoreImpl;
import org.picketlink.common.properties.Property;

public class MongoEntityMapper<T extends MongoEntity>
implements Mapper<T, BasicDBObject> {
    private final MongoStoreImpl mongoStoreImpl;
    private final MapperRegistry mapperRegistry;
    private final Class<T> expectedMongoEntityType;

    public MongoEntityMapper(MongoStoreImpl mongoStoreImpl, MapperRegistry mapperRegistry, Class<T> expectedMongoEntityType) {
        this.mongoStoreImpl = mongoStoreImpl;
        this.mapperRegistry = mapperRegistry;
        this.expectedMongoEntityType = expectedMongoEntityType;
    }

    @Override
    public BasicDBObject convertObject(MapperContext<T, BasicDBObject> context) {
        MongoEntity applicationObject = (MongoEntity)context.getObjectToConvert();
        EntityInfo entityInfo = this.mongoStoreImpl.getEntityInfo(applicationObject.getClass());
        BasicDBObject dbObject = new BasicDBObject();
        Collection<Property<Object>> props = entityInfo.getProperties();
        for (Property<Object> property : props) {
            String propName = property.getName();
            Object propValue = property.getValue((Object)applicationObject);
            Object dbValue = propValue == null ? null : this.mapperRegistry.convertApplicationObjectToDBObject(propValue, Object.class);
            dbObject.put(propName, dbValue);
        }
        return dbObject;
    }

    @Override
    public Class<? extends T> getTypeOfObjectToConvert() {
        return this.expectedMongoEntityType;
    }

    @Override
    public Class<BasicDBObject> getExpectedReturnType() {
        return BasicDBObject.class;
    }
}

