/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.OAuthClientEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;

public class OAuthClientAdapter
extends AbstractAdapter
implements OAuthClientModel {
    private final OAuthClientEntity delegate;
    private UserAdapter oauthAgent;

    public OAuthClientAdapter(OAuthClientEntity oauthClientEntity, UserAdapter oauthAgent, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.delegate = oauthClientEntity;
        this.oauthAgent = oauthAgent;
    }

    public OAuthClientAdapter(OAuthClientEntity oauthClientEntity, MongoStoreInvocationContext invContext) {
        this(oauthClientEntity, null, invContext);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public UserModel getOAuthAgent() {
        if (this.oauthAgent == null) {
            UserEntity user = this.getMongoStore().loadEntity(UserEntity.class, this.delegate.getOauthAgentId(), this.invocationContext);
            this.oauthAgent = user != null ? new UserAdapter(user, this.invocationContext) : null;
        }
        return this.oauthAgent;
    }

    @Override
    public AbstractMongoIdentifiableEntity getMongoEntity() {
        return this.delegate;
    }
}

