/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ApplicationAdapter;
import org.keycloak.models.mongo.keycloak.adapters.OAuthClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.ApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.CredentialEntity;
import org.keycloak.models.mongo.keycloak.entities.OAuthClientEntity;
import org.keycloak.models.mongo.keycloak.entities.RealmEntity;
import org.keycloak.models.mongo.keycloak.entities.RequiredCredentialEntity;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.mongo.keycloak.entities.SocialLinkEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;

public class RealmAdapter
extends AbstractAdapter
implements RealmModel {
    private static final Logger logger = Logger.getLogger(RealmAdapter.class);
    private final RealmEntity realm;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private volatile transient PasswordPolicy passwordPolicy;

    public RealmAdapter(RealmEntity realmEntity, MongoStoreInvocationContext invocationContext) {
        super(invocationContext);
        this.realm = realmEntity;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.updateRealm();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }

    public int getTokenLifespan() {
        return this.realm.getTokenLifespan();
    }

    public void setTokenLifespan(int tokenLifespan) {
        this.realm.setTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
        this.updateRealm();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
        this.updateRealm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.updateRealm();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.updateRealm();
    }

    public UserAdapter getUser(String name) {
        DBObject query = new QueryBuilder().and("loginName").is((Object)name).and("realmId").is((Object)this.getId()).get();
        UserEntity user = this.getMongoStore().loadSingleEntity(UserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(user, this.invocationContext);
    }

    public UserModel getUserByEmail(String email) {
        DBObject query = new QueryBuilder().and("email").is((Object)email).and("realmId").is((Object)this.getId()).get();
        UserEntity user = this.getMongoStore().loadSingleEntity(UserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(user, this.invocationContext);
    }

    public UserAdapter addUser(String username) {
        UserAdapter userModel = this.addUserEntity(username);
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                this.grantRole(userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(String username) {
        if (this.getUser(username) != null) {
            throw new IllegalArgumentException("User " + username + " already exists");
        }
        UserEntity userEntity = new UserEntity();
        userEntity.setLoginName(username);
        userEntity.setEnabled(true);
        userEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return new UserAdapter(userEntity, this.invocationContext);
    }

    public boolean removeUser(String name) {
        DBObject query = new QueryBuilder().and("loginName").is((Object)name).and("realmId").is((Object)this.getId()).get();
        return this.getMongoStore().removeEntities(UserEntity.class, query, this.invocationContext);
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("realmId").is((Object)this.getId()).get();
        RoleEntity role = this.getMongoStore().loadSingleEntity(RoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext);
    }

    public RoleModel addRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role != null) {
            return role;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRoleById(String id) {
        return this.getMongoStore().removeEntity(RoleEntity.class, id, this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<RoleEntity> roles = this.getMongoStore().loadEntities(RoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        if (roles == null) {
            return result;
        }
        for (RoleEntity role : roles) {
            result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public RoleModel getRoleById(String id) {
        RoleEntity role = this.getMongoStore().loadEntity(RoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext);
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.realm, "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public ApplicationModel getApplicationById(String id) {
        ApplicationEntity appData = this.getMongoStore().loadEntity(ApplicationEntity.class, id, this.invocationContext);
        if (appData == null || !this.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ApplicationAdapter(appData, this.invocationContext);
    }

    public ApplicationModel getApplicationByName(String name) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("name").is((Object)name).get();
        ApplicationEntity appEntity = this.getMongoStore().loadSingleEntity(ApplicationEntity.class, query, this.invocationContext);
        return appEntity == null ? null : new ApplicationAdapter(appEntity, this.invocationContext);
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> resourceMap = new HashMap<String, ApplicationModel>();
        for (ApplicationModel resource : this.getApplications()) {
            resourceMap.put(resource.getName(), resource);
        }
        return resourceMap;
    }

    public List<ApplicationModel> getApplications() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<ApplicationEntity> appDatas = this.getMongoStore().loadEntities(ApplicationEntity.class, query, this.invocationContext);
        ArrayList<ApplicationModel> result = new ArrayList<ApplicationModel>();
        for (ApplicationEntity appData : appDatas) {
            result.add(new ApplicationAdapter(appData, this.invocationContext));
        }
        return result;
    }

    public ApplicationModel addApplication(String name) {
        UserAdapter resourceUser = this.addUserEntity(name);
        ApplicationEntity appData = new ApplicationEntity();
        appData.setName(name);
        appData.setRealmId(this.getId());
        appData.setEnabled(true);
        appData.setResourceUserId(resourceUser.getUser().getId());
        this.getMongoStore().insertEntity(appData, this.invocationContext);
        return new ApplicationAdapter(appData, resourceUser, this.invocationContext);
    }

    public boolean removeApplication(String id) {
        return this.getMongoStore().removeEntity(ApplicationEntity.class, id, this.invocationContext);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings(user);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void grantRole(UserModel user, RoleModel role) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pushItemToList(userEntity, "roleIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllRolesOfUser(user, this.invocationContext);
        for (RoleEntity role : roles) {
            if (this.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmRoleMappings(UserModel user) {
        Set<RoleModel> allRoles = this.getRoleMappings(user);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            RoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pullItemFromList(userEntity, "roleIds", role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getScopeMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleEntity> roles = MongoModelUtils.getAllScopesOfUser(user, this.invocationContext);
        for (RoleEntity role : roles) {
            if (this.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(role, (RoleContainerModel)this, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmScopeMappings(UserModel user) {
        Set<RoleModel> allScopes = this.getScopeMappings(user);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            RoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        UserEntity userEntity = ((UserAdapter)agent).getUser();
        this.getMongoStore().pushItemToList(userEntity, "scopeIds", role.getId(), true, this.invocationContext);
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pullItemFromList(userEntity, "scopeIds", role.getId(), this.invocationContext);
    }

    public OAuthClientModel addOAuthClient(String name) {
        UserAdapter oauthAgent = this.addUserEntity(name);
        OAuthClientEntity oauthClient = new OAuthClientEntity();
        oauthClient.setOauthAgentId(oauthAgent.getUser().getId());
        oauthClient.setRealmId(this.getId());
        oauthClient.setName(name);
        this.getMongoStore().insertEntity(oauthClient, this.invocationContext);
        return new OAuthClientAdapter(oauthClient, oauthAgent, this.invocationContext);
    }

    public boolean removeOAuthClient(String id) {
        return this.getMongoStore().removeEntity(OAuthClientEntity.class, id, this.invocationContext);
    }

    public OAuthClientModel getOAuthClient(String name) {
        UserAdapter user = this.getUser(name);
        if (user == null) {
            return null;
        }
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("oauthAgentId").is((Object)user.getUser().getId()).get();
        OAuthClientEntity oauthClient = this.getMongoStore().loadSingleEntity(OAuthClientEntity.class, query, this.invocationContext);
        return oauthClient == null ? null : new OAuthClientAdapter(oauthClient, user, this.invocationContext);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        OAuthClientEntity clientEntity = this.getMongoStore().loadEntity(OAuthClientEntity.class, id, this.invocationContext);
        if (clientEntity == null) {
            return null;
        }
        return new OAuthClientAdapter(clientEntity, this.invocationContext);
    }

    public List<OAuthClientModel> getOAuthClients() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<OAuthClientEntity> results = this.getMongoStore().loadEntities(OAuthClientEntity.class, query, this.invocationContext);
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientEntity data : results) {
            list.add(new OAuthClientAdapter(data, this.invocationContext));
        }
        return list;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredCredentials());
    }

    public void addRequiredResourceCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredApplicationCredentials());
    }

    public void addRequiredOAuthClientCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredOAuthClientCredentials());
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
        this.updateRealm();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    public void updateRequiredApplicationCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredApplicationCredentials());
    }

    public void updateRequiredOAuthClientCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredOAuthClientCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            logger.info((Object)("updating cred: " + cred));
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    public List<RequiredCredentialModel> getRequiredApplicationCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredApplicationCredentials());
    }

    public List<RequiredCredentialModel> getRequiredOAuthClientCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredOAuthClientCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setInput(entity.isInput());
            model.setSecret(entity.isSecret());
            model.setType(entity.getType());
            result.add(model);
        }
        return result;
    }

    public boolean validatePassword(UserModel user, String password) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("password")) continue;
            return new Pbkdf2PasswordEncoder(cred.getSalt()).verify(password, cred.getValue());
        }
        return false;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        if (!this.validatePassword(user, password)) {
            return false;
        }
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("totp")) continue;
            return new TimeBasedOTP().validate(token, cred.getValue().getBytes());
        }
        return false;
    }

    public boolean validateSecret(UserModel user, String secret) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("secret")) continue;
            return secret.equals(cred.getValue());
        }
        return false;
    }

    public UserCredentialModel getSecret(UserModel user) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("secret")) continue;
            return UserCredentialModel.secret((String)cred.getValue());
        }
        return null;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = null;
        UserEntity userEntity = ((UserAdapter)user).getUser();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(cred.getType())) continue;
            credentialEntity = entity;
        }
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            userEntity.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue()));
            credentialEntity.setSalt(salt);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        DBObject query = new QueryBuilder().and("socialLinks.socialProvider").is((Object)socialLink.getSocialProvider()).and("socialLinks.socialUsername").is((Object)socialLink.getSocialUsername()).and("realmId").is((Object)this.getId()).get();
        UserEntity userEntity = this.getMongoStore().loadSingleEntity(UserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(userEntity, this.invocationContext);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        List<SocialLinkEntity> linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<SocialLinkModel> result = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            SocialLinkModel model = new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUsername());
            result.add(model);
        }
        return result;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        UserEntity userEntity = ((UserAdapter)user).getUser();
        SocialLinkEntity socialLinkEntity = new SocialLinkEntity();
        socialLinkEntity.setSocialProvider(socialLink.getSocialProvider());
        socialLinkEntity.setSocialUsername(socialLink.getSocialUsername());
        this.getMongoStore().pushItemToList(userEntity, "socialLinks", socialLinkEntity, true, this.invocationContext);
    }

    public void removeSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkEntity socialLinkEntity = new SocialLinkEntity();
        socialLinkEntity.setSocialProvider(socialLink.getSocialProvider());
        socialLinkEntity.setSocialUsername(socialLink.getSocialUsername());
        UserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pullItemFromList(userEntity, "socialLinks", socialLinkEntity, this.invocationContext);
    }

    protected void updateRealm() {
        this.getMongoStore().updateEntity(this.realm, this.invocationContext);
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public List<UserModel> getUsers() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<UserEntity> users = this.getMongoStore().loadEntities(UserEntity.class, query, this.invocationContext);
        return this.convertUserEntities(users);
    }

    public List<UserModel> searchForUser(String search) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)this.getId()).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("loginName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        List<UserEntity> users = this.getMongoStore().loadEntities(UserEntity.class, builder.get(), this.invocationContext);
        return this.convertUserEntities(users);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)this.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equals("username")) {
                queryBuilder.and("loginName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
        }
        List<UserEntity> users = this.getMongoStore().loadEntities(UserEntity.class, queryBuilder.get(), this.invocationContext);
        return this.convertUserEntities(users);
    }

    protected List<UserModel> convertUserEntities(List<UserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (UserEntity user : userEntities) {
            userModels.add(new UserAdapter(user, this.invocationContext));
        }
        return userModels;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.updateRealm();
    }

    @Override
    public AbstractMongoIdentifiableEntity getMongoEntity() {
        return this.realm;
    }
}

