/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ApplicationAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RealmAdapter;
import org.keycloak.models.mongo.keycloak.entities.ApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.RealmEntity;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
extends AbstractAdapter
implements RoleModel {
    private final RoleEntity role;
    private RoleContainerModel roleContainer;

    public RoleAdapter(RoleEntity roleEntity, MongoStoreInvocationContext invContext) {
        this(roleEntity, null, invContext);
    }

    public RoleAdapter(RoleEntity roleEntity, RoleContainerModel roleContainer, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.role = roleEntity;
        this.roleContainer = roleContainer;
    }

    public String getId() {
        return this.role.getId();
    }

    public String getName() {
        return this.role.getName();
    }

    public void setName(String name) {
        this.role.setName(name);
        this.updateRole();
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
        this.updateRole();
    }

    public boolean isComposite() {
        return this.role.getCompositeRoleIds() != null && this.role.getCompositeRoleIds().size() > 0;
    }

    protected void updateRole() {
        this.getMongoStore().updateEntity(this.role, this.invocationContext);
    }

    public void addCompositeRole(RoleModel childRole) {
        this.getMongoStore().pushItemToList(this.role, "compositeRoleIds", childRole.getId(), true, this.invocationContext);
    }

    public void removeCompositeRole(RoleModel childRole) {
        this.getMongoStore().pullItemFromList(this.role, "compositeRoleIds", childRole.getId(), this.invocationContext);
    }

    public Set<RoleModel> getComposites() {
        if (this.role.getCompositeRoleIds() == null || this.role.getCompositeRoleIds().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        DBObject query = new QueryBuilder().and("_id").in(this.role.getCompositeRoleIds()).get();
        List<RoleEntity> childRoles = this.getMongoStore().loadEntities(RoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (RoleEntity childRole : childRoles) {
            set.add(new RoleAdapter(childRole, this.invocationContext));
        }
        return set;
    }

    public RoleContainerModel getContainer() {
        if (this.roleContainer == null) {
            if (this.role.getRealmId() != null) {
                RealmEntity realm = this.getMongoStore().loadEntity(RealmEntity.class, this.role.getRealmId(), this.invocationContext);
                if (realm == null) {
                    throw new IllegalStateException("Realm with id: " + this.role.getRealmId() + " doesn't exists");
                }
                this.roleContainer = new RealmAdapter(realm, this.invocationContext);
            } else if (this.role.getApplicationId() != null) {
                ApplicationEntity appEntity = this.getMongoStore().loadEntity(ApplicationEntity.class, this.role.getApplicationId(), this.invocationContext);
                if (appEntity == null) {
                    throw new IllegalStateException("Application with id: " + this.role.getApplicationId() + " doesn't exists");
                }
                this.roleContainer = new ApplicationAdapter(appEntity, this.invocationContext);
            } else {
                throw new IllegalStateException("Both realmId and applicationId are null for role: " + this);
            }
        }
        return this.roleContainer;
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public RoleEntity getRole() {
        return this.role;
    }

    @Override
    public AbstractMongoIdentifiableEntity getMongoEntity() {
        return this.role;
    }
}

