/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.mongo.api.AbstractMongoIdentifiableEntity;
import org.keycloak.models.mongo.api.MongoCollection;
import org.keycloak.models.mongo.api.MongoEntity;
import org.keycloak.models.mongo.api.MongoField;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.RoleEntity;
import org.keycloak.models.mongo.keycloak.entities.UserEntity;

@MongoCollection(collectionName="applications")
public class ApplicationEntity
extends AbstractMongoIdentifiableEntity
implements MongoEntity {
    private String name;
    private boolean enabled;
    private boolean surrogateAuthRequired;
    private String managementUrl;
    private String baseUrl;
    private String resourceUserId;
    private String realmId;
    private List<String> defaultRoles = new ArrayList<String>();

    @MongoField
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @MongoField
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @MongoField
    public boolean isSurrogateAuthRequired() {
        return this.surrogateAuthRequired;
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.surrogateAuthRequired = surrogateAuthRequired;
    }

    @MongoField
    public String getManagementUrl() {
        return this.managementUrl;
    }

    public void setManagementUrl(String managementUrl) {
        this.managementUrl = managementUrl;
    }

    @MongoField
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @MongoField
    public String getResourceUserId() {
        return this.resourceUserId;
    }

    public void setResourceUserId(String resourceUserId) {
        this.resourceUserId = resourceUserId;
    }

    @MongoField
    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @MongoField
    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public void setDefaultRoles(List<String> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext context) {
        context.getMongoStore().removeEntity(UserEntity.class, this.resourceUserId, context);
        DBObject query = new QueryBuilder().and("applicationId").is((Object)this.getId()).get();
        context.getMongoStore().removeEntities(RoleEntity.class, query, context);
    }
}

