/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.utils;

import org.keycloak.models.mongo.utils.MongoConfiguration;

public class SystemPropertiesConfigurationProvider {
    private static final String MONGO_HOST = "keycloak.mongo.host";
    private static final String MONGO_PORT = "keycloak.mongo.port";
    private static final String MONGO_DB_NAME = "keycloak.mongo.db";
    private static final String MONGO_CLEAR_ON_STARTUP = "keycloak.mongo.clearOnStartup";
    private static final String MONGO_HOST_2 = "mongo.host";
    private static final String MONGO_PORT_2 = "mongo.port";
    private static final String MONGO_DB_NAME_2 = "mongo.db";
    private static final String MONGO_CLEAR_ON_STARTUP_2 = "mongo.clearCollectionsOnStartup";
    private static final String MONGO_DEFAULT_PORT = "27017";

    public static String getMongoHost() {
        return SystemPropertiesConfigurationProvider.getSystemPropertyWithFallback(MONGO_HOST, MONGO_HOST_2, "localhost");
    }

    public static int getMongoPort() {
        String portProp = SystemPropertiesConfigurationProvider.getSystemPropertyWithFallback(MONGO_PORT, MONGO_PORT_2, MONGO_DEFAULT_PORT);
        return Integer.parseInt(portProp);
    }

    public static String getMongoDbName() {
        return SystemPropertiesConfigurationProvider.getSystemPropertyWithFallback(MONGO_DB_NAME, MONGO_DB_NAME_2, "keycloak");
    }

    public static boolean isClearCollectionsOnStartup() {
        String property = SystemPropertiesConfigurationProvider.getSystemPropertyWithFallback(MONGO_CLEAR_ON_STARTUP, MONGO_CLEAR_ON_STARTUP_2, "false");
        return "true".equalsIgnoreCase(property);
    }

    private static String getSystemPropertyWithFallback(String propName1, String propName2, String defaultValue) {
        String propValue1 = System.getProperty(propName1);
        return propValue1 != null ? propValue1 : System.getProperty(propName2, defaultValue);
    }

    public static MongoConfiguration createConfiguration() {
        return new MongoConfiguration(SystemPropertiesConfigurationProvider.getMongoHost(), SystemPropertiesConfigurationProvider.getMongoPort(), SystemPropertiesConfigurationProvider.getMongoDbName(), SystemPropertiesConfigurationProvider.isClearCollectionsOnStartup());
    }
}

