/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.ClientEntity;

public class ClientAdapter<T extends ClientEntity>
extends AbstractMongoAdapter<T>
implements ClientModel {
    private final T clientEntity;
    private final RealmModel realm;

    public ClientAdapter(RealmModel realm, T clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.clientEntity = clientEntity;
        this.realm = realm;
    }

    @Override
    public T getMongoEntity() {
        return this.clientEntity;
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getClientId() {
        return ((ClientEntity)this.getMongoEntity()).getName();
    }

    public long getAllowedClaimsMask() {
        return ((ClientEntity)this.getMongoEntity()).getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        ((ClientEntity)this.getMongoEntity()).setAllowedClaimsMask(mask);
        this.updateMongoEntity();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (((ClientEntity)this.getMongoEntity()).getWebOrigins() != null) {
            result.addAll(((ClientEntity)this.clientEntity).getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        ((ClientEntity)this.clientEntity).setWebOrigins(result);
        this.updateMongoEntity();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (((ClientEntity)this.clientEntity).getRedirectUris() != null) {
            result.addAll(((ClientEntity)this.clientEntity).getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        ((ClientEntity)this.clientEntity).setRedirectUris(result);
        this.updateMongoEntity();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", redirectUri, this.invocationContext);
    }

    public boolean isEnabled() {
        return ((ClientEntity)this.clientEntity).isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ((ClientEntity)this.clientEntity).setEnabled(enabled);
        this.updateMongoEntity();
    }

    public boolean validateSecret(String secret) {
        return secret.equals(((ClientEntity)this.clientEntity).getSecret());
    }

    public String getSecret() {
        return ((ClientEntity)this.clientEntity).getSecret();
    }

    public void setSecret(String secret) {
        ((ClientEntity)this.clientEntity).setSecret(secret);
        this.updateMongoEntity();
    }

    public boolean isPublicClient() {
        return ((ClientEntity)this.clientEntity).isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        ((ClientEntity)this.clientEntity).setPublicClient(flag);
        this.updateMongoEntity();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return ((ClientEntity)this.clientEntity).getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        ((ClientEntity)this.clientEntity).setNotBefore(notBefore);
        this.updateMongoEntity();
    }
}

