/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.config;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import java.net.UnknownHostException;
import org.jboss.logging.Logger;
import org.keycloak.models.mongo.keycloak.config.MongoClientProvider;

public class SystemPropertiesMongoClientProvider
implements MongoClientProvider {
    protected static final Logger logger = Logger.getLogger(SystemPropertiesMongoClientProvider.class);
    private static final String MONGO_HOST = "keycloak.mongo.host";
    private static final String MONGO_PORT = "keycloak.mongo.port";
    private static final String MONGO_DB_NAME = "keycloak.mongo.db";
    private static final String MONGO_CLEAR_ON_STARTUP = "keycloak.mongo.clearOnStartup";
    private static final String MONGO_HOST_2 = "mongo.host";
    private static final String MONGO_PORT_2 = "mongo.port";
    private static final String MONGO_DB_NAME_2 = "mongo.db";
    private static final String MONGO_CLEAR_ON_STARTUP_2 = "mongo.clearOnStartup";
    private static final String MONGO_DEFAULT_PORT = "27017";
    private MongoClient mongoClient;
    private DB db;

    @Override
    public synchronized MongoClient getMongoClient() {
        if (this.mongoClient == null) {
            this.init();
        }
        return this.mongoClient;
    }

    @Override
    public synchronized DB getDB() {
        if (this.mongoClient == null) {
            this.init();
        }
        return this.db;
    }

    @Override
    public boolean clearCollectionsOnStartup() {
        return SystemPropertiesMongoClientProvider.isClearCollectionsOnStartup();
    }

    @Override
    public synchronized void close() {
        logger.info((Object)"Closing MongoDB client");
        this.mongoClient.close();
        this.mongoClient = null;
        this.db = null;
    }

    protected void init() {
        try {
            String host = SystemPropertiesMongoClientProvider.getMongoHost();
            int port = SystemPropertiesMongoClientProvider.getMongoPort();
            String dbName = SystemPropertiesMongoClientProvider.getMongoDbName();
            boolean clearOnStartup = SystemPropertiesMongoClientProvider.isClearCollectionsOnStartup();
            logger.info((Object)String.format("Configuring MongoStore with: host=%s, port=%d, dbName=%s, clearOnStartup=%b", host, port, dbName, clearOnStartup));
            this.mongoClient = new MongoClient(host, port);
            this.db = this.mongoClient.getDB(dbName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMongoHost() {
        return SystemPropertiesMongoClientProvider.getSystemPropertyWithFallback(MONGO_HOST, MONGO_HOST_2, "localhost");
    }

    public static int getMongoPort() {
        String portProp = SystemPropertiesMongoClientProvider.getSystemPropertyWithFallback(MONGO_PORT, MONGO_PORT_2, MONGO_DEFAULT_PORT);
        return Integer.parseInt(portProp);
    }

    public static String getMongoDbName() {
        return SystemPropertiesMongoClientProvider.getSystemPropertyWithFallback(MONGO_DB_NAME, MONGO_DB_NAME_2, "keycloak");
    }

    public static boolean isClearCollectionsOnStartup() {
        String property = SystemPropertiesMongoClientProvider.getSystemPropertyWithFallback(MONGO_CLEAR_ON_STARTUP, MONGO_CLEAR_ON_STARTUP_2, "false");
        return "true".equalsIgnoreCase(property);
    }

    private static String getSystemPropertyWithFallback(String propName1, String propName2, String defaultValue) {
        String propValue1 = System.getProperty(propName1);
        return propValue1 != null ? propValue1 : System.getProperty(propName2, defaultValue);
    }
}

