/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.entities.AuthenticationLinkEntity;
import org.keycloak.models.entities.AuthenticationProviderEntity;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.SocialLinkEntity;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ApplicationAdapter;
import org.keycloak.models.mongo.keycloak.adapters.OAuthClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserSessionAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UsernameLoginFailureAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoOAuthClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserSessionEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUsernameLoginFailureEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.Pbkdf2PasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.util.Time;

public class RealmAdapter
extends AbstractMongoAdapter<MongoRealmEntity>
implements RealmModel {
    private static final Logger logger = Logger.getLogger(RealmAdapter.class);
    private final MongoRealmEntity realm;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private volatile transient PasswordPolicy passwordPolicy;

    public RealmAdapter(MongoRealmEntity realmEntity, MongoStoreInvocationContext invocationContext) {
        super(invocationContext);
        this.realm = realmEntity;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.updateRealm();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.updateRealm();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.updateRealm();
    }

    public boolean isPasswordCredentialGrantAllowed() {
        return this.realm.isPasswordCredentialGrantAllowed();
    }

    public void setPasswordCredentialGrantAllowed(boolean passwordCredentialGrantAllowed) {
        this.realm.setPasswordCredentialGrantAllowed(passwordCredentialGrantAllowed);
        this.updateRealm();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.updateRealm();
    }

    public boolean isRememberMe() {
        return this.realm.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.realm.setRememberMe(rememberMe);
        this.updateRealm();
    }

    public boolean isBruteForceProtected() {
        return this.realm.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.realm.setBruteForceProtected(value);
        this.updateRealm();
    }

    public int getMaxFailureWaitSeconds() {
        return this.realm.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.realm.setMaxFailureWaitSeconds(val);
        this.updateRealm();
    }

    public int getWaitIncrementSeconds() {
        return this.realm.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.realm.setWaitIncrementSeconds(val);
        this.updateRealm();
    }

    public long getQuickLoginCheckMilliSeconds() {
        return this.realm.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.realm.setQuickLoginCheckMilliSeconds(val);
        this.updateRealm();
    }

    public int getMinimumQuickLoginWaitSeconds() {
        return this.realm.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.realm.setMinimumQuickLoginWaitSeconds(val);
        this.updateRealm();
    }

    public int getMaxDeltaTimeSeconds() {
        return this.realm.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.realm.setMaxDeltaTimeSeconds(val);
        this.updateRealm();
    }

    public int getFailureFactor() {
        return this.realm.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.realm.setFailureFactor(failureFactor);
        this.updateRealm();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.updateRealm();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPassword) {
        this.realm.setResetPasswordAllowed(resetPassword);
        this.updateRealm();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.updateRealm();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.updateRealm();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.updateRealm();
    }

    public int getNotBefore() {
        return this.realm.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.realm.setNotBefore(notBefore);
        this.updateRealm();
    }

    public int getSsoSessionIdleTimeout() {
        return this.realm.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.realm.setSsoSessionIdleTimeout(seconds);
        this.updateRealm();
    }

    public int getSsoSessionMaxLifespan() {
        return this.realm.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.realm.setSsoSessionMaxLifespan(seconds);
        this.updateRealm();
    }

    public int getAccessTokenLifespan() {
        return this.realm.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int tokenLifespan) {
        this.realm.setAccessTokenLifespan(tokenLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.updateRealm();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.updateRealm();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.publicKey = null;
        this.updateRealm();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.privateKey = null;
        this.updateRealm();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getLoginTheme() {
        return this.realm.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.realm.setLoginTheme(name);
        this.updateRealm();
    }

    public String getAccountTheme() {
        return this.realm.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.realm.setAccountTheme(name);
        this.updateRealm();
    }

    public String getAdminTheme() {
        return this.realm.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.realm.setAdminTheme(name);
        this.updateRealm();
    }

    public String getEmailTheme() {
        return this.realm.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.realm.setEmailTheme(name);
        this.updateRealm();
    }

    public UserAdapter getUser(String name) {
        DBObject query = new QueryBuilder().and("loginName").is((Object)name).and("realmId").is((Object)this.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(user, this.invocationContext);
    }

    public UsernameLoginFailureAdapter getUserLoginFailure(String name) {
        DBObject query = new QueryBuilder().and("username").is((Object)name).and("realmId").is((Object)this.getId()).get();
        MongoUsernameLoginFailureEntity user = this.getMongoStore().loadSingleEntity(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(this.invocationContext, user);
    }

    public UsernameLoginFailureAdapter addUserLoginFailure(String username) {
        UsernameLoginFailureAdapter userLoginFailure = this.getUserLoginFailure(username);
        if (userLoginFailure != null) {
            return userLoginFailure;
        }
        MongoUsernameLoginFailureEntity userEntity = new MongoUsernameLoginFailureEntity();
        userEntity.setUsername(username);
        userEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return new UsernameLoginFailureAdapter(this.invocationContext, userEntity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoUsernameLoginFailureEntity> failures = this.getMongoStore().loadEntities(MongoUsernameLoginFailureEntity.class, query, this.invocationContext);
        ArrayList<UsernameLoginFailureModel> result = new ArrayList<UsernameLoginFailureModel>();
        if (failures == null) {
            return result;
        }
        for (MongoUsernameLoginFailureEntity failure : failures) {
            result.add(new UsernameLoginFailureAdapter(this.invocationContext, failure));
        }
        return result;
    }

    public UserModel getUserByEmail(String email) {
        DBObject query = new QueryBuilder().and("email").is((Object)email).and("realmId").is((Object)this.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(user, this.invocationContext);
    }

    public UserModel getUserById(String id) {
        MongoUserEntity user = this.getMongoStore().loadEntity(MongoUserEntity.class, id, this.invocationContext);
        if (user == null || !this.getId().equals(user.getRealmId())) {
            return null;
        }
        return new UserAdapter(user, this.invocationContext);
    }

    public UserAdapter addUser(String username) {
        return this.addUser(null, username);
    }

    public UserAdapter addUser(String id, String username) {
        UserAdapter userModel = this.addUserEntity(id, username);
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                this.grantRole(userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(String id, String username) {
        MongoUserEntity userEntity = new MongoUserEntity();
        userEntity.setId(id);
        userEntity.setLoginName(username);
        userEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return new UserAdapter(userEntity, this.invocationContext);
    }

    public boolean removeUser(String name) {
        DBObject query = new QueryBuilder().and("loginName").is((Object)name).and("realmId").is((Object)this.getId()).get();
        return this.getMongoStore().removeEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("realmId").is((Object)this.getId()).get();
        MongoRoleEntity role = this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this, role, (RoleContainerModel)this, this.invocationContext);
    }

    public RoleModel addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleModel addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setRealmId(this.getId());
        this.getMongoStore().insertEntity(roleEntity, this.invocationContext);
        return new RoleAdapter(this, roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        return this.removeRoleById(role.getId());
    }

    public boolean removeRoleById(String id) {
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, id, this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoRoleEntity> roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        if (roles == null) {
            return result;
        }
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this, role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public RoleModel getRoleById(String id) {
        ApplicationModel app;
        MongoRoleEntity role = this.getMongoStore().loadEntity(MongoRoleEntity.class, id, this.invocationContext);
        if (role == null) {
            return null;
        }
        if (role.getRealmId() != null ? !role.getRealmId().equals(this.getId()) : (app = this.getApplicationById(role.getApplicationId())) == null) {
            return null;
        }
        return new RoleAdapter(this, role, null, this.invocationContext);
    }

    public List<String> getDefaultRoles() {
        return this.realm.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.realm, "defaultRoles", name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.realm.setDefaultRoles(roleNames);
        this.updateRealm();
    }

    public ClientModel findClient(String clientId) {
        ApplicationModel model = this.getApplicationByName(clientId);
        if (model != null) {
            return model;
        }
        return this.getOAuthClient(clientId);
    }

    public ClientModel findClientById(String id) {
        ApplicationModel model = this.getApplicationById(id);
        if (model != null) {
            return model;
        }
        return this.getOAuthClientById(id);
    }

    public ApplicationModel getApplicationById(String id) {
        MongoApplicationEntity appData = this.getMongoStore().loadEntity(MongoApplicationEntity.class, id, this.invocationContext);
        if (appData == null || !this.getId().equals(appData.getRealmId())) {
            return null;
        }
        return new ApplicationAdapter(this, appData, this.invocationContext);
    }

    public ApplicationModel getApplicationByName(String name) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("name").is((Object)name).get();
        MongoApplicationEntity appEntity = this.getMongoStore().loadSingleEntity(MongoApplicationEntity.class, query, this.invocationContext);
        return appEntity == null ? null : new ApplicationAdapter(this, appEntity, this.invocationContext);
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> resourceMap = new HashMap<String, ApplicationModel>();
        for (ApplicationModel resource : this.getApplications()) {
            resourceMap.put(resource.getName(), resource);
        }
        return resourceMap;
    }

    public List<ApplicationModel> getApplications() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoApplicationEntity> appDatas = this.getMongoStore().loadEntities(MongoApplicationEntity.class, query, this.invocationContext);
        ArrayList<ApplicationModel> result = new ArrayList<ApplicationModel>();
        for (MongoApplicationEntity appData : appDatas) {
            result.add(new ApplicationAdapter(this, appData, this.invocationContext));
        }
        return result;
    }

    public ApplicationModel addApplication(String name) {
        return this.addApplication(null, name);
    }

    public ApplicationModel addApplication(String id, String name) {
        MongoApplicationEntity appData = new MongoApplicationEntity();
        appData.setId(id);
        appData.setName(name);
        appData.setRealmId(this.getId());
        appData.setEnabled(true);
        this.getMongoStore().insertEntity(appData, this.invocationContext);
        return new ApplicationAdapter(this, appData, this.invocationContext);
    }

    public boolean removeApplication(String id) {
        return this.getMongoStore().removeEntity(MongoApplicationEntity.class, id, this.invocationContext);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings(user);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void grantRole(UserModel user, RoleModel role) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pushItemToList(userEntity, "roleIds", role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings(UserModel user) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllRolesOfUser(user, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this, role, (RoleContainerModel)this, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmRoleMappings(UserModel user) {
        Set<RoleModel> allRoles = this.getRoleMappings(user);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        if (user == null || role == null) {
            return;
        }
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        this.getMongoStore().pullItemFromList(userEntity, "roleIds", role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getScopeMappings(ClientModel client) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(client, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this, role, (RoleContainerModel)this, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmScopeMappings(ClientModel client) {
        Set<RoleModel> allScopes = this.getScopeMappings(client);
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public boolean hasScope(ClientModel client, RoleModel role) {
        Set<RoleModel> roles = this.getScopeMappings(client);
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public void addScopeMapping(ClientModel client, RoleModel role) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)((AbstractMongoAdapter)client).getMongoEntity(), "scopeIds", role.getId(), true, this.invocationContext);
    }

    public void deleteScopeMapping(ClientModel client, RoleModel role) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)((AbstractMongoAdapter)client).getMongoEntity(), "scopeIds", role.getId(), this.invocationContext);
    }

    public OAuthClientModel addOAuthClient(String name) {
        return this.addOAuthClient(null, name);
    }

    public OAuthClientModel addOAuthClient(String id, String name) {
        MongoOAuthClientEntity oauthClient = new MongoOAuthClientEntity();
        oauthClient.setId(id);
        oauthClient.setRealmId(this.getId());
        oauthClient.setName(name);
        this.getMongoStore().insertEntity(oauthClient, this.invocationContext);
        return new OAuthClientAdapter(this, oauthClient, this.invocationContext);
    }

    public boolean removeOAuthClient(String id) {
        return this.getMongoStore().removeEntity(MongoOAuthClientEntity.class, id, this.invocationContext);
    }

    public OAuthClientModel getOAuthClient(String name) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).and("name").is((Object)name).get();
        MongoOAuthClientEntity oauthClient = this.getMongoStore().loadSingleEntity(MongoOAuthClientEntity.class, query, this.invocationContext);
        return oauthClient == null ? null : new OAuthClientAdapter(this, oauthClient, this.invocationContext);
    }

    public OAuthClientModel getOAuthClientById(String id) {
        MongoOAuthClientEntity clientEntity = this.getMongoStore().loadEntity(MongoOAuthClientEntity.class, id, this.invocationContext);
        if (clientEntity == null || !this.getId().equals(clientEntity.getRealmId())) {
            return null;
        }
        return new OAuthClientAdapter(this, clientEntity, this.invocationContext);
    }

    public List<OAuthClientModel> getOAuthClients() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoOAuthClientEntity> results = this.getMongoStore().loadEntities(MongoOAuthClientEntity.class, query, this.invocationContext);
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (MongoOAuthClientEntity data : results) {
            list.add(new OAuthClientAdapter(this, data, this.invocationContext));
        }
        return list;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(credentialModel, this.realm.getRequiredCredentials());
    }

    protected void addRequiredCredential(RequiredCredentialModel credentialModel, List<RequiredCredentialEntity> persistentCollection) {
        RequiredCredentialEntity credEntity = new RequiredCredentialEntity();
        credEntity.setType(credentialModel.getType());
        credEntity.setFormLabel(credentialModel.getFormLabel());
        credEntity.setInput(credentialModel.isInput());
        credEntity.setSecret(credentialModel.isSecret());
        persistentCollection.add(credEntity);
        this.updateRealm();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.updateRequiredCredentials(creds, this.realm.getRequiredCredentials());
    }

    protected void updateRequiredCredentials(Set<String> creds, List<RequiredCredentialEntity> credsEntities) {
        HashSet<String> already = new HashSet<String>();
        HashSet<RequiredCredentialEntity> toRemove = new HashSet<RequiredCredentialEntity>();
        for (RequiredCredentialEntity entity : credsEntities) {
            if (!creds.contains(entity.getType())) {
                toRemove.add(entity);
                continue;
            }
            already.add(entity.getType());
        }
        for (RequiredCredentialEntity entity : toRemove) {
            credsEntities.remove(entity);
        }
        for (String cred : creds) {
            logger.info((Object)("updating cred: " + cred));
            if (already.contains(cred)) continue;
            RequiredCredentialModel credentialModel = this.initRequiredCredentialModel(cred);
            this.addRequiredCredential(credentialModel, credsEntities);
        }
        this.updateRealm();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        return this.convertRequiredCredentialEntities(this.realm.getRequiredCredentials());
    }

    protected List<RequiredCredentialModel> convertRequiredCredentialEntities(Collection<RequiredCredentialEntity> credEntities) {
        ArrayList<RequiredCredentialModel> result = new ArrayList<RequiredCredentialModel>();
        for (RequiredCredentialEntity entity : credEntities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setInput(entity.isInput());
            model.setSecret(entity.isSecret());
            model.setType(entity.getType());
            result.add(model);
        }
        return result;
    }

    public boolean validatePassword(UserModel user, String password) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("password")) continue;
            return new Pbkdf2PasswordEncoder(cred.getSalt()).verify(password, cred.getValue());
        }
        return false;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        if (!this.validatePassword(user, password)) {
            return false;
        }
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("totp")) continue;
            return new TimeBasedOTP().validate(token, cred.getValue().getBytes());
        }
        return false;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        CredentialEntity credentialEntity = this.getCredentialEntity(userEntity, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            userEntity.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            byte[] salt = Pbkdf2PasswordEncoder.getSalt();
            credentialEntity.setValue(new Pbkdf2PasswordEncoder(salt).encode(cred.getValue()));
            credentialEntity.setSalt(salt);
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    private CredentialEntity getCredentialEntity(MongoUserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly(UserModel user) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List credentials = userEntity.getCredentials();
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        for (CredentialEntity credEntity : credentials) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setValue(credEntity.getValue());
            credModel.setSalt(credEntity.getSalt());
            result.add(credModel);
        }
        return result;
    }

    public void updateCredentialDirectly(UserModel user, UserCredentialValueModel credModel) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        CredentialEntity credentialEntity = this.getCredentialEntity(userEntity, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            userEntity.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        DBObject query = new QueryBuilder().and("socialLinks.socialProvider").is((Object)socialLink.getSocialProvider()).and("socialLinks.socialUserId").is((Object)socialLink.getSocialUserId()).and("realmId").is((Object)this.getId()).get();
        MongoUserEntity userEntity = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(userEntity, this.invocationContext);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<SocialLinkModel> result = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            SocialLinkModel model = new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername());
            result.add(model);
        }
        return result;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider) {
        SocialLinkEntity socialLinkEntity = this.findSocialLink(user, socialProvider);
        return socialLinkEntity != null ? new SocialLinkModel(socialLinkEntity.getSocialProvider(), socialLinkEntity.getSocialUserId(), socialLinkEntity.getSocialUsername()) : null;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        SocialLinkEntity socialLinkEntity = new SocialLinkEntity();
        socialLinkEntity.setSocialProvider(socialLink.getSocialProvider());
        socialLinkEntity.setSocialUserId(socialLink.getSocialUserId());
        socialLinkEntity.setSocialUsername(socialLink.getSocialUsername());
        this.getMongoStore().pushItemToList(userEntity, "socialLinks", socialLinkEntity, true, this.invocationContext);
    }

    public boolean removeSocialLink(UserModel user, String socialProvider) {
        SocialLinkEntity socialLinkEntity = this.findSocialLink(user, socialProvider);
        if (socialLinkEntity == null) {
            return false;
        }
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        return this.getMongoStore().pullItemFromList(userEntity, "socialLinks", socialLinkEntity, this.invocationContext);
    }

    private SocialLinkEntity findSocialLink(UserModel user, String socialProvider) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List linkEntities = userEntity.getSocialLinks();
        if (linkEntities == null) {
            return null;
        }
        for (SocialLinkEntity socialLinkEntity : linkEntities) {
            if (!socialLinkEntity.getSocialProvider().equals(socialProvider)) continue;
            return socialLinkEntity;
        }
        return null;
    }

    public AuthenticationLinkModel getAuthenticationLink(UserModel user) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        AuthenticationLinkEntity authLinkEntity = userEntity.getAuthenticationLink();
        if (authLinkEntity == null) {
            return null;
        }
        return new AuthenticationLinkModel(authLinkEntity.getAuthProvider(), authLinkEntity.getAuthUserId());
    }

    public void setAuthenticationLink(UserModel user, AuthenticationLinkModel authenticationLink) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        AuthenticationLinkEntity authLinkEntity = new AuthenticationLinkEntity();
        authLinkEntity.setAuthProvider(authenticationLink.getAuthProvider());
        authLinkEntity.setAuthUserId(authenticationLink.getAuthUserId());
        userEntity.setAuthenticationLink(authLinkEntity);
        this.getMongoStore().updateEntity(userEntity, this.invocationContext);
    }

    protected void updateRealm() {
        super.updateMongoEntity();
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public List<UserModel> getUsers() {
        DBObject query = new QueryBuilder().and("realmId").is((Object)this.getId()).get();
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, query, this.invocationContext);
        return this.convertUserEntities(users);
    }

    public List<UserModel> searchForUser(String search) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)this.getId()).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("loginName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, builder.get(), this.invocationContext);
        return this.convertUserEntities(users);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)this.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equals("username")) {
                queryBuilder.and("loginName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile("(?i:" + entry.getValue() + "$)"));
        }
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), this.invocationContext);
        return this.convertUserEntities(users);
    }

    protected List<UserModel> convertUserEntities(List<MongoUserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (MongoUserEntity user : userEntities) {
            userModels.add(new UserAdapter(user, this.invocationContext));
        }
        return userModels;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.updateRealm();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.updateRealm();
    }

    public Map<String, String> getLdapServerConfig() {
        return this.realm.getLdapServerConfig();
    }

    public void setLdapServerConfig(Map<String, String> ldapServerConfig) {
        this.realm.setLdapServerConfig(ldapServerConfig);
        this.updateRealm();
    }

    public List<AuthenticationProviderModel> getAuthenticationProviders() {
        List entities = this.realm.getAuthenticationProviders();
        ArrayList<AuthenticationProviderModel> result = new ArrayList<AuthenticationProviderModel>();
        for (AuthenticationProviderEntity entity : entities) {
            result.add(new AuthenticationProviderModel(entity.getProviderName(), entity.isPasswordUpdateSupported(), entity.getConfig()));
        }
        return result;
    }

    public void setAuthenticationProviders(List<AuthenticationProviderModel> authenticationProviders) {
        ArrayList<AuthenticationProviderEntity> entities = new ArrayList<AuthenticationProviderEntity>();
        for (AuthenticationProviderModel model : authenticationProviders) {
            AuthenticationProviderEntity entity = new AuthenticationProviderEntity();
            entity.setProviderName(model.getProviderName());
            entity.setPasswordUpdateSupported(model.isPasswordUpdateSupported());
            entity.setConfig(model.getConfig());
            entities.add(entity);
        }
        this.realm.setAuthenticationProviders(entities);
        this.updateRealm();
    }

    public boolean isAuditEnabled() {
        return this.realm.isAuditEnabled();
    }

    public void setAuditEnabled(boolean enabled) {
        this.realm.setAuditEnabled(enabled);
        this.updateRealm();
    }

    public long getAuditExpiration() {
        return this.realm.getAuditExpiration();
    }

    public void setAuditExpiration(long expiration) {
        this.realm.setAuditExpiration(expiration);
        this.updateRealm();
    }

    public Set<String> getAuditListeners() {
        return new HashSet<String>(this.realm.getAuditListeners());
    }

    public void setAuditListeners(Set<String> listeners) {
        if (listeners != null) {
            this.realm.setAuditListeners(new ArrayList<String>(listeners));
        } else {
            this.realm.setAuditListeners(Collections.EMPTY_LIST);
        }
        this.updateRealm();
    }

    public ApplicationModel getMasterAdminApp() {
        MongoApplicationEntity appData = this.getMongoStore().loadEntity(MongoApplicationEntity.class, this.realm.getAdminAppId(), this.invocationContext);
        return appData != null ? new ApplicationAdapter(this, appData, this.invocationContext) : null;
    }

    public void setMasterAdminApp(ApplicationModel app) {
        this.realm.setAdminAppId(app.getId());
        this.updateRealm();
    }

    @Override
    public MongoRealmEntity getMongoEntity() {
        return this.realm;
    }

    public UserSessionModel createUserSession(UserModel user, String ipAddress) {
        MongoUserSessionEntity entity = new MongoUserSessionEntity();
        entity.setRealmId(this.getId());
        entity.setUser(user.getId());
        entity.setIpAddress(ipAddress);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.getMongoStore().insertEntity(entity, this.invocationContext);
        return new UserSessionAdapter(entity, this, this.invocationContext);
    }

    public UserSessionModel getUserSession(String id) {
        MongoUserSessionEntity entity = this.getMongoStore().loadEntity(MongoUserSessionEntity.class, id, this.invocationContext);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter(entity, this, this.invocationContext);
    }

    public List<UserSessionModel> getUserSessions(UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (MongoUserSessionEntity e : this.getMongoStore().loadEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext)) {
            sessions.add(new UserSessionAdapter(e, this, this.invocationContext));
        }
        return sessions;
    }

    public void removeUserSession(UserSessionModel session) {
        this.getMongoStore().removeEntity(((UserSessionAdapter)session).getMongoEntity(), this.invocationContext);
    }

    public void removeUserSessions(UserModel user) {
        BasicDBObject query = new BasicDBObject("user", (Object)user.getId());
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeUserSessions() {
        BasicDBObject query = new BasicDBObject("realmId", (Object)this.getId());
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, (DBObject)query, this.invocationContext);
    }

    public void removeExpiredUserSessions() {
        int currentTime = Time.currentTime();
        DBObject query = new QueryBuilder().and("started").lessThan((Object)(currentTime - this.realm.getSsoSessionMaxLifespan())).get();
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
        query = new QueryBuilder().and("lastSessionRefresh").lessThan((Object)(currentTime - this.realm.getSsoSessionIdleTimeout())).get();
        this.getMongoStore().removeEntities(MongoUserSessionEntity.class, query, this.invocationContext);
    }
}

