/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;

public class ApplicationAdapter
extends ClientAdapter<MongoApplicationEntity>
implements ApplicationModel {
    public ApplicationAdapter(KeycloakSession session, RealmModel realm, MongoApplicationEntity applicationEntity, MongoStoreInvocationContext invContext) {
        super(session, realm, applicationEntity, invContext);
    }

    public void updateApplication() {
        this.updateMongoEntity();
    }

    public String getName() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getName();
    }

    public void setName(String name) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setName(name);
        this.updateMongoEntity();
    }

    public boolean isSurrogateAuthRequired() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setSurrogateAuthRequired(surrogateAuthRequired);
        this.updateMongoEntity();
    }

    public String getManagementUrl() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getManagementUrl();
    }

    public void setManagementUrl(String url) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setManagementUrl(url);
        this.updateMongoEntity();
    }

    public void setBaseUrl(String url) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setBaseUrl(url);
        this.updateMongoEntity();
    }

    public String getBaseUrl() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getBaseUrl();
    }

    public boolean isBearerOnly() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setBearerOnly(only);
        this.updateMongoEntity();
    }

    @Override
    public boolean isPublicClient() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).isPublicClient();
    }

    @Override
    public void setPublicClient(boolean flag) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setPublicClient(flag);
        this.updateMongoEntity();
    }

    public boolean isDirectGrantsOnly() {
        return false;
    }

    public void setDirectGrantsOnly(boolean flag) {
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("applicationId").is((Object)this.getId()).get();
        MongoRoleEntity role = (MongoRoleEntity)this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.session, this.getRealm(), role, this.invocationContext);
    }

    public RoleAdapter addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleAdapter addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setApplicationId(this.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, this.getRealm(), roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        this.session.users().preRemove(this.getRealm(), role);
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("applicationId").is((Object)this.getId()).get();
        List roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.session, this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    @Override
    public boolean hasScope(RoleModel role) {
        if (super.hasScope(role)) {
            return true;
        }
        Set<RoleModel> roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getApplicationScopeMappings(ClientModel client) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(client, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (!this.getId().equals(role.getApplicationId())) continue;
            result.add(new RoleAdapter(this.session, this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public List<String> getDefaultRoles() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList(this.getMongoEntity(), "defaultRoles", (Object)name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setDefaultRoles(roleNames);
        this.updateMongoEntity();
    }

    public int getNodeReRegistrationTimeout() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        ((MongoApplicationEntity)((Object)this.getMongoEntity())).setNodeReRegistrationTimeout(timeout);
        this.updateMongoEntity();
    }

    public Map<String, Integer> getRegisteredNodes() {
        return ((MongoApplicationEntity)((Object)this.getMongoEntity())).getRegisteredNodes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(((MongoApplicationEntity)((Object)this.getMongoEntity())).getRegisteredNodes());
    }

    public void registerNode(String nodeHost, int registrationTime) {
        MongoApplicationEntity entity = (MongoApplicationEntity)((Object)this.getMongoEntity());
        if (entity.getRegisteredNodes() == null) {
            entity.setRegisteredNodes(new HashMap());
        }
        entity.getRegisteredNodes().put(nodeHost, registrationTime);
        this.updateMongoEntity();
    }

    public void unregisterNode(String nodeHost) {
        MongoApplicationEntity entity = (MongoApplicationEntity)((Object)this.getMongoEntity());
        if (entity.getRegisteredNodes() == null) {
            return;
        }
        entity.getRegisteredNodes().remove(nodeHost);
        this.updateMongoEntity();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ApplicationModel)) {
            return false;
        }
        ApplicationModel that = (ApplicationModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

