/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.entities.ProtocolMapperEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.adapters.RoleAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public class ClientAdapter
extends AbstractMongoAdapter<MongoClientEntity>
implements ClientModel {
    protected final MongoClientEntity clientEntity;
    private final RealmModel realm;
    protected KeycloakSession session;

    public ClientAdapter(KeycloakSession session, RealmModel realm, MongoClientEntity clientEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.session = session;
        this.realm = realm;
        this.clientEntity = clientEntity;
    }

    @Override
    public MongoClientEntity getMongoEntity() {
        return this.clientEntity;
    }

    public void updateClient() {
        this.updateMongoEntity();
    }

    public String getId() {
        return this.getMongoEntity().getId();
    }

    public String getClientId() {
        return this.getMongoEntity().getClientId();
    }

    public String getName() {
        return this.getMongoEntity().getName();
    }

    public void setName(String name) {
        this.getMongoEntity().setName(name);
        this.updateMongoEntity();
    }

    public String getDescription() {
        return this.getMongoEntity().getDescription();
    }

    public void setDescription(String description) {
        this.getMongoEntity().setDescription(description);
        this.updateMongoEntity();
    }

    public void setClientId(String clientId) {
        this.getMongoEntity().setClientId(clientId);
        this.updateMongoEntity();
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntity().getWebOrigins() != null) {
            result.addAll(this.getMongoEntity().getWebOrigins());
        }
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(webOrigins);
        this.getMongoEntity().setWebOrigins(result);
        this.updateMongoEntity();
    }

    public void addWebOrigin(String webOrigin) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", (Object)webOrigin, true, this.invocationContext);
    }

    public void removeWebOrigin(String webOrigin) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "webOrigins", (Object)webOrigin, this.invocationContext);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMongoEntity().getRedirectUris() != null) {
            result.addAll(this.getMongoEntity().getRedirectUris());
        }
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(redirectUris);
        this.getMongoEntity().setRedirectUris(result);
        this.updateMongoEntity();
    }

    public void addRedirectUri(String redirectUri) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", (Object)redirectUri, true, this.invocationContext);
    }

    public void removeRedirectUri(String redirectUri) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.clientEntity, "redirectUris", (Object)redirectUri, this.invocationContext);
    }

    public boolean isEnabled() {
        return this.getMongoEntity().isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getMongoEntity().setEnabled(enabled);
        this.updateMongoEntity();
    }

    public String getClientAuthenticatorType() {
        return this.getMongoEntity().getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.getMongoEntity().setClientAuthenticatorType(clientAuthenticatorType);
        this.updateMongoEntity();
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.getMongoEntity().getSecret());
    }

    public String getSecret() {
        return this.getMongoEntity().getSecret();
    }

    public void setSecret(String secret) {
        this.getMongoEntity().setSecret(secret);
        this.updateMongoEntity();
    }

    public String getRegistrationToken() {
        return this.getMongoEntity().getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.getMongoEntity().setRegistrationToken(registrationToken);
        this.updateMongoEntity();
    }

    public boolean isPublicClient() {
        return this.getMongoEntity().isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.getMongoEntity().setPublicClient(flag);
        this.updateMongoEntity();
    }

    public boolean isFrontchannelLogout() {
        return this.getMongoEntity().isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.getMongoEntity().setFrontchannelLogout(flag);
        this.updateMongoEntity();
    }

    public boolean isFullScopeAllowed() {
        return this.getMongoEntity().isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.getMongoEntity().setFullScopeAllowed(value);
        this.updateMongoEntity();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getNotBefore() {
        return this.getMongoEntity().getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getMongoEntity().setNotBefore(notBefore);
        this.updateMongoEntity();
    }

    public Set<RoleModel> getScopeMappings() {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(this, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (this.realm.getId().equals(role.getRealmId())) {
                result.add(new RoleAdapter(this.session, this.realm, role, (RoleContainerModel)this.realm, this.invocationContext));
                continue;
            }
            result.add(new RoleAdapter(this.session, this.realm, role, this.invocationContext));
        }
        return result;
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> allScopes = this.getScopeMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allScopes) {
            MongoRoleEntity roleEntity = ((RoleAdapter)role).getRole();
            if (!this.realm.getId().equals(roleEntity.getRealmId())) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void addScopeMapping(RoleModel role) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getMongoEntity(), "scopeIds", (Object)role.getId(), true, this.invocationContext);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.getMongoEntity(), "scopeIds", (Object)role.getId(), this.invocationContext);
    }

    public String getProtocol() {
        return this.getMongoEntity().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.getMongoEntity().setProtocol(protocol);
        this.updateMongoEntity();
    }

    public void setAttribute(String name, String value) {
        this.getMongoEntity().getAttributes().put(name, value);
        this.updateMongoEntity();
    }

    public void removeAttribute(String name) {
        this.getMongoEntity().getAttributes().remove(name);
        this.updateMongoEntity();
    }

    public String getAttribute(String name) {
        return (String)this.getMongoEntity().getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.getMongoEntity().getAttributes());
        return copy;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> result = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap config = new HashMap();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            result.add(mapping);
        }
        return result;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new ModelDuplicateException("Protocol mapper name must be unique per protocol");
        }
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        entity.setId(id);
        entity.setProtocol(model.getProtocol());
        entity.setName(model.getName());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.getMongoEntity().getProtocolMappers().add(entity);
        this.updateMongoEntity();
        return this.entityToModel(entity);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getId().equals(mapping.getId())) continue;
            this.session.users().preRemove(mapping);
            this.getMongoEntity().getProtocolMappers().remove(entity);
            this.updateMongoEntity();
            break;
        }
    }

    protected ProtocolMapperEntity getProtocolMapperyEntityById(String id) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.getMongoEntity().getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() != null) {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        } else {
            entity.setConfig(mapping.getConfig());
        }
        this.updateMongoEntity();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperyEntityById(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap config = new HashMap();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public boolean isSurrogateAuthRequired() {
        return this.getMongoEntity().isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.getMongoEntity().setSurrogateAuthRequired(surrogateAuthRequired);
        this.updateMongoEntity();
    }

    public String getManagementUrl() {
        return this.getMongoEntity().getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.getMongoEntity().setManagementUrl(url);
        this.updateMongoEntity();
    }

    public void setRootUrl(String url) {
        this.getMongoEntity().setRootUrl(url);
        this.updateMongoEntity();
    }

    public String getRootUrl() {
        return this.getMongoEntity().getRootUrl();
    }

    public void setBaseUrl(String url) {
        this.getMongoEntity().setBaseUrl(url);
        this.updateMongoEntity();
    }

    public String getBaseUrl() {
        return this.getMongoEntity().getBaseUrl();
    }

    public boolean isBearerOnly() {
        return this.getMongoEntity().isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.getMongoEntity().setBearerOnly(only);
        this.updateMongoEntity();
    }

    public boolean isConsentRequired() {
        return this.getMongoEntity().isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.getMongoEntity().setConsentRequired(consentRequired);
        this.updateMongoEntity();
    }

    public boolean isStandardFlowEnabled() {
        return this.getMongoEntity().isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.getMongoEntity().setStandardFlowEnabled(standardFlowEnabled);
        this.updateMongoEntity();
    }

    public boolean isImplicitFlowEnabled() {
        return this.getMongoEntity().isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.getMongoEntity().setImplicitFlowEnabled(implicitFlowEnabled);
        this.updateMongoEntity();
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.getMongoEntity().isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.getMongoEntity().setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
        this.updateMongoEntity();
    }

    public boolean isServiceAccountsEnabled() {
        return this.getMongoEntity().isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.getMongoEntity().setServiceAccountsEnabled(serviceAccountsEnabled);
        this.updateMongoEntity();
    }

    public RoleAdapter getRole(String name) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("clientId").is((Object)this.getId()).get();
        MongoRoleEntity role = (MongoRoleEntity)this.getMongoStore().loadSingleEntity(MongoRoleEntity.class, query, this.invocationContext);
        if (role == null) {
            return null;
        }
        return new RoleAdapter(this.session, this.getRealm(), role, this.invocationContext);
    }

    public RoleAdapter addRole(String name) {
        return this.addRole(null, name);
    }

    public RoleAdapter addRole(String id, String name) {
        MongoRoleEntity roleEntity = new MongoRoleEntity();
        roleEntity.setId(id);
        roleEntity.setName(name);
        roleEntity.setClientId(this.getId());
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)roleEntity, this.invocationContext);
        return new RoleAdapter(this.session, this.getRealm(), roleEntity, (RoleContainerModel)this, this.invocationContext);
    }

    public boolean removeRole(RoleModel role) {
        this.session.users().preRemove(this.getRealm(), role);
        return this.getMongoStore().removeEntity(MongoRoleEntity.class, role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getRoles() {
        DBObject query = new QueryBuilder().and("clientId").is((Object)this.getId()).get();
        List roles = this.getMongoStore().loadEntities(MongoRoleEntity.class, query, this.invocationContext);
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        for (MongoRoleEntity role : roles) {
            result.add(new RoleAdapter(this.session, this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public Set<RoleModel> getClientScopeMappings(ClientModel client) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<MongoRoleEntity> roles = MongoModelUtils.getAllScopesOfClient(client, this.invocationContext);
        for (MongoRoleEntity role : roles) {
            if (!this.getId().equals(role.getClientId())) continue;
            result.add(new RoleAdapter(this.session, this.getRealm(), role, (RoleContainerModel)this, this.invocationContext));
        }
        return result;
    }

    public List<String> getDefaultRoles() {
        return this.getMongoEntity().getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        RoleAdapter role = this.getRole(name);
        if (role == null) {
            this.addRole(name);
        }
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getMongoEntity(), "defaultRoles", (Object)name, true, this.invocationContext);
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (String roleName : defaultRoles) {
            RoleAdapter role = this.getRole(roleName);
            if (role == null) {
                this.addRole(roleName);
            }
            roleNames.add(roleName);
        }
        this.getMongoEntity().setDefaultRoles(roleNames);
        this.updateMongoEntity();
    }

    public int getNodeReRegistrationTimeout() {
        return this.getMongoEntity().getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.getMongoEntity().setNodeReRegistrationTimeout(timeout);
        this.updateMongoEntity();
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.getMongoEntity().getRegisteredNodes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.getMongoEntity().getRegisteredNodes());
    }

    public void registerNode(String nodeHost, int registrationTime) {
        MongoClientEntity entity = this.getMongoEntity();
        if (entity.getRegisteredNodes() == null) {
            entity.setRegisteredNodes(new HashMap());
        }
        entity.getRegisteredNodes().put(nodeHost, registrationTime);
        this.updateMongoEntity();
    }

    public void unregisterNode(String nodeHost) {
        MongoClientEntity entity = this.getMongoEntity();
        if (entity.getRegisteredNodes() == null) {
            return;
        }
        entity.getRegisteredNodes().remove(nodeHost);
        this.updateMongoEntity();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }

    public ClientTemplateModel getClientTemplate() {
        if (this.getMongoEntity().getClientTemplate() == null) {
            return null;
        }
        return this.session.realms().getClientTemplateById(this.getMongoEntity().getClientTemplate(), this.realm);
    }

    public void setClientTemplate(ClientTemplateModel template) {
        this.getMongoEntity().setClientTemplate(template.getId());
        this.updateMongoEntity();
    }
}

