/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.connections.mongo.api.MongoIdentifiableEntity;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.hash.PasswordHashManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.UserConsentEntity;
import org.keycloak.models.mongo.keycloak.adapters.AbstractMongoAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.utils.MongoModelUtils;
import org.keycloak.models.utils.KeycloakModelUtils;

public class UserAdapter
extends AbstractMongoAdapter<MongoUserEntity>
implements UserModel {
    private final MongoUserEntity user;
    private final RealmModel realm;
    private final KeycloakSession session;

    public UserAdapter(KeycloakSession session, RealmModel realm, MongoUserEntity userEntity, MongoStoreInvocationContext invContext) {
        super(invContext);
        this.user = userEntity;
        this.realm = realm;
        this.session = session;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public void setUsername(String username) {
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        this.user.setUsername(username);
        this.updateUser();
    }

    public Long getCreatedTimestamp() {
        return this.user.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
        this.user.setCreatedTimestamp(timestamp);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
        this.updateUser();
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
        this.updateUser();
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
        this.updateUser();
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        email = KeycloakModelUtils.toLowerCaseSafe((String)email);
        this.user.setEmail(email);
        this.updateUser();
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
        this.updateUser();
    }

    public void setSingleAttribute(String name, String value) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        ArrayList<String> attrValues = new ArrayList<String>();
        attrValues.add(value);
        this.user.getAttributes().put(name, attrValues);
        this.updateUser();
    }

    public void setAttribute(String name, List<String> values) {
        if (this.user.getAttributes() == null) {
            this.user.setAttributes(new HashMap());
        }
        this.user.getAttributes().put(name, values);
        this.updateUser();
    }

    public void removeAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return;
        }
        this.user.getAttributes().remove(name);
        this.updateUser();
    }

    public String getFirstAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return null;
        }
        List attrValues = (List)this.user.getAttributes().get(name);
        return attrValues == null || attrValues.isEmpty() ? null : (String)attrValues.get(0);
    }

    public List<String> getAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return Collections.emptyList();
        }
        List attrValues = (List)this.user.getAttributes().get(name);
        return attrValues == null ? Collections.emptyList() : Collections.unmodifiableList(attrValues);
    }

    public Map<String, List<String>> getAttributes() {
        return this.user.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.user.getAttributes());
    }

    public MongoUserEntity getUser() {
        return this.user;
    }

    public Set<String> getRequiredActions() {
        HashSet<String> result = new HashSet<String>();
        if (this.user.getRequiredActions() != null) {
            result.addAll(this.user.getRequiredActions());
        }
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.addRequiredAction(actionName);
    }

    public void addRequiredAction(String actionName) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)actionName, true, this.invocationContext);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        String actionName = action.name();
        this.removeRequiredAction(actionName);
    }

    public void removeRequiredAction(String actionName) {
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.user, "requiredActions", (Object)actionName, this.invocationContext);
    }

    public boolean isOtpEnabled() {
        return this.user.isTotp();
    }

    public void setOtpEnabled(boolean totp) {
        this.user.setTotp(totp);
        this.updateUser();
    }

    public void updateCredential(UserCredentialModel cred) {
        if (cred.getType().equals("password")) {
            this.updatePasswordCredential(cred);
        } else if (UserCredentialModel.isOtp((String)cred.getType())) {
            this.updateOtpCredential(cred);
        } else {
            CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
            if (credentialEntity == null) {
                credentialEntity = this.setCredentials(this.user, cred);
                credentialEntity.setValue(cred.getValue());
                this.user.getCredentials().add(credentialEntity);
            } else {
                credentialEntity.setValue(cred.getValue());
            }
        }
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    private void updateOtpCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = this.setCredentials(this.user, cred);
            credentialEntity.setValue(cred.getValue());
            OTPPolicy otpPolicy = this.realm.getOTPPolicy();
            credentialEntity.setAlgorithm(otpPolicy.getAlgorithm());
            credentialEntity.setDigits(otpPolicy.getDigits());
            credentialEntity.setCounter(otpPolicy.getInitialCounter());
            credentialEntity.setPeriod(otpPolicy.getPeriod());
            this.user.getCredentials().add(credentialEntity);
        } else {
            credentialEntity.setValue(cred.getValue());
            OTPPolicy policy = this.realm.getOTPPolicy();
            credentialEntity.setDigits(policy.getDigits());
            credentialEntity.setCounter(policy.getInitialCounter());
            credentialEntity.setAlgorithm(policy.getAlgorithm());
            credentialEntity.setPeriod(policy.getPeriod());
        }
    }

    private void updatePasswordCredential(UserCredentialModel cred) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, cred.getType());
        if (credentialEntity == null) {
            credentialEntity = this.setCredentials(this.user, cred);
            this.setValue(credentialEntity, cred);
            this.user.getCredentials().add(credentialEntity);
        } else {
            int expiredPasswordsPolicyValue = -1;
            PasswordPolicy policy = this.realm.getPasswordPolicy();
            if (policy != null) {
                expiredPasswordsPolicyValue = policy.getExpiredPasswords();
            }
            if (expiredPasswordsPolicyValue != -1) {
                this.user.getCredentials().remove(credentialEntity);
                credentialEntity.setType("password-history");
                this.user.getCredentials().add(credentialEntity);
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities.size() > expiredPasswordsPolicyValue - 1) {
                    this.user.getCredentials().removeAll(credentialEntities.subList(expiredPasswordsPolicyValue - 1, credentialEntities.size()));
                }
                credentialEntity = this.setCredentials(this.user, cred);
                this.setValue(credentialEntity, cred);
                this.user.getCredentials().add(credentialEntity);
            } else {
                List<CredentialEntity> credentialEntities = this.getCredentialEntities(this.user, "password-history");
                if (credentialEntities != null && credentialEntities.size() > 0) {
                    this.user.getCredentials().removeAll(credentialEntities);
                }
                this.setValue(credentialEntity, cred);
            }
        }
    }

    private CredentialEntity setCredentials(MongoUserEntity user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = new CredentialEntity();
        credentialEntity.setType(cred.getType());
        credentialEntity.setDevice(cred.getDevice());
        return credentialEntity;
    }

    private void setValue(CredentialEntity credentialEntity, UserCredentialModel cred) {
        UserCredentialValueModel encoded = PasswordHashManager.encode((KeycloakSession)this.session, (RealmModel)this.realm, (String)cred.getValue());
        credentialEntity.setCreatedDate(Long.valueOf(Time.toMillis((int)Time.currentTime())));
        credentialEntity.setAlgorithm(encoded.getAlgorithm());
        credentialEntity.setValue(encoded.getValue());
        credentialEntity.setSalt(encoded.getSalt());
        credentialEntity.setHashIterations(encoded.getHashIterations());
    }

    private CredentialEntity getCredentialEntity(MongoUserEntity userEntity, String credType) {
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            return entity;
        }
        return null;
    }

    private List<CredentialEntity> getCredentialEntities(MongoUserEntity userEntity, String credType) {
        ArrayList<CredentialEntity> credentialEntities = new ArrayList<CredentialEntity>();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(credType)) continue;
            credentialEntities.add(entity);
        }
        Collections.sort(credentialEntities, new Comparator<CredentialEntity>(){

            @Override
            public int compare(CredentialEntity credFirst, CredentialEntity credSecond) {
                if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                    return -1;
                }
                if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                    return 1;
                }
                return 0;
            }
        });
        return credentialEntities;
    }

    public List<UserCredentialValueModel> getCredentialsDirectly() {
        List credentials = this.user.getCredentials();
        ArrayList<UserCredentialValueModel> result = new ArrayList<UserCredentialValueModel>();
        for (CredentialEntity credEntity : credentials) {
            UserCredentialValueModel credModel = new UserCredentialValueModel();
            credModel.setType(credEntity.getType());
            credModel.setDevice(credEntity.getDevice());
            credModel.setCreatedDate(credEntity.getCreatedDate());
            credModel.setValue(credEntity.getValue());
            credModel.setSalt(credEntity.getSalt());
            credModel.setHashIterations(credEntity.getHashIterations());
            if (UserCredentialModel.isOtp((String)credEntity.getType())) {
                credModel.setCounter(credEntity.getCounter());
                if (credEntity.getAlgorithm() == null) {
                    credModel.setAlgorithm(this.realm.getOTPPolicy().getAlgorithm());
                } else {
                    credModel.setAlgorithm(credEntity.getAlgorithm());
                }
                if (credEntity.getDigits() == 0) {
                    credModel.setDigits(this.realm.getOTPPolicy().getDigits());
                } else {
                    credModel.setDigits(credEntity.getDigits());
                }
                if (credEntity.getPeriod() == 0) {
                    credModel.setPeriod(this.realm.getOTPPolicy().getPeriod());
                } else {
                    credModel.setPeriod(credEntity.getPeriod());
                }
            }
            result.add(credModel);
        }
        return result;
    }

    public void updateCredentialDirectly(UserCredentialValueModel credModel) {
        CredentialEntity credentialEntity = this.getCredentialEntity(this.user, credModel.getType());
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(credModel.getType());
            credModel.setCreatedDate(credModel.getCreatedDate());
            this.user.getCredentials().add(credentialEntity);
        }
        credentialEntity.setValue(credModel.getValue());
        credentialEntity.setSalt(credModel.getSalt());
        credentialEntity.setDevice(credModel.getDevice());
        credentialEntity.setHashIterations(credModel.getHashIterations());
        credentialEntity.setCounter(credModel.getCounter());
        credentialEntity.setAlgorithm(credModel.getAlgorithm());
        credentialEntity.setDigits(credModel.getDigits());
        credentialEntity.setPeriod(credModel.getPeriod());
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)this.user, this.invocationContext);
    }

    protected void updateUser() {
        super.updateMongoEntity();
    }

    @Override
    public MongoUserEntity getMongoEntity() {
        return this.user;
    }

    public Set<GroupModel> getGroups() {
        if (this.user.getGroupIds() == null || this.user.getGroupIds().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<GroupModel> groups = new HashSet<GroupModel>();
        for (String id : this.user.getGroupIds()) {
            groups.add(this.realm.getGroupById(id));
        }
        return groups;
    }

    public void joinGroup(GroupModel group) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getUser(), "groupIds", (Object)group.getId(), true, this.invocationContext);
    }

    public void leaveGroup(GroupModel group) {
        if (this.user == null || group == null) {
            return;
        }
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.getUser(), "groupIds", (Object)group.getId(), this.invocationContext);
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.user.getGroupIds().contains(group.getId())) {
            return true;
        }
        Set<GroupModel> groups = this.getGroups();
        return KeycloakModelUtils.isMember(groups, (GroupModel)group);
    }

    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return KeycloakModelUtils.hasRole(roles, (RoleModel)role);
    }

    public void grantRole(RoleModel role) {
        this.getMongoStore().pushItemToList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), true, this.invocationContext);
    }

    public Set<RoleModel> getRoleMappings() {
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        return new HashSet<RoleModel>(roles);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> allRoles = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : allRoles) {
            if (!(role.getContainer() instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.user == null || role == null) {
            return;
        }
        this.getMongoStore().pullItemFromList((MongoIdentifiableEntity)this.getUser(), "roleIds", (Object)role.getId(), this.invocationContext);
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        HashSet<RoleModel> result = new HashSet<RoleModel>();
        List<RoleModel> roles = MongoModelUtils.getAllRolesOfUser(this.realm, this);
        for (RoleModel role : roles) {
            if (!app.equals(role.getContainer())) continue;
            result.add(role);
        }
        return result;
    }

    public String getFederationLink() {
        return this.user.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.user.setFederationLink(link);
        this.updateUser();
    }

    public String getServiceAccountClientLink() {
        return this.user.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.user.setServiceAccountClientLink(clientInternalId);
        this.updateUser();
    }

    public void addConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        if (this.getConsentEntityByClientId(clientId) != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        MongoUserConsentEntity consentEntity = new MongoUserConsentEntity();
        consentEntity.setUserId(this.getId());
        consentEntity.setClientId(clientId);
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().insertEntity((MongoIdentifiableEntity)consentEntity, this.invocationContext);
    }

    public UserConsentModel getConsentByClient(String clientId) {
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(clientId);
        return consentEntity != null ? this.toConsentModel(consentEntity) : null;
    }

    public List<UserConsentModel> getConsents() {
        ArrayList<UserConsentModel> result = new ArrayList<UserConsentModel>();
        DBObject query = new QueryBuilder().and("userId").is((Object)this.getId()).get();
        List grantedConsents = this.getMongoStore().loadEntities(MongoUserConsentEntity.class, query, this.invocationContext);
        for (UserConsentEntity consentEntity : grantedConsents) {
            UserConsentModel model = this.toConsentModel(consentEntity);
            result.add(model);
        }
        return result;
    }

    private MongoUserConsentEntity getConsentEntityByClientId(String clientId) {
        DBObject query = new QueryBuilder().and("userId").is((Object)this.getId()).and("clientId").is((Object)clientId).get();
        return (MongoUserConsentEntity)this.getMongoStore().loadSingleEntity(MongoUserConsentEntity.class, query, this.invocationContext);
    }

    private UserConsentModel toConsentModel(UserConsentEntity entity) {
        ClientModel client = this.realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        for (String roleId : entity.getGrantedRoles()) {
            RoleModel roleModel = this.realm.getRoleById(roleId);
            if (roleModel == null) continue;
            model.addGrantedRole(roleModel);
        }
        for (String protMapperId : entity.getGrantedProtocolMappers()) {
            ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protMapperId);
            model.addGrantedProtocolMapper(protocolMapper);
        }
        return model;
    }

    private void fillEntityFromModel(UserConsentModel consent, MongoUserConsentEntity consentEntity) {
        LinkedList<String> roleIds = new LinkedList<String>();
        for (RoleModel role : consent.getGrantedRoles()) {
            roleIds.add(role.getId());
        }
        consentEntity.setGrantedRoles(roleIds);
        LinkedList<String> protMapperIds = new LinkedList<String>();
        for (ProtocolMapperModel protMapperModel : consent.getGrantedProtocolMappers()) {
            protMapperIds.add(protMapperModel.getId());
        }
        consentEntity.setGrantedProtocolMappers(protMapperIds);
    }

    public void updateConsent(UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + this.user.getId() + "]");
        }
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().updateEntity((MongoIdentifiableEntity)consentEntity, this.invocationContext);
    }

    public boolean revokeConsentForClient(String clientId) {
        MongoUserConsentEntity entity = this.getConsentEntityByClientId(clientId);
        if (entity == null) {
            return false;
        }
        return this.getMongoStore().removeEntity((MongoIdentifiableEntity)entity, this.invocationContext);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    @Override
    public int hashCode() {
        return this.getId().hashCode();
    }
}

