/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.mongo.updater.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Date;
import java.util.LinkedList;
import org.jboss.logging.Logger;
import org.keycloak.connections.mongo.updater.MongoUpdaterProvider;
import org.keycloak.connections.mongo.updater.impl.updates.Update;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_0_0_Final;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_1_0_Beta1;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_2_0_Beta1;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_2_0_CR1;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_3_0;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_4_0;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_7_0;
import org.keycloak.connections.mongo.updater.impl.updates.Update1_8_0;
import org.keycloak.models.KeycloakSession;

public class DefaultMongoUpdaterProvider
implements MongoUpdaterProvider {
    public static final Logger log = Logger.getLogger(DefaultMongoUpdaterProvider.class);
    public static final String CHANGE_LOG_COLLECTION = "databaseChangeLog";
    private Class<? extends Update>[] updates = new Class[]{Update1_0_0_Final.class, Update1_1_0_Beta1.class, Update1_2_0_Beta1.class, Update1_2_0_CR1.class, Update1_3_0.class, Update1_4_0.class, Update1_7_0.class, Update1_8_0.class};

    @Override
    public void update(KeycloakSession session, DB db) {
        log.debug((Object)"Starting database update");
        try {
            boolean changeLogExists = db.collectionExists(CHANGE_LOG_COLLECTION);
            boolean realmExists = db.collectionExists("realms");
            DBCollection changeLog = db.getCollection(CHANGE_LOG_COLLECTION);
            LinkedList<String> executed = new LinkedList<String>();
            if (!changeLogExists && realmExists) {
                Update1_0_0_Final u = new Update1_0_0_Final();
                executed.add(u.getId());
                this.createLog(changeLog, u, 1);
            } else if (changeLogExists) {
                DBCursor cursor = changeLog.find().sort((DBObject)new BasicDBObject("orderExecuted", (Object)1));
                while (cursor.hasNext()) {
                    executed.add((String)cursor.next().get("_id"));
                }
            }
            LinkedList<Update> updatesToRun = new LinkedList<Update>();
            for (Class<? extends Update> updateClass : this.updates) {
                Update u = updateClass.newInstance();
                if (executed.contains(u.getId())) continue;
                updatesToRun.add(u);
            }
            if (!updatesToRun.isEmpty()) {
                if (executed.isEmpty()) {
                    log.info((Object)"Initializing database schema");
                } else if (log.isDebugEnabled()) {
                    log.infov("Updating database from {0} to {1}", executed.get(executed.size() - 1), (Object)((Update)updatesToRun.get(updatesToRun.size() - 1)).getId());
                } else {
                    log.debugv("Updating database", new Object[0]);
                }
                int order = executed.size();
                for (Update u : updatesToRun) {
                    log.debugv("Executing updates for {0}", (Object)u.getId());
                    u.setLog(log);
                    u.setDb(db);
                    u.update(session);
                    this.createLog(changeLog, u, ++order);
                    log.debugv("Completed updates for {0}", (Object)u.getId());
                }
                log.debug((Object)"Completed database update");
            } else {
                log.debug((Object)"Skip database update. Database is already up to date");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update database", e);
        }
    }

    private void createLog(DBCollection changeLog, Update update, int orderExecuted) {
        changeLog.insert(new DBObject[]{new BasicDBObject("_id", (Object)update.getId()).append("dateExecuted", (Object)new Date()).append("orderExecuted", (Object)orderExecuted)});
    }

    public void close() {
    }
}

