/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.mongo.adapter.ResourceAdapter;
import org.keycloak.authorization.mongo.entities.ResourceEntity;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoResourceStore
implements ResourceStore {
    private final MongoStoreInvocationContext invocationContext;
    private final AuthorizationProvider authorizationProvider;

    public MongoResourceStore(MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        this.invocationContext = invocationContext;
        this.authorizationProvider = authorizationProvider;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        ResourceEntity entity = new ResourceEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity.setOwner(owner);
        this.getMongoStore().insertEntity(entity, this.getInvocationContext());
        return new ResourceAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public void delete(String id) {
        this.getMongoStore().removeEntity(ResourceEntity.class, id, this.getInvocationContext());
    }

    public Resource findById(String id) {
        ResourceEntity entity = this.getMongoStore().loadEntity(ResourceEntity.class, id, this.getInvocationContext());
        if (entity == null) {
            return null;
        }
        return new ResourceAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public List<Resource> findByOwner(String ownerId) {
        DBObject query = new QueryBuilder().and("owner").is((Object)ownerId).get();
        return this.getMongoStore().loadEntities(ResourceEntity.class, query, this.getInvocationContext()).stream().map(scope -> this.findById(scope.getId())).collect(Collectors.toList());
    }

    public List findByResourceServer(String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).get();
        return this.getMongoStore().loadEntities(ResourceEntity.class, query, this.getInvocationContext()).stream().map(scope -> this.findById(scope.getId())).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        QueryBuilder queryBuilder = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId);
        attributes.forEach((name, value) -> {
            if ("scope".equals(name)) {
                queryBuilder.and("scopes").in(value);
            } else {
                queryBuilder.and(name).regex(Pattern.compile(".*" + value[0] + ".*", 2));
            }
        });
        BasicDBObject sort = new BasicDBObject("name", (Object)1);
        return this.getMongoStore().loadEntities(ResourceEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResult, this.invocationContext).stream().map(scope -> this.findById(scope.getId())).collect(Collectors.toList());
    }

    public List<Resource> findByScope(String ... id) {
        DBObject query = new QueryBuilder().and("scopes").in((Object)id).get();
        return this.getMongoStore().loadEntities(ResourceEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public Resource findByName(String name, String resourceServerId) {
        DBObject query = new QueryBuilder().and("name").is((Object)name).and("resourceServerId").is((Object)resourceServerId).get();
        return this.getMongoStore().loadEntities(ResourceEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).findFirst().orElse(null);
    }

    public List<Resource> findByType(String type) {
        DBObject query = new QueryBuilder().and("type").is((Object)type).get();
        return this.getMongoStore().loadEntities(ResourceEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    private MongoStoreInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    private MongoStore getMongoStore() {
        return this.getInvocationContext().getMongoStore();
    }
}

