/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.adapters;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.CredentialEntity;
import org.keycloak.models.mongo.keycloak.entities.FederatedIdentityEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserConsentEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;
import org.keycloak.models.mongo.keycloak.entities.UserConsentEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoUserProvider
implements UserProvider,
UserCredentialStore {
    private final MongoStoreInvocationContext invocationContext;
    private final KeycloakSession session;

    public MongoUserProvider(KeycloakSession session, MongoStoreInvocationContext invocationContext) {
        this.session = session;
        this.invocationContext = invocationContext;
    }

    public void close() {
    }

    public UserAdapter getUserById(String id, RealmModel realm) {
        MongoUserEntity user = this.getMongoStore().loadEntity(MongoUserEntity.class, id, this.invocationContext);
        if (user == null || !realm.getId().equals(user.getRealmId())) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        DBObject query = new QueryBuilder().and("username").is((Object)username.toLowerCase()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        DBObject query = new QueryBuilder().and("email").is((Object)email.toLowerCase()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity user = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        if (user == null) {
            return null;
        }
        return new UserAdapter(this.session, realm, user, this.invocationContext);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        queryBuilder.and("groupIds").is((Object)group.getId());
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    protected MongoStore getMongoStore() {
        return this.invocationContext.getMongoStore();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, -1, -1);
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        DBObject query = new QueryBuilder().and("federatedIdentities.identityProvider").is((Object)socialLink.getIdentityProvider()).and("federatedIdentities.userId").is((Object)socialLink.getUserId()).and("realmId").is((Object)realm.getId()).get();
        MongoUserEntity userEntity = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    public UserModel getServiceAccount(ClientModel client) {
        DBObject query = new QueryBuilder().and("serviceAccountClientLink").is((Object)client.getId()).and("realmId").is((Object)client.getRealm().getId()).get();
        MongoUserEntity userEntity = this.getMongoStore().loadSingleEntity(MongoUserEntity.class, query, this.invocationContext);
        return userEntity == null ? null : new UserAdapter(this.session, client.getRealm(), userEntity, this.invocationContext);
    }

    protected List<UserModel> convertUserEntities(RealmModel realm, List<MongoUserEntity> userEntities) {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>();
        for (MongoUserEntity user : userEntities) {
            userModels.add(new UserAdapter(this.session, realm, user, this.invocationContext));
        }
        return userModels;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, -1, -1, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        return this.getMongoStore().countEntities(MongoUserEntity.class, query, this.invocationContext);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        if (!includeServiceAccounts) {
            queryBuilder = queryBuilder.and("serviceAccountClientLink").is(null);
        }
        DBObject query = queryBuilder.get();
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, query, (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder nameBuilder;
        search = search.trim();
        Pattern caseInsensitivePattern = Pattern.compile("(?i:" + search + ")");
        int spaceInd = search.lastIndexOf(" ");
        if (spaceInd != -1) {
            String firstName = search.substring(0, spaceInd);
            String lastName = search.substring(spaceInd + 1);
            Pattern firstNamePattern = Pattern.compile("(?i:" + firstName + "$)");
            Pattern lastNamePattern = Pattern.compile("(?i:^" + lastName + ")");
            nameBuilder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().put("firstName").regex(firstNamePattern).get(), new QueryBuilder().put("lastName").regex(lastNamePattern).get()});
        } else {
            nameBuilder = new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("firstName").regex(caseInsensitivePattern).get(), new QueryBuilder().put("lastName").regex(caseInsensitivePattern).get()});
        }
        QueryBuilder builder = new QueryBuilder().and(new DBObject[]{new QueryBuilder().and("realmId").is((Object)realm.getId()).get(), new QueryBuilder().and("serviceAccountClientLink").is(null).get(), new QueryBuilder().or(new DBObject[]{new QueryBuilder().put("username").regex(caseInsensitivePattern).get(), new QueryBuilder().put("email").regex(caseInsensitivePattern).get(), nameBuilder.get()}).get()});
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, builder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUser(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("username")) {
                queryBuilder.and("username").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("firstName")) {
                queryBuilder.and("firstName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (entry.getKey().equalsIgnoreCase("lastName")) {
                queryBuilder.and("lastName").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
                continue;
            }
            if (!entry.getKey().equalsIgnoreCase("email")) continue;
            queryBuilder.and("email").regex(Pattern.compile(".*" + entry.getValue() + ".*", 2));
        }
        BasicDBObject sort = new BasicDBObject("username", (Object)1);
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResults, this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        QueryBuilder queryBuilder = new QueryBuilder().and("realmId").is((Object)realm.getId());
        queryBuilder.and("attributes." + attrName).is((Object)attrValue);
        List<MongoUserEntity> users = this.getMongoStore().loadEntities(MongoUserEntity.class, queryBuilder.get(), this.invocationContext);
        return this.convertUserEntities(realm, users);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel userModel, RealmModel realm) {
        UserAdapter user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = user.getUser();
        List<FederatedIdentityEntity> linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<FederatedIdentityModel> result = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            FederatedIdentityModel model = new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken());
            result.add(model);
        }
        return result;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        UserAdapter mongoUser = this.getUserById(user.getId(), realm);
        MongoUserEntity userEntity = mongoUser.getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        return federatedIdentityEntity != null ? new FederatedIdentityModel(federatedIdentityEntity.getIdentityProvider(), federatedIdentityEntity.getUserId(), federatedIdentityEntity.getUserName(), federatedIdentityEntity.getToken()) : null;
    }

    public UserAdapter addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserAdapter userModel = this.addUserEntity(realm, id, username.toLowerCase());
        if (addDefaultRoles) {
            for (String r : realm.getDefaultRoles()) {
                userModel.grantRole(realm.getRole(r));
            }
            for (ClientModel application : realm.getClients()) {
                for (String r : application.getDefaultRoles()) {
                    userModel.grantRole(application.getRole(r));
                }
            }
            for (GroupModel g : realm.getDefaultGroups()) {
                userModel.joinGroup(g);
            }
        }
        if (addDefaultRequiredActions) {
            for (String r : realm.getRequiredActionProviders()) {
                if (!r.isEnabled() || !r.isDefaultAction()) continue;
                userModel.addRequiredAction(r.getAlias());
            }
        }
        return userModel;
    }

    protected UserAdapter addUserEntity(RealmModel realm, String id, String username) {
        MongoUserEntity userEntity = new MongoUserEntity();
        userEntity.setId(id);
        userEntity.setUsername(username);
        userEntity.setCreatedTimestamp(System.currentTimeMillis());
        userEntity.setRealmId(realm.getId());
        this.getMongoStore().insertEntity(userEntity, this.invocationContext);
        return new UserAdapter(this.session, realm, userEntity, this.invocationContext);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.getMongoStore().removeEntity(MongoUserEntity.class, user.getId(), this.invocationContext);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        UserAdapter mongoUser = this.getUserById(user.getId(), realm);
        MongoUserEntity userEntity = mongoUser.getUser();
        FederatedIdentityEntity federatedIdentityEntity = new FederatedIdentityEntity();
        federatedIdentityEntity.setIdentityProvider(identity.getIdentityProvider());
        federatedIdentityEntity.setUserId(identity.getUserId());
        federatedIdentityEntity.setUserName(identity.getUserName().toLowerCase());
        federatedIdentityEntity.setToken(identity.getToken());
        this.getMongoStore().pushItemToList(userEntity, "federatedIdentities", federatedIdentityEntity, true, this.invocationContext);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        UserAdapter mongoUser = this.getUserById(federatedUser.getId(), realm);
        MongoUserEntity userEntity = mongoUser.getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, federatedIdentityModel.getIdentityProvider());
        userEntity.getFederatedIdentities().remove(federatedIdentityEntity);
        federatedIdentityEntity.setToken(federatedIdentityModel.getToken());
        this.getMongoStore().pushItemToList(userEntity, "federatedIdentities", federatedIdentityEntity, true, this.invocationContext);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel userModel, String socialProvider) {
        UserAdapter user = this.getUserById(userModel.getId(), realm);
        MongoUserEntity userEntity = user.getUser();
        FederatedIdentityEntity federatedIdentityEntity = this.findFederatedIdentityLink(userEntity, socialProvider);
        if (federatedIdentityEntity == null) {
            return false;
        }
        return this.getMongoStore().pullItemFromList(userEntity, "federatedIdentities", federatedIdentityEntity, this.invocationContext);
    }

    private FederatedIdentityEntity findFederatedIdentityLink(MongoUserEntity userEntity, String identityProvider) {
        List<FederatedIdentityEntity> linkEntities = userEntity.getFederatedIdentities();
        if (linkEntities == null) {
            return null;
        }
        for (FederatedIdentityEntity federatedIdentityEntity : linkEntities) {
            if (!federatedIdentityEntity.getIdentityProvider().equals(identityProvider)) continue;
            return federatedIdentityEntity;
        }
        return null;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, null, username, true, true);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        DBObject update = new QueryBuilder().and("$push").is((Object)new BasicDBObject("roleIds", (Object)role.getId())).get();
        int count = this.getMongoStore().updateEntities(MongoUserEntity.class, query, update, this.invocationContext);
    }

    public void preRemove(RealmModel realm) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, true, this.invocationContext);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        DBObject query = new QueryBuilder().and("realmId").is((Object)realm.getId()).and("federationLink").is((Object)link.getId()).get();
        this.getMongoStore().removeEntities(MongoUserEntity.class, query, true, this.invocationContext);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        for (RoleModel role : client.getRoles()) {
            this.preRemove(realm, role);
        }
        DBObject query = new QueryBuilder().and("clientId").is((Object)client.getId()).get();
        this.getMongoStore().removeEntities(MongoUserConsentEntity.class, query, false, this.invocationContext);
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        DBObject query = new QueryBuilder().and("grantedProtocolMappers").is((Object)protocolMapper.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserConsentEntity.class, query, (DBObject)pull, this.invocationContext);
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        DBObject query = new QueryBuilder().and("groupIds").is((Object)group.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserEntity.class, query, (DBObject)pull, this.invocationContext);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        DBObject query = new QueryBuilder().and("roleIds").is((Object)role.getId()).get();
        BasicDBObject pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserEntity.class, query, (DBObject)pull, this.invocationContext);
        query = new QueryBuilder().and("grantedRoles").is((Object)role.getId()).get();
        pull = new BasicDBObject("$pull", (Object)query);
        this.getMongoStore().updateEntities(MongoUserConsentEntity.class, query, (DBObject)pull, this.invocationContext);
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        if (this.getConsentEntityByClientId(userId, clientId) != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + userId + "]");
        }
        long currentTime = Time.currentTimeMillis();
        MongoUserConsentEntity consentEntity = new MongoUserConsentEntity();
        consentEntity.setUserId(userId);
        consentEntity.setClientId(clientId);
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().insertEntity(consentEntity, this.invocationContext);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(userId, clientId);
        return consentEntity != null ? this.toConsentModel(realm, consentEntity) : null;
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        ArrayList<UserConsentModel> result = new ArrayList<UserConsentModel>();
        DBObject query = new QueryBuilder().and("userId").is((Object)userId).get();
        List<MongoUserConsentEntity> grantedConsents = this.getMongoStore().loadEntities(MongoUserConsentEntity.class, query, this.invocationContext);
        for (UserConsentEntity userConsentEntity : grantedConsents) {
            UserConsentModel model = this.toConsentModel(realm, userConsentEntity);
            result.add(model);
        }
        return result;
    }

    private MongoUserConsentEntity getConsentEntityByClientId(String userId, String clientId) {
        DBObject query = new QueryBuilder().and("userId").is((Object)userId).and("clientId").is((Object)clientId).get();
        return this.getMongoStore().loadSingleEntity(MongoUserConsentEntity.class, query, this.invocationContext);
    }

    private UserConsentModel toConsentModel(RealmModel realm, UserConsentEntity entity) {
        ClientModel client = realm.getClientById(entity.getClientId());
        if (client == null) {
            throw new ModelException("Client with id " + entity.getClientId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        for (String roleId : entity.getGrantedRoles()) {
            RoleModel roleModel = realm.getRoleById(roleId);
            if (roleModel == null) continue;
            model.addGrantedRole(roleModel);
        }
        for (String protMapperId : entity.getGrantedProtocolMappers()) {
            ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protMapperId);
            model.addGrantedProtocolMapper(protocolMapper);
        }
        return model;
    }

    private void fillEntityFromModel(UserConsentModel consent, MongoUserConsentEntity consentEntity) {
        LinkedList<String> roleIds = new LinkedList<String>();
        for (RoleModel role : consent.getGrantedRoles()) {
            roleIds.add(role.getId());
        }
        consentEntity.setGrantedRoles(roleIds);
        LinkedList<String> protMapperIds = new LinkedList<String>();
        for (ProtocolMapperModel protMapperModel : consent.getGrantedProtocolMappers()) {
            protMapperIds.add(protMapperModel.getId());
        }
        consentEntity.setGrantedProtocolMappers(protMapperIds);
        consentEntity.setLastUpdatedDate(Time.currentTimeMillis());
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        MongoUserConsentEntity consentEntity = this.getConsentEntityByClientId(userId, clientId);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.fillEntityFromModel(consent, consentEntity);
        this.getMongoStore().updateEntity(consentEntity, this.invocationContext);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientId) {
        MongoUserConsentEntity entity = this.getConsentEntityByClientId(userId, clientId);
        if (entity == null) {
            return false;
        }
        return this.getMongoStore().removeEntity(entity, this.invocationContext);
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        CredentialEntity credentialEntity = this.getCredentialEntity(cred, mongoUser);
        if (credentialEntity == null) {
            return;
        }
        if (credentialEntity.getId() == null) {
            credentialEntity.setId(KeycloakModelUtils.generateId());
        }
        this.setValues(cred, credentialEntity);
        this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
    }

    public CredentialEntity getCredentialEntity(CredentialModel cred, MongoUserEntity mongoUser) {
        CredentialEntity credentialEntity = null;
        for (CredentialEntity entity : mongoUser.getCredentials()) {
            if (cred.getId() != null && cred.getId().equals(entity.getId())) {
                credentialEntity = entity;
                break;
            }
            if (!cred.getType().equals(entity.getType())) continue;
            credentialEntity = entity;
            break;
        }
        return credentialEntity;
    }

    public MongoUserEntity getMongoUserEntity(UserModel user) {
        UserAdapter adapter = null;
        if (user instanceof CachedUserModel) {
            adapter = (UserAdapter)((CachedUserModel)user).getDelegateForUpdate();
        } else if (user instanceof UserAdapter) {
            adapter = (UserAdapter)user;
        } else {
            return this.getMongoStore().loadEntity(MongoUserEntity.class, user.getId(), this.invocationContext);
        }
        return adapter.getMongoEntity();
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        CredentialEntity credentialEntity = new CredentialEntity();
        credentialEntity.setId(KeycloakModelUtils.generateId());
        this.setValues(cred, credentialEntity);
        cred.setId(credentialEntity.getId());
        mongoUser.getCredentials().add(credentialEntity);
        this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
        cred.setId(credentialEntity.getId());
        return cred;
    }

    public void setValues(CredentialModel cred, CredentialEntity credentialEntity) {
        credentialEntity.setType(cred.getType());
        credentialEntity.setDevice(cred.getDevice());
        credentialEntity.setValue(cred.getValue());
        credentialEntity.setSalt(cred.getSalt());
        credentialEntity.setDevice(cred.getDevice());
        credentialEntity.setHashIterations(cred.getHashIterations());
        credentialEntity.setCounter(cred.getCounter());
        credentialEntity.setAlgorithm(cred.getAlgorithm());
        credentialEntity.setDigits(cred.getDigits());
        credentialEntity.setPeriod(cred.getPeriod());
        if (cred.getConfig() == null) {
            credentialEntity.setConfig(null);
        } else {
            if (credentialEntity.getConfig() == null) {
                credentialEntity.setConfig((Map<String, List<String>>)new MultivaluedHashMap());
            }
            credentialEntity.getConfig().clear();
            credentialEntity.getConfig().putAll((Map<String, List<String>>)cred.getConfig());
        }
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        Iterator<CredentialEntity> it = mongoUser.getCredentials().iterator();
        while (it.hasNext()) {
            CredentialEntity entity = it.next();
            if (!id.equals(entity.getId())) continue;
            it.remove();
            this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
            return true;
        }
        return false;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        for (CredentialEntity credEntity : mongoUser.getCredentials()) {
            if (!id.equals(credEntity.getId())) continue;
            if (credEntity.getId() == null) {
                credEntity.setId(KeycloakModelUtils.generateId());
                this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
            }
            return this.toModel(credEntity);
        }
        return null;
    }

    public CredentialModel toModel(CredentialEntity credEntity) {
        CredentialModel credModel = new CredentialModel();
        credModel.setId(credEntity.getId());
        credModel.setType(credEntity.getType());
        credModel.setDevice(credEntity.getDevice());
        credModel.setCreatedDate(credEntity.getCreatedDate());
        credModel.setValue(credEntity.getValue());
        credModel.setSalt(credEntity.getSalt());
        credModel.setHashIterations(credEntity.getHashIterations());
        credModel.setAlgorithm(credEntity.getAlgorithm());
        credModel.setCounter(credEntity.getCounter());
        credModel.setPeriod(credEntity.getPeriod());
        credModel.setDigits(credEntity.getDigits());
        if (credEntity.getConfig() != null) {
            credModel.setConfig(new MultivaluedHashMap());
            credModel.getConfig().putAll(credEntity.getConfig());
        }
        return credModel;
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        LinkedList<CredentialModel> list = new LinkedList<CredentialModel>();
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        boolean update = false;
        for (CredentialEntity credEntity : mongoUser.getCredentials()) {
            if (credEntity.getId() == null) {
                credEntity.setId(KeycloakModelUtils.generateId());
                update = true;
            }
            CredentialModel credModel = this.toModel(credEntity);
            list.add(credModel);
        }
        if (update) {
            this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
        }
        return list;
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        LinkedList<CredentialModel> list = new LinkedList<CredentialModel>();
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        boolean update = false;
        for (CredentialEntity credEntity : mongoUser.getCredentials()) {
            if (credEntity.getId() == null) {
                credEntity.setId(KeycloakModelUtils.generateId());
                update = true;
            }
            if (!credEntity.getType().equals(type)) continue;
            CredentialModel credModel = this.toModel(credEntity);
            list.add(credModel);
        }
        if (update) {
            this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
        }
        return list;
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        MongoUserEntity mongoUser = this.getMongoUserEntity(user);
        boolean update = false;
        CredentialModel credModel = null;
        for (CredentialEntity credEntity : mongoUser.getCredentials()) {
            if (credEntity.getId() == null) {
                credEntity.setId(KeycloakModelUtils.generateId());
                update = true;
            }
            if (!credEntity.getType().equals(type) || !name.equals(credEntity.getDevice())) continue;
            credModel = this.toModel(credEntity);
            break;
        }
        if (update) {
            this.getMongoStore().updateEntity(mongoUser, this.invocationContext);
        }
        return credModel;
    }
}

