/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.mongo.store;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.mongo.adapter.PolicyAdapter;
import org.keycloak.authorization.mongo.entities.PolicyEntity;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.connections.mongo.api.MongoStore;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MongoPolicyStore
implements PolicyStore {
    private final MongoStoreInvocationContext invocationContext;
    private final AuthorizationProvider authorizationProvider;

    public MongoPolicyStore(MongoStoreInvocationContext invocationContext, AuthorizationProvider authorizationProvider) {
        this.invocationContext = invocationContext;
        this.authorizationProvider = authorizationProvider;
    }

    public Policy create(String name, String type, ResourceServer resourceServer) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setType(type);
        entity.setResourceServerId(resourceServer.getId());
        this.getMongoStore().insertEntity(entity, this.getInvocationContext());
        return new PolicyAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public void delete(String id) {
        this.getMongoStore().removeEntity(PolicyEntity.class, id, this.getInvocationContext());
    }

    public Policy findById(String id) {
        PolicyEntity entity = this.getMongoStore().loadEntity(PolicyEntity.class, id, this.getInvocationContext());
        if (entity == null) {
            return null;
        }
        return new PolicyAdapter(entity, this.getInvocationContext(), this.authorizationProvider);
    }

    public Policy findByName(String name, String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).and("name").is((Object)name).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).findFirst().orElse(null);
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        QueryBuilder queryBuilder = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId);
        attributes.forEach((name, value) -> {
            if ("permission".equals(name)) {
                if (Boolean.valueOf(value[0]).booleanValue()) {
                    queryBuilder.and("type").in((Object)new String[]{"resource", "scope"});
                } else {
                    queryBuilder.and("type").notIn((Object)new String[]{"resource", "scope"});
                }
            } else if ("id".equals(name)) {
                queryBuilder.and("_id").in(value);
            } else {
                queryBuilder.and(name).regex(Pattern.compile(".*" + value[0] + ".*", 2));
            }
        });
        BasicDBObject sort = new BasicDBObject("name", (Object)1);
        return this.getMongoStore().loadEntities(PolicyEntity.class, queryBuilder.get(), (DBObject)sort, firstResult, maxResult, this.invocationContext).stream().map(policy -> this.findById(policy.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByResource(String resourceId) {
        DBObject query = new QueryBuilder().and("resources").is((Object)resourceId).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().filter(policyEntity -> {
            String defaultResourceType = policyEntity.getConfig().get("defaultResourceType");
            return defaultResourceType != null && defaultResourceType.equals(resourceType);
        }).map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        DBObject query = new QueryBuilder().and("resourceServerId").is((Object)resourceServerId).and("scopes").in(scopeIds).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByType(String type) {
        DBObject query = new QueryBuilder().and("type").is((Object)type).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    public List<Policy> findDependentPolicies(String policyId) {
        DBObject query = new QueryBuilder().and("associatedPolicies").is((Object)policyId).get();
        return this.getMongoStore().loadEntities(PolicyEntity.class, query, this.getInvocationContext()).stream().map(policyEntity -> this.findById(policyEntity.getId())).collect(Collectors.toList());
    }

    private MongoStoreInvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    private MongoStore getMongoStore() {
        return this.getInvocationContext().getMongoStore();
    }
}

