/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.utils;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.connections.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mongo.keycloak.adapters.ClientAdapter;
import org.keycloak.models.mongo.keycloak.adapters.ClientTemplateAdapter;
import org.keycloak.models.mongo.keycloak.adapters.UserAdapter;
import org.keycloak.models.mongo.keycloak.entities.MongoClientEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoClientTemplateEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRoleEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;

public class MongoModelUtils {
    public static List<RoleModel> getAllRolesOfUser(RealmModel realm, UserModel user) {
        MongoUserEntity userEntity = ((UserAdapter)user).getUser();
        List<String> roleIds = userEntity.getRoleIds();
        if (roleIds == null || roleIds.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<RoleModel> roles = new LinkedList<RoleModel>();
        for (String roleId : roleIds) {
            RoleModel role = realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public static List<MongoRoleEntity> getAllScopesOfClient(ClientModel client, MongoStoreInvocationContext invContext) {
        MongoClientEntity scopedEntity = ((ClientAdapter)client).getMongoEntity();
        List<String> scopeIds = scopedEntity.getScopeIds();
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.emptyList();
        }
        DBObject query = new QueryBuilder().and("_id").in(scopeIds).get();
        return invContext.getMongoStore().loadEntities(MongoRoleEntity.class, query, invContext);
    }

    public static List<MongoRoleEntity> getAllScopesOfTemplate(ClientTemplateModel template, MongoStoreInvocationContext invContext) {
        MongoClientTemplateEntity scopedEntity = ((ClientTemplateAdapter)template).getMongoEntity();
        List<String> scopeIds = scopedEntity.getScopeIds();
        if (scopeIds == null || scopeIds.isEmpty()) {
            return Collections.emptyList();
        }
        DBObject query = new QueryBuilder().and("_id").in(scopeIds).get();
        return invContext.getMongoStore().loadEntities(MongoRoleEntity.class, query, invContext);
    }
}

