/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientSessionAdapter
implements ClientSessionModel {
    private KeycloakSession session;
    private InfinispanUserSessionProvider provider;
    private Cache<String, SessionEntity> cache;
    private RealmModel realm;
    private ClientSessionEntity entity;

    public ClientSessionAdapter(KeycloakSession session, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache, RealmModel realm, ClientSessionEntity entity) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public ClientModel getClient() {
        return this.realm.getClientById(this.entity.getClient());
    }

    public UserSessionModel getUserSession() {
        return this.entity.getUserSession() != null ? this.provider.getUserSession(this.realm, this.entity.getUserSession()) : null;
    }

    public void setUserSession(UserSessionModel userSession) {
        if (userSession == null) {
            if (this.entity.getUserSession() != null) {
                this.provider.dettachSession(this.getUserSession(), this);
            }
            this.entity.setUserSession(null);
        } else {
            if (this.entity.getUserSession() != null) {
                if (this.entity.getUserSession().equals(userSession.getId())) {
                    return;
                }
                this.provider.dettachSession(userSession, this);
            } else {
                this.provider.attachSession(userSession, this);
            }
            this.entity.setUserSession(userSession.getId());
        }
        this.update();
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
        this.update();
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.update();
    }

    public ClientSessionModel.Action getAction() {
        return this.entity.getAction();
    }

    public void setAction(ClientSessionModel.Action action) {
        this.entity.setAction(action);
        this.update();
    }

    public Set<String> getRoles() {
        return this.entity.getRoles();
    }

    public void setRoles(Set<String> roles) {
        this.entity.setRoles(roles);
        this.update();
    }

    public Set<String> getProtocolMappers() {
        return this.entity.getProtocolMappers();
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        this.entity.setProtocolMappers(protocolMappers);
        this.update();
    }

    public String getAuthMethod() {
        return this.entity.getAuthMethod();
    }

    public void setAuthMethod(String authMethod) {
        this.entity.setAuthMethod(authMethod);
        this.update();
    }

    public String getNote(String name) {
        return this.entity.getNotes() != null ? this.entity.getNotes().get(name) : null;
    }

    public void setNote(String name, String value) {
        if (this.entity.getNotes() == null) {
            this.entity.setNotes(new HashMap<String, String>());
        }
        this.entity.getNotes().put(name, value);
        this.update();
    }

    public void removeNote(String name) {
        if (this.entity.getNotes() != null) {
            this.entity.getNotes().remove(name);
            this.update();
        }
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.entity.getId(), this.entity);
    }

    public Map<String, UserSessionModel.AuthenticatorStatus> getAuthenticators() {
        return this.entity.getAuthenticatorStatus();
    }

    public void setAuthenticatorStatus(String authenticator, UserSessionModel.AuthenticatorStatus status) {
        this.entity.getAuthenticatorStatus().put(authenticator, status);
    }

    public void setAuthenticatorStatus(Map<String, UserSessionModel.AuthenticatorStatus> status) {
        this.entity.setAuthenticatorStatus(status);
    }

    public UserModel getAuthenticatedUser() {
        return this.session.users().getUserById(this.entity.getAuthUserId(), this.realm);
    }

    public void setAuthenticatedUser(UserModel user) {
        this.entity.setAuthUserId(user.getId());
    }
}

