/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.sessions.infinispan.ClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.UsernameLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.mapreduce.ClientSessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.FirstResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.LargestResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.SessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserLoginFailureMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserSessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserSessionNoteMapper;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.util.Time;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    private final KeycloakSession session;
    private final Cache<String, SessionEntity> sessionCache;
    private final Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache;
    private final InfinispanKeycloakTransaction tx;

    public InfinispanUserSessionProvider(KeycloakSession session, Cache<String, SessionEntity> sessionCache, Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.loginFailureCache = loginFailureCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransaction().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        String id = KeycloakModelUtils.generateId();
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setClient(client.getId());
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        String id = KeycloakModelUtils.generateId();
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        ClientSessionEntity entity = (ClientSessionEntity)this.sessionCache.get((Object)id);
        return this.wrap(realm, entity);
    }

    public ClientSessionModel getClientSession(String id) {
        ClientSessionEntity entity = (ClientSessionEntity)this.sessionCache.get((Object)id);
        if (entity != null) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealm());
            return this.wrap(realm, entity);
        }
        return null;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        UserSessionEntity entity = (UserSessionEntity)this.sessionCache.get((Object)id);
        return this.wrap(realm, entity);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values());
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerUserId(brokerUserId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values());
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerSessionId(brokerSessionId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        List<UserSessionModel> userSessionModels = this.wrapUserSessions(realm, sessions.values());
        if (userSessionModels.isEmpty()) {
            return null;
        }
        return userSessionModels.get(0);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        List sessionTimestamps = new LinkedList(map.entrySet());
        Collections.sort(sessionTimestamps, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        if (firstResult != -1 || maxResults == -1) {
            if (firstResult == -1) {
                firstResult = 0;
            }
            if (maxResults == -1) {
                maxResults = Integer.MAX_VALUE;
            }
            if (firstResult > sessionTimestamps.size()) {
                return Collections.emptyList();
            }
            int toIndex = firstResult + maxResults < sessionTimestamps.size() ? firstResult + maxResults : sessionTimestamps.size();
            sessionTimestamps = sessionTimestamps.subList(firstResult, toIndex);
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (Map.Entry entry : sessionTimestamps) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)this.sessionCache.get(entry.getKey());
            if (userSessionEntity == null) continue;
            userSessions.add(this.wrap(realm, userSessionEntity));
        }
        return userSessions;
    }

    public List<UserSessionModel> getUserSessionsByNote(RealmModel realm, String noteName, String noteValue) {
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put(noteName, noteValue);
        return this.getUserSessionsByNotes(realm, notes);
    }

    public List<UserSessionModel> getUserSessionsByNotes(RealmModel realm, Map<String, String> notes) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionNoteMapper.create(realm.getId()).notes(notes)).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values());
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        return map.size();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        this.removeUserSession(realm, session.getId());
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : sessions.keySet()) {
            this.removeUserSession(realm, id);
        }
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        int expiredDettachedClientSession = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).expired(expired, expiredRefresh).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.removeUserSession(realm, id);
        }
        map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).expiredRefresh(expiredDettachedClientSession).requireNullUserSession(true).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
    }

    public void removeUserSessions(RealmModel realm) {
        Map ids = new MapReduceTask(this.sessionCache).mappedWith((Mapper)SessionMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : ids.keySet()) {
            this.sessionCache.remove((Object)id);
        }
    }

    public UsernameLoginFailureModel getUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        return this.wrap(key, (LoginFailureEntity)this.loginFailureCache.get((Object)key));
    }

    public UsernameLoginFailureModel addUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        LoginFailureEntity entity = new LoginFailureEntity();
        entity.setRealm(realm.getId());
        entity.setUsername(username);
        this.tx.put(this.loginFailureCache, key, entity);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        this.tx.remove(this.loginFailureCache, key);
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        Map sessions = new MapReduceTask(this.loginFailureCache).mappedWith((Mapper)UserLoginFailureMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (LoginFailureKey id : sessions.keySet()) {
            this.tx.remove(this.loginFailureCache, id);
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
        this.removeAllUserLoginFailures(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user);
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getEmail()));
    }

    public void close() {
    }

    void attachSession(UserSessionModel userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() == null) {
            entity.setClientSessions(new HashSet<String>());
        }
        if (!entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().add(clientSessionId);
            this.tx.replace(this.sessionCache, entity.getId(), entity);
        }
    }

    public void removeClientSession(RealmModel realm, ClientSessionModel clientSession) {
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
            if (entity.getClientSessions() != null) {
                entity.getClientSessions().remove(clientSession.getId());
            }
            this.tx.replace(this.sessionCache, entity.getId(), entity);
        }
        this.tx.remove(this.sessionCache, clientSession.getId());
    }

    void dettachSession(UserSessionModel userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() != null && entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().remove(clientSessionId);
            if (entity.getClientSessions().isEmpty()) {
                entity.setClientSessions(null);
            }
            this.tx.replace(this.sessionCache, entity.getId(), entity);
        }
    }

    protected void removeUserSession(RealmModel realm, String userSessionId) {
        this.tx.remove(this.sessionCache, userSessionId);
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).userSession(userSessionId).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
    }

    InfinispanKeycloakTransaction getTx() {
        return this.tx;
    }

    UserSessionModel wrap(RealmModel realm, UserSessionEntity entity) {
        return entity != null ? new UserSessionAdapter(this.session, this, this.sessionCache, realm, entity) : null;
    }

    List<UserSessionModel> wrapUserSessions(RealmModel realm, Collection<UserSessionEntity> entities) {
        LinkedList<UserSessionModel> models = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : entities) {
            models.add(this.wrap(realm, e));
        }
        return models;
    }

    ClientSessionModel wrap(RealmModel realm, ClientSessionEntity entity) {
        return entity != null ? new ClientSessionAdapter(this.session, this, this.sessionCache, realm, entity) : null;
    }

    UsernameLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UsernameLoginFailureAdapter(this, this.loginFailureCache, key, entity) : null;
    }

    List<ClientSessionModel> wrapClientSessions(RealmModel realm, Collection<ClientSessionEntity> entities) {
        LinkedList<ClientSessionModel> models = new LinkedList<ClientSessionModel>();
        for (ClientSessionEntity e : entities) {
            models.add(this.wrap(realm, e));
        }
        return models;
    }

    public static enum CacheOperation {
        ADD,
        REMOVE,
        REPLACE;

    }

    class InfinispanKeycloakTransaction
    implements KeycloakTransaction {
        private boolean active;
        private boolean rollback;
        private Map<Object, CacheTask> tasks = new HashMap<Object, CacheTask>();

        InfinispanKeycloakTransaction() {
        }

        public void begin() {
            this.active = true;
        }

        public void commit() {
            if (this.rollback) {
                throw new RuntimeException("Rollback only!");
            }
            for (CacheTask task : this.tasks.values()) {
                task.execute();
            }
        }

        public void rollback() {
            this.tasks.clear();
        }

        public void setRollbackOnly() {
            this.rollback = true;
        }

        public boolean getRollbackOnly() {
            return this.rollback;
        }

        public boolean isActive() {
            return this.active;
        }

        public void put(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD, key);
            if (this.tasks.containsKey(key)) {
                throw new IllegalStateException("Can't add session: task in progress for session");
            }
            this.tasks.put(key, new CacheTask(cache, CacheOperation.ADD, key, value));
        }

        public void replace(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REPLACE, key);
            CacheTask current = this.tasks.get(key);
            if (current != null) {
                switch (current.operation) {
                    case ADD: 
                    case REPLACE: {
                        current.value = value;
                        return;
                    }
                    case REMOVE: {
                        return;
                    }
                }
            } else {
                this.tasks.put(key, new CacheTask(cache, CacheOperation.REPLACE, key, value));
            }
        }

        public void remove(Cache cache, Object key) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
            this.tasks.put(key, new CacheTask(cache, CacheOperation.REMOVE, key, null));
        }

        public class CacheTask {
            private Cache cache;
            private CacheOperation operation;
            private Object key;
            private Object value;

            public CacheTask(Cache cache, CacheOperation operation, Object key, Object value) {
                this.cache = cache;
                this.operation = operation;
                this.key = key;
                this.value = value;
            }

            public void execute() {
                log.tracev("Executing cache operation: {0} on {1}", (Object)this.operation, this.key);
                switch (this.operation) {
                    case ADD: {
                        this.cache.put(this.key, this.value);
                        break;
                    }
                    case REMOVE: {
                        this.cache.remove(this.key);
                        break;
                    }
                    case REPLACE: {
                        this.cache.replace(this.key, this.value);
                    }
                }
            }
        }
    }
}

