/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.ClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.mapreduce.ClientInitialAccessMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.ClientSessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.FirstResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.LargestResultReducer;
import org.keycloak.models.sessions.infinispan.mapreduce.SessionMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserLoginFailureMapper;
import org.keycloak.models.sessions.infinispan.mapreduce.UserSessionMapper;
import org.keycloak.models.utils.RealmInfoUtil;

public class CompatInfinispanUserSessionProvider
extends InfinispanUserSessionProvider {
    private static final Logger log = Logger.getLogger(CompatInfinispanUserSessionProvider.class);

    public CompatInfinispanUserSessionProvider(KeycloakSession session, Cache<String, SessionEntity> sessionCache, Cache<String, SessionEntity> offlineSessionCache, Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache) {
        super(session, sessionCache, offlineSessionCache, loginFailureCache);
    }

    @Override
    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values(), false);
    }

    @Override
    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerUserId(brokerUserId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapUserSessions(realm, sessions.values(), false);
    }

    @Override
    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        Map sessions = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).brokerSessionId(brokerSessionId)).reducedWith((Reducer)new FirstResultReducer()).execute();
        List<UserSessionModel> userSessionModels = this.wrapUserSessions(realm, sessions.values(), false);
        if (userSessionModels.isEmpty()) {
            return null;
        }
        return userSessionModels.get(0);
    }

    @Override
    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    @Override
    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    @Override
    protected List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        List sessionTimestamps = new LinkedList(map.entrySet());
        Collections.sort(sessionTimestamps, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> e1, Map.Entry<String, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        if (firstResult != -1 || maxResults == -1) {
            if (firstResult == -1) {
                firstResult = 0;
            }
            if (maxResults == -1) {
                maxResults = Integer.MAX_VALUE;
            }
            if (firstResult > sessionTimestamps.size()) {
                return Collections.emptyList();
            }
            int toIndex = firstResult + maxResults < sessionTimestamps.size() ? firstResult + maxResults : sessionTimestamps.size();
            sessionTimestamps = sessionTimestamps.subList(firstResult, toIndex);
        }
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        for (Map.Entry entry : sessionTimestamps) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)cache.get(entry.getKey());
            if (userSessionEntity == null) continue;
            userSessions.add(this.wrap(realm, userSessionEntity, offline));
        }
        return userSessions;
    }

    @Override
    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    @Override
    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId()).emitUserSessionAndTimestamp()).reducedWith((Reducer)new LargestResultReducer()).execute();
        return map.size();
    }

    @Override
    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        this.removeUserSession(realm, session.getId());
    }

    @Override
    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    @Override
    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map sessions = new MapReduceTask(cache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : sessions.keySet()) {
            this.removeUserSession(realm, id, offline);
        }
    }

    @Override
    public void removeExpired(RealmModel realm) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout();
        int expiredDettachedClientSession = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Map map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).expired(expired, expiredRefresh).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.removeUserSession(realm, id);
        }
        map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).expiredRefresh(expiredDettachedClientSession).requireNullUserSession(true).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
        Map map2 = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).expired(null, expiredOffline)).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (Map.Entry entry : map2.entrySet()) {
            String userSessionId = (String)entry.getKey();
            this.tx.remove(this.offlineSessionCache, userSessionId);
            persister.removeUserSession(userSessionId, true);
            UserSessionEntity entity = (UserSessionEntity)entry.getValue();
            for (String clientSessionId : entity.getClientSessions()) {
                this.tx.remove(this.offlineSessionCache, clientSessionId);
            }
        }
        map = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).expiredRefresh(expiredOffline).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String clientSessionId : map.keySet()) {
            this.tx.remove(this.offlineSessionCache, clientSessionId);
            persister.removeClientSession(clientSessionId, true);
        }
        map = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientInitialAccessMapper.create(realm.getId()).expired(Time.currentTime()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(this.sessionCache, id);
        }
    }

    @Override
    public void removeUserSessions(RealmModel realm) {
        this.removeUserSessions(realm, false);
    }

    @Override
    protected void removeUserSessions(RealmModel realm, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map ids = new MapReduceTask(cache).mappedWith((Mapper)SessionMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : ids.keySet()) {
            cache.remove((Object)id);
        }
    }

    @Override
    public void removeUserLoginFailure(RealmModel realm, String username) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), username);
        this.tx.remove(this.loginFailureCache, key);
    }

    @Override
    public void removeAllUserLoginFailures(RealmModel realm) {
        Map sessions = new MapReduceTask(this.loginFailureCache).mappedWith((Mapper)UserLoginFailureMapper.create(realm.getId()).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (LoginFailureKey id : sessions.keySet()) {
            this.tx.remove(this.loginFailureCache, id);
        }
    }

    @Override
    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm, true);
        this.removeUserSessions(realm, false);
        this.removeAllUserLoginFailures(realm);
    }

    @Override
    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(realm, client, true);
        this.onClientRemoved(realm, client, false);
    }

    private void onClientRemoved(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).client(client.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (Map.Entry entry : map.entrySet()) {
            ClientSessionAdapter adapter = this.wrap(realm, (ClientSessionEntity)entry.getValue(), offline);
            adapter.setUserSession(null);
            this.tx.remove(cache, entry.getKey());
        }
    }

    @Override
    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getEmail()));
    }

    @Override
    public void removeClientSession(RealmModel realm, ClientSessionModel clientSession) {
        this.removeClientSession(realm, clientSession, false);
    }

    @Override
    protected void removeClientSession(RealmModel realm, ClientSessionModel clientSession, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
            if (entity.getClientSessions() != null) {
                entity.getClientSessions().remove(clientSession.getId());
            }
            this.tx.replace(cache, entity.getId(), entity);
        }
        this.tx.remove(cache, clientSession.getId());
    }

    protected void removeUserSession(RealmModel realm, String userSessionId) {
        this.removeUserSession(realm, userSessionId, false);
    }

    @Override
    protected void removeUserSession(RealmModel realm, String userSessionId, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.remove(cache, userSessionId);
        Map map = new MapReduceTask(cache).mappedWith((Mapper)ClientSessionMapper.create(realm.getId()).userSession(userSessionId).emitKey()).reducedWith((Reducer)new FirstResultReducer()).execute();
        for (String id : map.keySet()) {
            this.tx.remove(cache, id);
        }
    }

    @Override
    public void removeOfflineUserSession(RealmModel realm, String userSessionId) {
        this.removeUserSession(realm, userSessionId, true);
    }

    @Override
    public List<ClientSessionModel> getOfflineClientSessions(RealmModel realm, UserModel user) {
        Map sessions = new MapReduceTask(this.offlineSessionCache).mappedWith((Mapper)UserSessionMapper.create(realm.getId()).user(user.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        LinkedList<ClientSessionEntity> clientSessions = new LinkedList<ClientSessionEntity>();
        for (UserSessionEntity userSession : sessions.values()) {
            Set<String> currClientSessions = userSession.getClientSessions();
            for (String clientSessionId : currClientSessions) {
                ClientSessionEntity cls = (ClientSessionEntity)this.offlineSessionCache.get((Object)clientSessionId);
                if (cls == null) continue;
                clientSessions.add(cls);
            }
        }
        return this.wrapClientSessions(realm, clientSessions, true);
    }

    @Override
    public void removeOfflineClientSession(RealmModel realm, String clientSessionId) {
        ClientSessionModel clientSession = this.getOfflineClientSession(realm, clientSessionId);
        this.removeClientSession(realm, clientSession, true);
    }

    @Override
    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    @Override
    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    @Override
    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        Map entities = new MapReduceTask(this.sessionCache).mappedWith((Mapper)ClientInitialAccessMapper.create(realm.getId())).reducedWith((Reducer)new FirstResultReducer()).execute();
        return this.wrapClientInitialAccess(realm, entities.values());
    }
}

