/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.infinispan.Version;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.CompatInfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.compat.MemUserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.compat.SimpleUserSessionInitializer;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanUserSessionInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflineUserSessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    private Config.Scope config;
    private Boolean compatMode;
    private MemUserSessionProviderFactory compatProviderFactory;

    public UserSessionProvider create(KeycloakSession session) {
        if (!this.compatMode.booleanValue()) {
            InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            Cache cache = connections.getCache("sessions");
            Cache offlineSessionsCache = connections.getCache("offlineSessions");
            Cache loginFailures = connections.getCache("loginFailures");
            return this.isStreamMode() ? new InfinispanUserSessionProvider(session, (Cache<String, SessionEntity>)cache, (Cache<String, SessionEntity>)offlineSessionsCache, (Cache<LoginFailureKey, LoginFailureEntity>)loginFailures) : new CompatInfinispanUserSessionProvider(session, (Cache<String, SessionEntity>)cache, (Cache<String, SessionEntity>)offlineSessionsCache, (Cache<LoginFailureKey, LoginFailureEntity>)loginFailures);
        }
        return this.compatProviderFactory.create(session);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(final KeycloakSessionFactory factory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanUserSessionProviderFactory.this.compatMode = InfinispanUserSessionProviderFactory.this.isCompatMode(session);
                if (InfinispanUserSessionProviderFactory.this.compatMode.booleanValue()) {
                    InfinispanUserSessionProviderFactory.this.compatProviderFactory = new MemUserSessionProviderFactory();
                }
            }
        });
        final int maxErrors = this.config.getInt("maxErrors", Integer.valueOf(20));
        final int sessionsPerSegment = this.config.getInt("sessionsPerSegment", Integer.valueOf(100));
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    InfinispanUserSessionProviderFactory.this.loadPersistentSessions(factory, maxErrors, sessionsPerSegment);
                }
            }
        });
    }

    public void loadPersistentSessions(final KeycloakSessionFactory sessionFactory, final int maxErrors, final int sessionsPerSegment) {
        log.debug((Object)"Start pre-loading userSessions and clientSessions from persistent storage");
        if (this.compatMode.booleanValue()) {
            SimpleUserSessionInitializer initializer = new SimpleUserSessionInitializer(sessionFactory, new OfflineUserSessionLoader(), sessionsPerSegment);
            initializer.loadPersistentSessions();
        } else {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                public void run(KeycloakSession session) {
                    InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    Cache cache = connections.getCache("offlineSessions");
                    InfinispanUserSessionInitializer initializer = new InfinispanUserSessionInitializer(sessionFactory, (Cache<String, SessionEntity>)cache, new OfflineUserSessionLoader(), maxErrors, sessionsPerSegment, "offlineUserSessions");
                    initializer.initCache();
                    initializer.loadPersistentSessions();
                }
            });
        }
        log.debug((Object)"Pre-loading userSessions and clientSessions from persistent storage finished");
    }

    public void close() {
        if (this.compatProviderFactory != null) {
            this.compatProviderFactory.close();
        }
    }

    public String getId() {
        return "infinispan";
    }

    private boolean isCompatMode(KeycloakSession session) {
        InfinispanConnectionProvider connections;
        Cache cache;
        if (this.config.getBoolean("enforceCompat", Boolean.valueOf(false)).booleanValue()) {
            log.info((Object)"Enforced compatibility mode for infinispan. Falling back to deprecated mem user session provider.");
            return true;
        }
        if (Version.getVersionShort() < Version.getVersionShort((String)"5.3.0.Final") && (cache = (connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("sessions")).getAdvancedCache().getRpcManager() == null) {
            log.info((Object)"Infinispan version doesn't support map reduce for local cache. Falling back to deprecated mem user session provider.");
            return true;
        }
        return false;
    }

    private boolean isStreamMode() {
        return Version.getVersionShort() >= Version.getVersionShort((String)"8.1.0.Final");
    }
}

