/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.storage.datastore.DefaultExportImportManager;

public class ImportUtils {
    private static final Logger logger = Logger.getLogger(ImportUtils.class);

    public static void importRealms(KeycloakSession session, Collection<RealmRepresentation> realms, Strategy strategy) {
        boolean masterImported = false;
        for (RealmRepresentation realm2 : realms) {
            if (!Config.getAdminRealm().equals(realm2.getRealm()) || !ImportUtils.importRealm(session, realm2, strategy, false)) continue;
            masterImported = true;
        }
        for (RealmRepresentation realm2 : realms) {
            if (Config.getAdminRealm().equals(realm2.getRealm())) continue;
            ImportUtils.importRealm(session, realm2, strategy, false);
        }
        if (masterImported) {
            session.realms().getRealmsStream().filter(realm -> realm.getMasterAdminClient() == null).forEach(realm -> {
                logger.infof("Re-created management client in master realm for realm '%s'", (Object)realm.getName());
                new RealmManager(session).setupMasterAdminManagement(realm);
            });
        }
    }

    public static boolean importRealm(KeycloakSession session, RealmRepresentation rep, Strategy strategy, boolean skipUserDependent) {
        String realmName = rep.getRealm();
        RealmProvider model = session.realms();
        RealmModel realm = model.getRealmByName(realmName);
        if (realm != null) {
            session.getContext().setRealm(realm);
            if (strategy == Strategy.IGNORE_EXISTING) {
                logger.infof("Realm '%s' already exists. Import skipped", (Object)realmName);
                return false;
            }
            logger.infof("Realm '%s' already exists. Removing it before import", (Object)realmName);
            if (Config.getAdminRealm().equals(realm.getId())) {
                model.getRealmsStream().forEach(r -> r.setMasterAdminClient(null));
            }
            model.removeRealm(realm.getId());
            session.getContext().setRealm(null);
        }
        RealmManager realmManager = new RealmManager(session);
        realmManager.importRealm(rep, skipUserDependent);
        if (System.getProperty("keycloak.migration.action") != null) {
            logger.infof("Realm '%s' imported", (Object)realmName);
        }
        return true;
    }

    public static void importFromStream(KeycloakSession session, ObjectMapper mapper, InputStream is, Strategy strategy) throws IOException {
        Map<String, RealmRepresentation> realmReps = ImportUtils.getRealmsFromStream(mapper, is);
        ImportUtils.importRealms(session, realmReps.values(), strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, RealmRepresentation> getRealmsFromStream(ObjectMapper mapper, InputStream is) throws IOException {
        HashMap<String, RealmRepresentation> result = new HashMap<String, RealmRepresentation>();
        JsonFactory factory = mapper.getFactory();
        try (JsonParser parser = factory.createParser(is);){
            parser.nextToken();
            if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                parser.nextToken();
                ArrayList<RealmRepresentation> realmReps = new ArrayList<RealmRepresentation>();
                while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    RealmRepresentation realmRep = (RealmRepresentation)parser.readValueAs(RealmRepresentation.class);
                    parser.nextToken();
                    if (Config.getAdminRealm().equals(realmRep.getRealm())) {
                        realmReps.add(0, realmRep);
                        continue;
                    }
                    realmReps.add(realmRep);
                }
                for (RealmRepresentation realmRep : realmReps) {
                    result.put(realmRep.getRealm(), realmRep);
                }
            } else if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                RealmRepresentation realmRep = (RealmRepresentation)parser.readValueAs(RealmRepresentation.class);
                result.put(realmRep.getRealm(), realmRep);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importUsersFromStream(KeycloakSession session, String realmName, ObjectMapper mapper, InputStream is) throws IOException {
        RealmProvider model = session.realms();
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonParser parser = factory.createJsonParser(is);){
            parser.nextToken();
            while (parser.nextToken() == JsonToken.FIELD_NAME) {
                if ("realm".equals(parser.getText())) {
                    parser.nextToken();
                    String currRealmName = parser.getText();
                    if (currRealmName.equals(realmName)) continue;
                    throw new IllegalStateException("Trying to import users into invalid realm. Realm name: " + realmName + ", Expected realm name: " + currRealmName);
                }
                if (!"users".equals(parser.getText())) continue;
                parser.nextToken();
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    parser.nextToken();
                }
                ArrayList<UserRepresentation> userReps = new ArrayList<UserRepresentation>();
                while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    UserRepresentation user = (UserRepresentation)parser.readValueAs(UserRepresentation.class);
                    userReps.add(user);
                    parser.nextToken();
                }
                ImportUtils.importUsers(session, model, realmName, userReps);
                if (parser.getCurrentToken() != JsonToken.END_ARRAY) continue;
                parser.nextToken();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFederatedUsersFromStream(KeycloakSession session, String realmName, ObjectMapper mapper, InputStream is) throws IOException {
        RealmProvider model = session.realms();
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonParser parser = factory.createJsonParser(is);){
            parser.nextToken();
            while (parser.nextToken() == JsonToken.FIELD_NAME) {
                if ("realm".equals(parser.getText())) {
                    parser.nextToken();
                    String currRealmName = parser.getText();
                    if (currRealmName.equals(realmName)) continue;
                    throw new IllegalStateException("Trying to import users into invalid realm. Realm name: " + realmName + ", Expected realm name: " + currRealmName);
                }
                if (!"federatedUsers".equals(parser.getText())) continue;
                parser.nextToken();
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    parser.nextToken();
                }
                ArrayList<UserRepresentation> userReps = new ArrayList<UserRepresentation>();
                while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    UserRepresentation user = (UserRepresentation)parser.readValueAs(UserRepresentation.class);
                    userReps.add(user);
                    parser.nextToken();
                }
                ImportUtils.importFederatedUsers(session, model, realmName, userReps);
                if (parser.getCurrentToken() != JsonToken.END_ARRAY) continue;
                parser.nextToken();
            }
        }
    }

    private static void importUsers(KeycloakSession session, RealmProvider model, String realmName, List<UserRepresentation> userReps) {
        RealmModel realm = model.getRealmByName(realmName);
        for (UserRepresentation user : userReps) {
            RepresentationToModel.createUser((KeycloakSession)session, (RealmModel)realm, (UserRepresentation)user);
        }
    }

    private static void importFederatedUsers(KeycloakSession session, RealmProvider model, String realmName, List<UserRepresentation> userReps) {
        RealmModel realm = model.getRealmByName(realmName);
        for (UserRepresentation user : userReps) {
            DefaultExportImportManager.importFederatedUser((KeycloakSession)session, (RealmModel)realm, (UserRepresentation)user);
        }
    }
}

