"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _selectCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/Select/select.css.js"));

var _reactStyles = require("@patternfly/react-styles");

var _util = require("../../helpers/util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var propTypes = {
  /** Content rendered inside the SingleSelect */
  children: _propTypes["default"].node.isRequired,

  /** Additional classes added to the SingleSelect control */
  className: _propTypes["default"].string,

  /** Flag indicating the Select is expanded */
  isExpanded: _propTypes["default"].bool,

  /** Internal flag indicating whether select was opened via keyboard */
  openedOnEnter: _propTypes["default"].bool,

  /** Currently selected option */
  selected: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].array]),

  /** Internal handler for ref handling */
  sendRef: _propTypes["default"]["function"],

  /** Additional props are spread to the container <select> */
  '': _propTypes["default"].any // eslint-disable-line react/require-default-props

};
var defaultProps = {
  className: '',
  isExpanded: false,
  openedOnEnter: false,
  selected: '',
  sendRef: Function.prototype
};

var SingleSelect =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SingleSelect, _React$Component);

  function SingleSelect() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, SingleSelect);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(SingleSelect)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "refCollection", []);

    _defineProperty(_assertThisInitialized(_this), "childKeyHandler", function (index, position) {
      (0, _util.keyHandler)(index, position, _this.refCollection, _this.props.children);
    });

    _defineProperty(_assertThisInitialized(_this), "sendListRef", function (ref, index) {
      _this.refCollection[index] = ref;
    });

    return _this;
  }

  _createClass(SingleSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.openedOnEnter) {
        var selectedRef = this.refCollection.filter(function (ref) {
          return ref.classList.contains('pf-m-selected');
        });
        selectedRef && selectedRef[0] ? selectedRef[0].focus() : this.refCollection[0].focus();
      }
    }
  }, {
    key: "extendChildren",
    value: function extendChildren() {
      var _this2 = this;

      var _this$props = this.props,
          selected = _this$props.selected,
          sendRef = _this$props.sendRef;
      return _react["default"].Children.map(this.props.children, function (child, index) {
        var isSelected = selected && selected.constructor === Array ? selected && selected.includes(child.props.value) : selected === child.props.value;
        return _react["default"].cloneElement(child, {
          id: "".concat(child.props.value, "-").concat(index),
          isSelected: isSelected,
          sendRef: sendRef,
          sendListRef: _this2.sendListRef,
          keyHandler: _this2.childKeyHandler,
          index: index
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          children = _this$props2.children,
          className = _this$props2.className,
          isExpanded = _this$props2.isExpanded,
          openedOnEnter = _this$props2.openedOnEnter,
          selected = _this$props2.selected,
          sendRef = _this$props2.sendRef,
          props = _objectWithoutProperties(_this$props2, ["children", "className", "isExpanded", "openedOnEnter", "selected", "sendRef"]);

      this.renderedChildren = this.extendChildren();
      return _react["default"].createElement("ul", _extends({}, props, {
        className: (0, _reactStyles.css)(_selectCss["default"].selectMenu, className),
        role: "listbox"
      }), this.renderedChildren);
    }
  }]);

  return SingleSelect;
}(_react["default"].Component);

SingleSelect.propTypes = propTypes;
SingleSelect.defaultProps = defaultProps;
var _default = SingleSelect;
exports["default"] = _default;