"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@tippy.js/react", "../../helpers/constants", "../../@patternfly/patternfly/components/Popover/popover.css.js", "@patternfly/react-styles", "./PopoverArrow", "./PopoverContent", "./PopoverBody", "./PopoverHeader", "./PopoverFooter", "./PopoverCloseButton", "../../helpers/GenerateId/GenerateId", "@patternfly/react-tokens", "../Tooltip/styles", 'focus-trap-react'], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@tippy.js/react"), require("../../helpers/constants"), require("../../@patternfly/patternfly/components/Popover/popover.css.js"), require("@patternfly/react-styles"), require("./PopoverArrow"), require("./PopoverContent"), require("./PopoverBody"), require("./PopoverHeader"), require("./PopoverFooter"), require("./PopoverCloseButton"), require("../../helpers/GenerateId/GenerateId"), require("@patternfly/react-tokens"), require("../Tooltip/styles"), require('focus-trap-react'));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.react, global.constants, global.popoverCss, global.reactStyles, global.PopoverArrow, global.PopoverContent, global.PopoverBody, global.PopoverHeader, global.PopoverFooter, global.PopoverCloseButton, global.GenerateId, global.reactTokens, global.styles, global.focusTrapReact);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _react2, _constants, _popoverCss, _reactStyles, _PopoverArrow, _PopoverContent, _PopoverBody, _PopoverHeader, _PopoverFooter, _PopoverCloseButton, _GenerateId, _reactTokens, _styles, FocusTrap) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.Popover = exports.PopoverPosition = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _react3 = _interopRequireDefault(_react2);

  var _popoverCss2 = _interopRequireDefault(_popoverCss);

  var _GenerateId2 = _interopRequireDefault(_GenerateId);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _typeof2(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof2 = function _typeof2(obj) {
        return typeof obj;
      };
    } else {
      _typeof2 = function _typeof2(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }

    return _typeof2(obj);
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
      _typeof = function _typeof(obj) {
        return _typeof2(obj);
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
      };
    }

    return _typeof(obj);
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  (0, _styles.tippyStyles)();
  var PopoverPosition = exports.PopoverPosition = undefined;

  (function (PopoverPosition) {
    PopoverPosition["top"] = "top";
    PopoverPosition["bottom"] = "bottom";
    PopoverPosition["left"] = "left";
    PopoverPosition["right"] = "right";
  })(PopoverPosition || (exports.PopoverPosition = PopoverPosition = {}));

  ;

  var Popover = exports.Popover = function (_React$Component) {
    _inherits(Popover, _React$Component);

    function Popover(props) {
      var _this;

      _classCallCheck(this, Popover);

      _this = _possibleConstructorReturn(this, _getPrototypeOf(Popover).call(this, props));

      _defineProperty(_assertThisInitialized(_this), "hideOrNotify", function () {
        if (_this.props.isVisible === null) {
          // Handle closing
          _this.tip.hide();
        } else {
          // notify consumer
          _this.props.shouldClose(_this.tip);
        }
      });

      _defineProperty(_assertThisInitialized(_this), "handleEscKeyClick", function (event) {
        if (event.keyCode === _constants.KEY_CODES.ESCAPE_KEY && _this.tip.state.isVisible) {
          _this.hideOrNotify();
        }
      });

      _defineProperty(_assertThisInitialized(_this), "storeTippyInstance", function (tip) {
        _this.tip = tip;
      });

      _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
        _this.hideOrNotify();
      });

      _defineProperty(_assertThisInitialized(_this), "hideAllPopovers", function () {
        document.querySelectorAll('.tippy-popper').forEach(function (popper) {
          if (popper._tippy) {
            popper._tippy.hide();
          }
        });
      });

      _defineProperty(_assertThisInitialized(_this), "onHide", function (tip) {
        if (_this.state.isOpen) {
          _this.setState({
            isOpen: false
          });
        }

        return _this.props.onHide(tip);
      });

      _defineProperty(_assertThisInitialized(_this), "onHidden", function (tip) {
        return _this.props.onHidden(tip);
      });

      _defineProperty(_assertThisInitialized(_this), "onMount", function (tip) {
        return _this.props.onMount(tip);
      });

      _defineProperty(_assertThisInitialized(_this), "onShow", function (tip) {
        var _this$props = _this.props,
            hideOnOutsideClick = _this$props.hideOnOutsideClick,
            isVisible = _this$props.isVisible,
            onShow = _this$props.onShow; // hide all other open popovers first if events are managed by us

        if (!hideOnOutsideClick && isVisible === null) {
          _this.hideAllPopovers();
        }

        if (_this.state.isOpen === false) {
          _this.setState({
            isOpen: true
          });
        }

        return onShow(tip);
      });

      _defineProperty(_assertThisInitialized(_this), "onShown", function (tip) {
        return _this.props.onShown(tip);
      });

      _this.state = {
        isOpen: false
      };
      return _this;
    }

    _createClass(Popover, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        document.addEventListener('keydown', this.handleEscKeyClick, false);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        document.removeEventListener('keydown', this.handleEscKeyClick, false);
      }
    }, {
      key: "render",
      value: function render() {
        var _this2 = this;

        var _this$props2 = this.props,
            position = _this$props2.position,
            enableFlip = _this$props2.enableFlip,
            children = _this$props2.children,
            className = _this$props2.className,
            ariaLabel = _this$props2['aria-label'],
            headerContent = _this$props2.headerContent,
            bodyContent = _this$props2.bodyContent,
            footerContent = _this$props2.footerContent,
            isVisible = _this$props2.isVisible,
            shouldClose = _this$props2.shouldClose,
            appendTo = _this$props2.appendTo,
            hideOnOutsideClick = _this$props2.hideOnOutsideClick,
            onHide = _this$props2.onHide,
            onHidden = _this$props2.onHidden,
            onShow = _this$props2.onShow,
            onShown = _this$props2.onShown,
            onMount = _this$props2.onMount,
            zIndex = _this$props2.zIndex,
            maxWidth = _this$props2.maxWidth,
            closeBtnAriaLabel = _this$props2.closeBtnAriaLabel,
            rest = _objectWithoutProperties(_this$props2, ["position", "enableFlip", "children", "className", "aria-label", "headerContent", "bodyContent", "footerContent", "isVisible", "shouldClose", "appendTo", "hideOnOutsideClick", "onHide", "onHidden", "onShow", "onShown", "onMount", "zIndex", "maxWidth", "closeBtnAriaLabel"]);

        if (!headerContent && !ariaLabel) {
          return new Error('aria-label is required when header is not used');
        }

        var content = React.createElement(_GenerateId2["default"], null, function (randomId) {
          return _this2.state.isOpen && React.createElement(FocusTrap, {
            focusTrapOptions: {
              clickOutsideDeactivates: true
            }
          }, React.createElement("div", _extends({
            className: (0, _reactStyles.css)(_popoverCss2["default"].popover, !enableFlip && (0, _reactStyles.getModifier)(_popoverCss2["default"], position, _popoverCss2["default"].modifiers.top), className),
            role: "dialog",
            "aria-modal": "true",
            "aria-label": headerContent ? undefined : ariaLabel,
            "aria-labelledby": headerContent ? "popover-".concat(randomId, "-header") : undefined,
            "aria-describedby": "popover-".concat(randomId, "-body")
          }, rest), React.createElement(_PopoverArrow.PopoverArrow, null), React.createElement(_PopoverContent.PopoverContent, null, React.createElement(_PopoverCloseButton.PopoverCloseButton, {
            onClose: _this2.closePopover,
            "aria-label": closeBtnAriaLabel
          }), headerContent && React.createElement(_PopoverHeader.PopoverHeader, {
            id: "popover-".concat(randomId, "-header")
          }, headerContent), React.createElement(_PopoverBody.PopoverBody, {
            id: "popover-".concat(randomId, "-body")
          }, bodyContent), footerContent && React.createElement(_PopoverFooter.PopoverFooter, null, footerContent))));
        });
        var handleEvents = isVisible === null;

        var shouldHideOnClick = function shouldHideOnClick() {
          if (handleEvents) {
            if (hideOnOutsideClick === true) {
              return true;
            }

            return 'toggle';
          }

          return false;
        };

        return React.createElement(_react3["default"], {
          onCreate: this.storeTippyInstance,
          maxWidth: maxWidth,
          zIndex: zIndex,
          appendTo: appendTo,
          content: content,
          lazy: true,
          trigger: handleEvents ? 'click' : 'manual',
          isVisible: isVisible,
          hideOnClick: shouldHideOnClick(),
          animateFill: false,
          theme: "pf-tippy",
          performance: true,
          interactive: true,
          interactiveBorder: 0,
          placement: position,
          distance: 25,
          flip: enableFlip,
          popperOptions: {
            modifiers: {
              preventOverflow: {
                enabled: enableFlip
              },
              hide: {
                enabled: enableFlip
              }
            }
          },
          onHide: this.onHide,
          onHidden: this.onHidden,
          onShow: this.onShow,
          onShown: this.onShown,
          onMount: this.onMount
        }, children);
      }
    }]);

    return Popover;
  }(React.Component);

  _defineProperty(Popover, "propTypes", {
    position: _propTypes2["default"].oneOf(['top', 'bottom', 'left', 'right']),
    enableFlip: _propTypes2["default"].bool,
    className: _propTypes2["default"].string,
    children: _propTypes2["default"].element.isRequired,
    'aria-label': _propTypes2["default"].string,
    headerContent: _propTypes2["default"].node,
    bodyContent: _propTypes2["default"].node.isRequired,
    footerContent: _propTypes2["default"].node,
    isVisible: _propTypes2["default"].bool,
    shouldClose: _propTypes2["default"].func,
    appendTo: _propTypes2["default"].oneOfType([_propTypes2["default"].element, _propTypes2["default"].func]),
    hideOnOutsideClick: _propTypes2["default"].bool,
    onHide: _propTypes2["default"].func,
    onHidden: _propTypes2["default"].func,
    onShow: _propTypes2["default"].func,
    onShown: _propTypes2["default"].func,
    onMount: _propTypes2["default"].func,
    zIndex: _propTypes2["default"].number,
    maxWidth: _propTypes2["default"].string,
    closeBtnAriaLabel: _propTypes2["default"].string
  });

  _defineProperty(Popover, "defaultProps", {
    position: 'top',
    enableFlip: true,
    className: '',
    isVisible: null,
    shouldClose: function shouldClose() {
      return null;
    },
    'aria-label': '',
    headerContent: null,
    footerContent: null,
    appendTo: function appendTo() {
      return document.body;
    },
    hideOnOutsideClick: true,
    onHide: function onHide() {
      return null;
    },
    onHidden: function onHidden() {
      return null;
    },
    onShow: function onShow() {
      return null;
    },
    onShown: function onShown() {
      return null;
    },
    onMount: function onMount() {
      return null;
    },
    zIndex: 9999,
    maxWidth: _reactTokens.c_popover_MaxWidth && _reactTokens.c_popover_MaxWidth.value,
    closeBtnAriaLabel: 'Close'
  });
});