(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('react'), require('react-dom'), require('prop-types'), require('tippy.js')) :
  typeof define === 'function' && define.amd ? define(['react', 'react-dom', 'prop-types', 'tippy.js'], factory) :
  (global.Tippy = factory(global.React,global.ReactDOM,global.PropTypes,global.tippy));
}(this, (function (React,ReactDOM,PropTypes,tippy) { 'use strict';

  React = React && React.hasOwnProperty('default') ? React['default'] : React;
  ReactDOM = ReactDOM && ReactDOM.hasOwnProperty('default') ? ReactDOM['default'] : ReactDOM;
  PropTypes = PropTypes && PropTypes.hasOwnProperty('default') ? PropTypes['default'] : PropTypes;
  tippy = tippy && tippy.hasOwnProperty('default') ? tippy['default'] : tippy;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ("value" in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        writable: true,
        configurable: true
      }
    });
    if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };
    return _getPrototypeOf(o);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;
      return o;
    };

    return _setPrototypeOf(o, p);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return self;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (typeof call === "object" || typeof call === "function")) {
      return call;
    }

    return _assertThisInitialized(self);
  }

  var REACT_ONLY_PROPS = ['children', 'onCreate', 'isVisible', 'isEnabled']; // Avoid Babel's large '_objectWithoutProperties' helper function.

  function getNativeTippyProps(props) {
    return Object.keys(props).reduce(function (acc, key) {
      if (REACT_ONLY_PROPS.indexOf(key) === -1) {
        acc[key] = props[key];
      }

      return acc;
    }, {});
  }

  var Tippy =
  /*#__PURE__*/
  function (_React$Component) {
    _inherits(Tippy, _React$Component);

    function Tippy() {
      var _getPrototypeOf2;

      var _this;

      _classCallCheck(this, Tippy);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(Tippy)).call.apply(_getPrototypeOf2, [this].concat(args)));
      _this.state = {
        isMounted: false
      };
      _this.container = typeof document !== 'undefined' && document.createElement('div');
      return _this;
    }

    _createClass(Tippy, [{
      key: "componentDidMount",
      value: function componentDidMount() {
        this.setState({
          isMounted: true
        });
        this.tip = tippy.one(ReactDOM.findDOMNode(this), this.options);
        var _this$props = this.props,
            onCreate = _this$props.onCreate,
            isEnabled = _this$props.isEnabled,
            isVisible = _this$props.isVisible;

        if (onCreate) {
          onCreate(this.tip);
        }

        if (isEnabled === false) {
          this.tip.disable();
        }

        if (this.isManualTrigger && isVisible === true) {
          this.tip.show();
        }
      }
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate() {
        this.tip.set(this.options);
        var _this$props2 = this.props,
            isEnabled = _this$props2.isEnabled,
            isVisible = _this$props2.isVisible;

        if (isEnabled === true) {
          this.tip.enable();
        }

        if (isEnabled === false) {
          this.tip.disable();
        }

        if (this.isManualTrigger) {
          if (isVisible === true) {
            this.tip.show();
          }

          if (isVisible === false) {
            this.tip.hide();
          }
        }
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.tip.destroy();
        this.tip = null;
      }
    }, {
      key: "render",
      value: function render() {
        return React.createElement(React.Fragment, null, this.props.children, this.isReactElementContent && this.state.isMounted && ReactDOM.createPortal(this.props.content, this.container));
      }
    }, {
      key: "isReactElementContent",
      get: function get() {
        return React.isValidElement(this.props.content);
      }
    }, {
      key: "options",
      get: function get() {
        return _extends({}, getNativeTippyProps(this.props), {
          content: this.isReactElementContent ? this.container : this.props.content
        });
      }
    }, {
      key: "isManualTrigger",
      get: function get() {
        return this.props.trigger === 'manual';
      }
    }]);

    return Tippy;
  }(React.Component);

  Tippy.propTypes = {
    content: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
    children: PropTypes.element.isRequired,
    onCreate: PropTypes.func,
    isVisible: PropTypes.bool,
    isEnabled: PropTypes.bool
  };

  return Tippy;

})));
//# sourceMappingURL=Tippy.js.map
