"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyStateIcon = exports.IconSize = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactStyles = require("@patternfly/react-styles");

var _emptyState = _interopRequireDefault(require("@patternfly/react-styles/css/components/EmptyState/empty-state"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; if (obj != null) { var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var IconSize;
exports.IconSize = IconSize;

(function (IconSize) {
  IconSize["sm"] = "sm";
  IconSize["md"] = "md";
  IconSize["lg"] = "lg";
  IconSize["xl"] = "xl";
})(IconSize || (exports.IconSize = IconSize = {}));

var EmptyStateIcon = function EmptyStateIcon(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$icon = _ref.icon,
      IconComponent = _ref$icon === void 0 ? null : _ref$icon,
      _ref$component = _ref.component,
      AnyComponent = _ref$component === void 0 ? null : _ref$component,
      _ref$variant = _ref.variant,
      variant = _ref$variant === void 0 ? 'icon' : _ref$variant,
      props = _objectWithoutProperties(_ref, ["className", "icon", "component", "variant"]);

  var classNames = (0, _reactStyles.css)(_emptyState["default"].emptyStateIcon, className);
  return variant === 'icon' ? React.createElement(IconComponent, _extends({
    className: classNames
  }, props, {
    "aria-hidden": "true"
  })) : React.createElement("div", {
    className: classNames
  }, React.createElement(AnyComponent, null));
};

exports.EmptyStateIcon = EmptyStateIcon;
EmptyStateIcon.propTypes = {
  color: _propTypes["default"].string,
  size: _propTypes["default"].oneOf(['sm', 'md', 'lg', 'xl']),
  title: _propTypes["default"].string,
  className: _propTypes["default"].string,
  icon: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].any]),
  component: _propTypes["default"].any,
  variant: _propTypes["default"].oneOf(['icon', 'container'])
};
//# sourceMappingURL=EmptyStateIcon.js.map