import { Plugin } from 'rollup';
export declare type EnvVarReplacements = Record<string, string | number | true>;
export interface SnowpackConfig {
    source: 'local' | 'pika';
    webDependencies?: {
        [packageName: string]: string;
    };
    entrypoints?: string[];
    dedupe?: string[];
    namedExports?: {
        [filepath: string]: string[];
    };
    installOptions: {
        babel?: boolean;
        clean: boolean;
        hash: boolean;
        dest: string;
        exclude: string[];
        externalPackage: string[];
        include?: string;
        nomodule?: string;
        nomoduleOutput: string;
        optimize: boolean;
        env?: EnvVarReplacements;
        remotePackage?: string[];
        remoteUrl: string;
        sourceMap?: boolean | 'inline';
        stat: boolean;
        strict: boolean;
    };
    rollup: {
        plugins: Plugin[];
    };
}
export interface CLIFlags extends Omit<Partial<SnowpackConfig['installOptions']>, 'env'> {
    help?: boolean;
    version?: boolean;
    reload?: boolean;
    source?: SnowpackConfig['source'];
    config?: string;
    env?: string[];
}
export default function loadConfig(flags: CLIFlags, pkgManifest: any): {
    config: SnowpackConfig;
    errors: string[];
};
