import _pt from "prop-types";

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import * as React from 'react';
import { Form, FormGroup, ActionGroup, FormHelperText } from '../Form';
import { TextInput } from '../TextInput';
import { Button } from '../Button';
import { Checkbox } from '../Checkbox';
export var LoginForm = function LoginForm(_ref) {
  var _ref$className = _ref.className,
      className = _ref$className === void 0 ? '' : _ref$className,
      _ref$showHelperText = _ref.showHelperText,
      showHelperText = _ref$showHelperText === void 0 ? false : _ref$showHelperText,
      _ref$helperText = _ref.helperText,
      helperText = _ref$helperText === void 0 ? null : _ref$helperText,
      _ref$usernameLabel = _ref.usernameLabel,
      usernameLabel = _ref$usernameLabel === void 0 ? 'Username' : _ref$usernameLabel,
      _ref$usernameValue = _ref.usernameValue,
      usernameValue = _ref$usernameValue === void 0 ? '' : _ref$usernameValue,
      _ref$onChangeUsername = _ref.onChangeUsername,
      onChangeUsername = _ref$onChangeUsername === void 0 ? function () {
    return undefined;
  } : _ref$onChangeUsername,
      _ref$isValidUsername = _ref.isValidUsername,
      isValidUsername = _ref$isValidUsername === void 0 ? true : _ref$isValidUsername,
      _ref$passwordLabel = _ref.passwordLabel,
      passwordLabel = _ref$passwordLabel === void 0 ? 'Password' : _ref$passwordLabel,
      _ref$passwordValue = _ref.passwordValue,
      passwordValue = _ref$passwordValue === void 0 ? '' : _ref$passwordValue,
      _ref$onChangePassword = _ref.onChangePassword,
      onChangePassword = _ref$onChangePassword === void 0 ? function () {
    return undefined;
  } : _ref$onChangePassword,
      _ref$isValidPassword = _ref.isValidPassword,
      isValidPassword = _ref$isValidPassword === void 0 ? true : _ref$isValidPassword,
      _ref$loginButtonLabel = _ref.loginButtonLabel,
      loginButtonLabel = _ref$loginButtonLabel === void 0 ? 'Log In' : _ref$loginButtonLabel,
      _ref$isLoginButtonDis = _ref.isLoginButtonDisabled,
      isLoginButtonDisabled = _ref$isLoginButtonDis === void 0 ? false : _ref$isLoginButtonDis,
      _ref$onLoginButtonCli = _ref.onLoginButtonClick,
      onLoginButtonClick = _ref$onLoginButtonCli === void 0 ? function () {
    return undefined;
  } : _ref$onLoginButtonCli,
      _ref$rememberMeLabel = _ref.rememberMeLabel,
      rememberMeLabel = _ref$rememberMeLabel === void 0 ? '' : _ref$rememberMeLabel,
      _ref$isRememberMeChec = _ref.isRememberMeChecked,
      isRememberMeChecked = _ref$isRememberMeChec === void 0 ? false : _ref$isRememberMeChec,
      _ref$onChangeRemember = _ref.onChangeRememberMe,
      onChangeRememberMe = _ref$onChangeRemember === void 0 ? function () {
    return undefined;
  } : _ref$onChangeRemember,
      _ref$rememberMeAriaLa = _ref.rememberMeAriaLabel,
      rememberMeAriaLabel = _ref$rememberMeAriaLa === void 0 ? '' : _ref$rememberMeAriaLa,
      props = _objectWithoutProperties(_ref, ["className", "showHelperText", "helperText", "usernameLabel", "usernameValue", "onChangeUsername", "isValidUsername", "passwordLabel", "passwordValue", "onChangePassword", "isValidPassword", "loginButtonLabel", "isLoginButtonDisabled", "onLoginButtonClick", "rememberMeLabel", "isRememberMeChecked", "onChangeRememberMe", "rememberMeAriaLabel"]);

  return React.createElement(Form, _extends({
    className: className
  }, props), React.createElement(FormHelperText, {
    isError: !isValidUsername || !isValidPassword,
    isHidden: !showHelperText
  }, helperText), React.createElement(FormGroup, {
    label: usernameLabel,
    isRequired: true,
    isValid: isValidUsername,
    fieldId: "pf-login-username-id"
  }, React.createElement(TextInput, {
    id: "pf-login-username-id",
    isRequired: true,
    isValid: isValidUsername,
    type: "text",
    name: "pf-login-username-id",
    value: usernameValue,
    onChange: onChangeUsername
  })), React.createElement(FormGroup, {
    label: passwordLabel,
    isRequired: true,
    isValid: isValidPassword,
    fieldId: "pf-login-password-id"
  }, React.createElement(TextInput, {
    isRequired: true,
    type: "password",
    id: "pf-login-password-id",
    name: "pf-login-password-id",
    isValid: isValidPassword,
    value: passwordValue,
    onChange: onChangePassword
  })), rememberMeLabel.length > 0 && React.createElement(FormGroup, {
    fieldId: "pf-login-remember-me-id"
  }, React.createElement(Checkbox, {
    id: "pf-login-remember-me-id",
    label: rememberMeLabel,
    checked: isRememberMeChecked,
    onChange: onChangeRememberMe,
    "aria-label": rememberMeAriaLabel || rememberMeLabel
  })), React.createElement(ActionGroup, null, React.createElement(Button, {
    variant: "primary",
    type: "submit",
    onClick: onLoginButtonClick,
    isBlock: true,
    isDisabled: isLoginButtonDisabled
  }, loginButtonLabel)));
};
LoginForm.propTypes = {
  className: _pt.string,
  showHelperText: _pt.bool,
  helperText: _pt.node,
  usernameLabel: _pt.string,
  usernameValue: _pt.string,
  onChangeUsername: _pt.func,
  isValidUsername: _pt.bool,
  passwordLabel: _pt.string,
  passwordValue: _pt.string,
  onChangePassword: _pt.func,
  isValidPassword: _pt.bool,
  loginButtonLabel: _pt.string,
  isLoginButtonDisabled: _pt.bool,
  onLoginButtonClick: _pt.func,
  rememberMeLabel: _pt.string,
  isRememberMeChecked: _pt.bool,
  onChangeRememberMe: _pt.func,
  rememberMeAriaLabel: _pt.string
};