"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _dropdownCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/Dropdown/dropdown.css.js"));

var _reactStyles = require("@patternfly/react-styles");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var propTypes = {
  /** Checkboxes within group */
  children: _propTypes["default"].node,

  /** Additional classes added to the DropdownGroup control */
  className: _propTypes["default"].string,

  /** Group label */
  label: _propTypes["default"].string,

  /** Additional props are spread to the container <div> */
  '': _propTypes["default"].any // eslint-disable-line react/require-default-props

};
var defaultProps = {
  children: null,
  className: '',
  label: ''
};

var DropdownGroup = function DropdownGroup(_ref) {
  var children = _ref.children,
      className = _ref.className,
      label = _ref.label,
      props = _objectWithoutProperties(_ref, ["children", "className", "label"]);

  return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("section", _extends({}, props, {
    className: (0, _reactStyles.css)(_dropdownCss["default"].dropdownGroup, className)
  }), label && _react["default"].createElement("h1", {
    className: (0, _reactStyles.css)(_dropdownCss["default"].dropdownGroupTitle),
    "aria-hidden": true
  }, label), _react["default"].createElement("ul", null, children)));
};

DropdownGroup.propTypes = propTypes;
DropdownGroup.defaultProps = defaultProps;
var _default = DropdownGroup;
exports["default"] = _default;