"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsMenuToggle = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var React = _interopRequireWildcard(require("react"));

var _reactIcons = require("@patternfly/react-icons");

var _optionsMenuCss = _interopRequireDefault(require("../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js"));

var _reactStyles = require("@patternfly/react-styles");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var OptionsMenuToggle = function OptionsMenuToggle(_ref) {
  var _ref$parentId = _ref.parentId,
      parentId = _ref$parentId === void 0 ? '' : _ref$parentId,
      _ref$onToggle = _ref.onToggle,
      onToggle = _ref$onToggle === void 0 ? function () {
    return null;
  } : _ref$onToggle,
      _ref$isOpen = _ref.isOpen,
      isOpen = _ref$isOpen === void 0 ? false : _ref$isOpen,
      _ref$isPlain = _ref.isPlain,
      isPlain = _ref$isPlain === void 0 ? false : _ref$isPlain,
      _ref$isHovered = _ref.isHovered,
      isHovered = _ref$isHovered === void 0 ? false : _ref$isHovered,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$isFocused = _ref.isFocused,
      isFocused = _ref$isFocused === void 0 ? false : _ref$isFocused,
      _ref$toggleTemplate = _ref.toggleTemplate,
      toggleTemplate = _ref$toggleTemplate === void 0 ? React.createElement(React.Fragment, null) : _ref$toggleTemplate,
      _ref$hideCaret = _ref.hideCaret,
      hideCaret = _ref$hideCaret === void 0 ? false : _ref$hideCaret,
      _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? 'Options menu' : _ref$ariaLabel;
  return React.createElement("button", {
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuToggle, isPlain && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'plain'), isHovered && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'hover'), isActive && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'active'), isFocused && (0, _reactStyles.getModifier)(_optionsMenuCss["default"], 'focus')),
    id: "".concat(parentId, "-toggle"),
    "aria-haspopup": "listbox",
    "aria-label": ariaLabel,
    "aria-expanded": isOpen,
    onClick: onToggle
  }, toggleTemplate && (!isPlain ? React.createElement("span", {
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuToggleText)
  }, toggleTemplate) : React.createElement(React.Fragment, null, toggleTemplate)), !hideCaret && React.createElement(_reactIcons.CaretDownIcon, {
    "aria-hidden": true,
    className: (0, _reactStyles.css)(_optionsMenuCss["default"].optionsMenuToggleIcon)
  }));
};

exports.OptionsMenuToggle = OptionsMenuToggle;
OptionsMenuToggle.propTypes = {
  parentId: _propTypes["default"].string,
  onToggle: _propTypes["default"].func,
  isOpen: _propTypes["default"].bool,
  isPlain: _propTypes["default"].bool,
  isFocused: _propTypes["default"].bool,
  isHovered: _propTypes["default"].bool,
  isActive: _propTypes["default"].bool,
  hideCaret: _propTypes["default"].bool,
  'aria-label': _propTypes["default"].string,
  toggleTemplate: _propTypes["default"].element
};