"use strict";

(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define(["exports", "prop-types", "react", "@patternfly/react-styles", "../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js", "@patternfly/react-icons", "../../helpers"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("prop-types"), require("react"), require("@patternfly/react-styles"), require("../../@patternfly/patternfly/components/OptionsMenu/options-menu.css.js"), require("@patternfly/react-icons"), require("../../helpers"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.propTypes, global.react, global.reactStyles, global.optionsMenuCss, global.reactIcons, global.helpers);
    global.undefined = mod.exports;
  }
})(void 0, function (exports, _propTypes, _react, _reactStyles, _optionsMenuCss, _reactIcons, _helpers) {
  "use strict";

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.OptionsMenuItem = undefined;

  var _propTypes2 = _interopRequireDefault(_propTypes);

  var React = _interopRequireWildcard(_react);

  var _optionsMenuCss2 = _interopRequireDefault(_optionsMenuCss);

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};

      if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};

            if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }

      newObj.default = obj;
      return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      default: obj
    };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  var OptionsMenuItem = exports.OptionsMenuItem = function OptionsMenuItem(_ref) {
    var _ref$children = _ref.children,
        children = _ref$children === void 0 ? null : _ref$children,
        _ref$className = _ref.className,
        className = _ref$className === void 0 ? '' : _ref$className,
        _ref$isSelected = _ref.isSelected,
        isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
        _ref$isDisabled = _ref.isDisabled,
        isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
        _ref$onSelect = _ref.onSelect,
        onSelect = _ref$onSelect === void 0 ? function () {
      return null;
    } : _ref$onSelect,
        _ref$id = _ref.id,
        id = _ref$id === void 0 ? '' : _ref$id,
        props = _objectWithoutProperties(_ref, ["children", "className", "isSelected", "isDisabled", "onSelect", "id"]);

    var onKeyDown = function onKeyDown(event) {
      // Detected key press on this item, notify the menu parent so that the appropriate
      // item can be focused
      if (event.keyCode === _helpers.KEY_CODES.TAB) {
        return;
      }

      event.preventDefault();

      if (event.keyCode === _helpers.KEY_CODES.ENTER) {
        onSelect(event);
      }
    };

    return React.createElement("li", null, React.createElement("button", _extends({
      className: (0, _reactStyles.css)(_optionsMenuCss2["default"].optionsMenuMenuItem, isDisabled && (0, _reactStyles.getModifier)(_optionsMenuCss2["default"], 'disabled'), className),
      "aria-disabled": isDisabled,
      onClick: onSelect,
      onKeyDown: onKeyDown,
      "aria-selected": isSelected,
      id: id
    }, props), children, React.createElement("i", {
      className: (0, _reactStyles.css)(_optionsMenuCss2["default"].optionsMenuMenuItemIcon),
      "aria-hidden": true,
      hidden: !isSelected
    }, React.createElement(_reactIcons.CheckIcon, null))));
  };

  OptionsMenuItem.propTypes = {
    children: _propTypes2["default"].node,
    className: _propTypes2["default"].string,
    isSelected: _propTypes2["default"].bool,
    isDisabled: _propTypes2["default"].bool,
    onSelect: _propTypes2["default"].func,
    id: _propTypes2["default"].string
  };
});