/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.DefaultApplicationModel;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class ApplicationModelBuilder {
    public static final String PARENT_FIRST_ARTIFACTS = "parent-first-artifacts";
    public static final String RUNNER_PARENT_FIRST_ARTIFACTS = "runner-parent-first-artifacts";
    public static final String EXCLUDED_ARTIFACTS = "excluded-artifacts";
    public static final String LESSER_PRIORITY_ARTIFACTS = "lesser-priority-artifacts";
    private static final Logger log = Logger.getLogger(ApplicationModelBuilder.class);
    ResolvedDependency appArtifact;
    final Map<ArtifactKey, ResolvedDependency> dependencies = new LinkedHashMap<ArtifactKey, ResolvedDependency>();
    final Set<ArtifactKey> parentFirstArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> runnerParentFirstArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> excludedArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> lesserPriorityArtifacts = new HashSet<ArtifactKey>();
    final Set<ArtifactKey> reloadableWorkspaceModules = new HashSet<ArtifactKey>();
    final List<ExtensionCapabilities> extensionCapabilities = new ArrayList<ExtensionCapabilities>();
    PlatformImports platformImports;
    final Map<WorkspaceModuleId, WorkspaceModule.Mutable> projectModules = new HashMap<WorkspaceModuleId, WorkspaceModule.Mutable>();
    private Predicate<ResolvedDependency> depPredicate;

    public ApplicationModelBuilder setAppArtifact(ResolvedDependency appArtifact) {
        this.appArtifact = appArtifact;
        return this;
    }

    public ApplicationModelBuilder setPlatformImports(PlatformImports platformImports) {
        this.platformImports = platformImports;
        return this;
    }

    public ApplicationModelBuilder addExtensionCapabilities(ExtensionCapabilities extensionCapabilities) {
        this.extensionCapabilities.add(extensionCapabilities);
        return this;
    }

    public ApplicationModelBuilder addDependency(ResolvedDependency dep) {
        this.dependencies.put(dep.getKey(), dep);
        return this;
    }

    public ApplicationModelBuilder addDependencies(Collection<ResolvedDependency> deps) {
        deps.forEach(d -> this.addDependency((ResolvedDependency)d));
        return this;
    }

    public Dependency getDependency(ArtifactKey key) {
        return this.dependencies.get(key);
    }

    public ApplicationModelBuilder addParentFirstArtifact(ArtifactKey deps) {
        this.parentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addParentFirstArtifacts(List<ArtifactKey> deps) {
        this.parentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifact(ArtifactKey deps) {
        this.runnerParentFirstArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addRunnerParentFirstArtifacts(List<ArtifactKey> deps) {
        this.runnerParentFirstArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifact(ArtifactKey deps) {
        this.excludedArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addExcludedArtifacts(List<ArtifactKey> deps) {
        this.excludedArtifacts.addAll(deps);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifact(ArtifactKey deps) {
        this.lesserPriorityArtifacts.add(deps);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModule(ArtifactKey key) {
        this.reloadableWorkspaceModules.add(key);
        return this;
    }

    public ApplicationModelBuilder addReloadableWorkspaceModules(Collection<ArtifactKey> key) {
        this.reloadableWorkspaceModules.addAll(key);
        return this;
    }

    public ApplicationModelBuilder addLesserPriorityArtifacts(List<ArtifactKey> deps) {
        this.lesserPriorityArtifacts.addAll(deps);
        return this;
    }

    public WorkspaceModule.Mutable getOrCreateProjectModule(WorkspaceModuleId id, File moduleDir, File buildDir) {
        return this.projectModules.computeIfAbsent(id, k -> WorkspaceModule.builder().setModuleId(id).setModuleDir(moduleDir.toPath()).setBuildDir(buildDir.toPath()));
    }

    public void handleExtensionProperties(Properties props, String extension) {
        String lesserPriority;
        String excluded;
        String runnerParentFirst;
        String parentFirst = props.getProperty(PARENT_FIRST_ARTIFACTS);
        if (parentFirst != null) {
            String[] artifacts;
            for (String artifact : artifacts = parentFirst.split(",")) {
                this.parentFirstArtifacts.add(new GACT(artifact.split(":")));
            }
        }
        if ((runnerParentFirst = props.getProperty(RUNNER_PARENT_FIRST_ARTIFACTS)) != null) {
            String[] artifacts;
            for (String artifact : artifacts = runnerParentFirst.split(",")) {
                this.runnerParentFirstArtifacts.add(new GACT(artifact.split(":")));
            }
        }
        if ((excluded = props.getProperty(EXCLUDED_ARTIFACTS)) != null) {
            String[] artifacts;
            for (String artifact : artifacts = excluded.split(",")) {
                this.excludedArtifacts.add(new GACT(artifact.split(":")));
                log.debugf("Extension %s is excluding %s", (Object)extension, (Object)artifact);
            }
        }
        if ((lesserPriority = props.getProperty(LESSER_PRIORITY_ARTIFACTS)) != null) {
            String[] artifacts;
            for (String artifact : artifacts = lesserPriority.split(",")) {
                this.lesserPriorityArtifacts.add(new GACT(artifact.split(":")));
                log.debugf("Extension %s is making %s a lesser priority artifact", (Object)extension, (Object)artifact);
            }
        }
    }

    private Predicate<ResolvedDependency> dependencyPredicate() {
        if (this.depPredicate == null) {
            this.depPredicate = s -> {
                if (s.getGroupId().equals("io.quarkus") && s.getArtifactId().equals("quarkus-ide-launcher")) {
                    return false;
                }
                return !this.excludedArtifacts.contains(s.getKey());
            };
        }
        return this.depPredicate;
    }

    List<ResolvedDependency> filter(Collection<ResolvedDependency> deps) {
        return deps.stream().filter(this.dependencyPredicate()).collect(Collectors.toList());
    }

    public DefaultApplicationModel build() {
        return new DefaultApplicationModel(this);
    }
}

