/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.GizmoClassVisitor;
import java.util.IdentityHashMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;

public final class GizmoMethodVisitor
extends MethodVisitor {
    private final GizmoClassVisitor cv;
    private final IdentityHashMap<Label, String> labelNames = new IdentityHashMap();
    int labelCnt = 1;

    public GizmoMethodVisitor(int api, MethodVisitor delegate, GizmoClassVisitor cv) {
        super(api, delegate);
        this.cv = cv;
    }

    public boolean nameLabel(Label label, String name) {
        return this.labelNames.putIfAbsent(label, name) == null;
    }

    String getNameOf(Label label) {
        String str = this.labelNames.get(label);
        if (str == null) {
            str = "label" + this.labelCnt++;
            this.labelNames.put(label, str);
        }
        return str;
    }

    public void visitGizmoNode(StackTraceElement element, String opName) {
        this.checkMethod();
        this.cv.append("// ").append(opName).newLine();
        if (element != null) {
            this.cv.append("// at ").append(element.toString()).newLine();
        }
    }

    public void visitInsn(int opcode) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(operand).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int varNum) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(varNum).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitVarInsn(opcode, varNum);
    }

    public void visitTypeInsn(int opcode, String type) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(type).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.checkMethod();
        this.cv.append("// Field descriptor: ").append(descriptor).newLine();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(owner).append('#').append(name).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor) {
        this.checkMethod();
        this.cv.append("// Method descriptor: ").append(descriptor).newLine();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(owner).append('#').append(name).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitMethodInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.checkMethod();
        this.cv.append("// Method descriptor: ").append(descriptor).newLine();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(owner).append('#').append(name).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitJumpInsn(int opcode, Label target) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(opcode)).append(' ').append(this.getNameOf(target)).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitJumpInsn(opcode, target);
    }

    public void visitLabel(Label label) {
        this.cv.append("** ").append(this.getNameOf(label)).newLine();
        super.visitLabel(label);
    }

    public void visitLdcInsn(Object value) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(18)).append(" (").append(value.getClass().getSimpleName()).append(") ");
        if (value instanceof String) {
            this.cv.append('\"').append(value).append('\"');
        } else {
            this.cv.append(value);
        }
        this.cv.newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitLdcInsn(value);
    }

    public void visitIincInsn(int var, int increment) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(132)).append(' ').append(var).append(' ').append(increment > 0 ? (char)'+' : '-').append(increment).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(170)).newLine();
        for (int i = 0; i < max - min; ++i) {
            this.cv.append("  [").append(min + i).append("]: goto ").append(this.getNameOf(labels[i])).newLine();
        }
        this.cv.append("  default: goto ").append(this.getNameOf(dflt)).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.checkMethod();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(170)).newLine();
        for (int i = 0; i < labels.length; ++i) {
            this.cv.append("  [").append(keys[i]).append("]: goto ").append(this.getNameOf(labels[i])).newLine();
        }
        this.cv.append("  default: goto ").append(this.getNameOf(dflt)).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.checkMethod();
        this.cv.append("// Array descriptor: ").append(descriptor).newLine();
        int lineNumber = this.cv.getLineNumber();
        this.cv.append(GizmoMethodVisitor.getOpString(197)).append(' ').append(numDimensions).newLine();
        Label label = new Label();
        super.visitLabel(label);
        super.visitLineNumber(lineNumber, label);
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.checkMethod();
        this.cv.append("// Try from ").append(this.getNameOf(start)).append(" to ").append(this.getNameOf(end)).newLine();
        this.cv.append("// Catch ").append(type).append(" by going to ").append(this.getNameOf(handler)).newLine();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitEnd() {
        this.cv.methodVisitEnd();
        super.visitEnd();
    }

    void checkMethod() {
        if (this.cv.getCurrentMethod() != this) {
            throw new IllegalStateException("Wrong method is active");
        }
    }

    private static String getOpString(int opcode) {
        return Printer.OPCODES[opcode];
    }
}

