/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class HardcodedLDAPGroupStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(HardcodedLDAPGroupStorageMapper.class);
    public static final String GROUP = "group";

    public HardcodedLDAPGroupStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, final RealmModel realm) {
        return new UserModelDelegate(delegate){

            public Stream<GroupModel> getGroupsStream() {
                Stream groups = super.getGroupsStream();
                GroupModel group = HardcodedLDAPGroupStorageMapper.this.getGroup(realm);
                if (group != null) {
                    return Stream.concat(groups, Stream.of(group));
                }
                return groups;
            }

            public boolean isMemberOf(GroupModel group) {
                return super.isMemberOf(group) || group.equals(HardcodedLDAPGroupStorageMapper.this.getGroup(realm));
            }

            public void leaveGroup(GroupModel group) {
                if (group.equals(HardcodedLDAPGroupStorageMapper.this.getGroup(realm))) {
                    throw new ModelException("Not possible to delete group. It's hardcoded by LDAP mapper");
                }
                super.leaveGroup(group);
            }
        };
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
    }

    private GroupModel getGroup(RealmModel realm) {
        String groupName = (String)this.mapperModel.getConfig().getFirst((Object)GROUP);
        GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)groupName);
        if (group == null) {
            logger.warnf("Hardcoded group '%s' configured in mapper '%s' is not available anymore", new Object[0]);
        }
        return group;
    }
}

