/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;

public class NativeImageBuildLocalRunner
extends NativeImageBuildRunner {
    private final String nativeImageExecutable;
    private final File workingDirectory;

    public NativeImageBuildLocalRunner(String nativeImageExecutable, File workingDirectory) {
        this.nativeImageExecutable = nativeImageExecutable;
        this.workingDirectory = workingDirectory;
    }

    @Override
    protected String[] getGraalVMVersionCommand(List<String> args) {
        return this.buildCommand(args);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        return this.buildCommand(args);
    }

    @Override
    protected void objcopy(String ... args) {
        String[] command = new String[args.length + 1];
        command[0] = "objcopy";
        System.arraycopy(args, 0, command, 1, args.length);
        NativeImageBuildLocalRunner.runCommand(command, null, this.workingDirectory);
    }

    @Override
    protected boolean objcopyExists() {
        if (!SystemUtils.IS_OS_LINUX) {
            return false;
        }
        String systemPath = System.getenv("PATH");
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file = new File(dir, "objcopy")).exists()) continue;
                return true;
            }
        }
        return false;
    }

    private String[] buildCommand(List<String> args) {
        return (String[])Stream.concat(Stream.of(this.nativeImageExecutable), args.stream()).toArray(String[]::new);
    }
}

