/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;
import org.keycloak.models.utils.KeycloakModelUtils;

public class SessionInitializerWorker
implements Function<EmbeddedCacheManager, SessionLoader.WorkerResult>,
Serializable {
    private static final Logger log = Logger.getLogger(SessionInitializerWorker.class);
    private SessionLoader.LoaderContext loaderCtx;
    private SessionLoader.WorkerContext workerCtx;
    private SessionLoader sessionLoader;
    private String cacheName;

    public void setWorkerEnvironment(SessionLoader.LoaderContext loaderCtx, SessionLoader.WorkerContext workerCtx, SessionLoader sessionLoader, String cacheName) {
        this.loaderCtx = loaderCtx;
        this.workerCtx = workerCtx;
        this.sessionLoader = sessionLoader;
        this.cacheName = cacheName;
    }

    @Override
    public SessionLoader.WorkerResult apply(EmbeddedCacheManager embeddedCacheManager) {
        KeycloakSessionFactory sessionFactory;
        Cache workCache = embeddedCacheManager.getCache(this.cacheName);
        if (log.isTraceEnabled()) {
            log.tracef("Running computation for segment %s with worker %s", this.workerCtx.getSegment(), this.workerCtx.getWorkerId());
        }
        if ((sessionFactory = (KeycloakSessionFactory)workCache.getAdvancedCache().getComponentRegistry().getComponent(KeycloakSessionFactory.class)) == null) {
            log.debugf("KeycloakSessionFactory not yet set in cache. Worker skipped", new Object[0]);
            return this.sessionLoader.createFailedWorkerResult(this.loaderCtx, this.workerCtx);
        }
        final SessionLoader.WorkerResult[] ref = new SessionLoader.WorkerResult[1];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                ref[0] = SessionInitializerWorker.this.sessionLoader.loadSessions(session, SessionInitializerWorker.this.loaderCtx, SessionInitializerWorker.this.workerCtx);
            }
        });
        return ref[0];
    }
}

