/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.awaitility.core;

class ConditionEvaluationResult {
    private final Throwable trace;
    private final Throwable throwable;
    private final boolean successful;

    ConditionEvaluationResult(boolean successful) {
        this(successful, null, null);
    }

    ConditionEvaluationResult(boolean successful, Throwable throwable, Throwable trace) {
        this.successful = successful;
        this.throwable = throwable;
        this.trace = trace;
    }

    boolean isSuccessful() {
        return this.successful;
    }

    boolean isError() {
        return !this.isSuccessful();
    }

    Throwable getThrowable() {
        return this.throwable;
    }

    Throwable getTrace() {
        return this.trace;
    }

    boolean hasThrowable() {
        return this.throwable != null;
    }

    boolean hasTrace() {
        return this.trace != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConditionEvaluationResult)) {
            return false;
        }
        ConditionEvaluationResult result = (ConditionEvaluationResult)o;
        if (this.successful != result.successful) {
            return false;
        }
        return this.throwable != null ? this.throwable.equals(result.throwable) : result.throwable == null;
    }

    public int hashCode() {
        int result = this.throwable != null ? this.throwable.hashCode() : 0;
        result = 31 * result + (this.successful ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ConditionEvaluationResult{trace=" + this.trace + ", throwable=" + this.throwable + ", successful=" + this.successful + '}';
    }
}

