/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.converters;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.util.Map;
import java.util.function.Function;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.parameters.converters.LoadedParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;

public class GeneratedConverterIndexerExtension
implements ServerEndpointIndexer.ConverterSupplierIndexerExtension {
    final Function<String, ClassOutput> classOutput;

    public GeneratedConverterIndexerExtension(Function<String, ClassOutput> classOutput) {
        this.classOutput = classOutput;
    }

    @Override
    public ParameterConverterSupplier extractConverterImpl(String elementType, IndexView indexView, Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters) {
        LoadedParameterConverter delegate;
        String baseName;
        MethodDescriptor fromString = null;
        MethodDescriptor valueOf = null;
        MethodInfo stringCtor = null;
        String primitiveWrapperType = (String)EndpointIndexer.primitiveTypes.get(elementType);
        String prefix = "";
        if (primitiveWrapperType != null) {
            valueOf = MethodDescriptor.ofMethod((Object)primitiveWrapperType, (String)"valueOf", (Object)primitiveWrapperType, (Object[])new Object[]{String.class});
            prefix = "io.quarkus.generated.";
        } else {
            ClassInfo type = indexView.getClassByName(DotName.createSimple((String)elementType));
            if (type != null) {
                for (MethodInfo i : type.methods()) {
                    boolean isNotPrivate;
                    boolean isStatic = (i.flags() & 8) != 0;
                    boolean bl = isNotPrivate = (i.flags() & 2) == 0;
                    if (i.parameters().size() != 1 || !isNotPrivate || !((Type)i.parameters().get(0)).name().equals((Object)ResteasyReactiveDotNames.STRING)) continue;
                    if (i.name().equals("<init>")) {
                        stringCtor = i;
                        continue;
                    }
                    if (i.name().equals("valueOf") && isStatic) {
                        valueOf = MethodDescriptor.of((MethodInfo)i);
                        continue;
                    }
                    if (!i.name().equals("fromString") || !isStatic) continue;
                    fromString = MethodDescriptor.of((MethodInfo)i);
                }
                if (type.isEnum() && fromString != null) {
                    valueOf = null;
                }
            }
        }
        if (stringCtor != null || valueOf != null || fromString != null) {
            Object effectivePrefix = prefix + elementType;
            if (((String)effectivePrefix).startsWith("java")) {
                effectivePrefix = ((String)effectivePrefix).replace("java", "javaq");
            }
            baseName = (String)effectivePrefix + "$quarkusrestparamConverter$";
            try (ClassCreator classCreator = new ClassCreator(this.classOutput.apply(elementType), baseName, null, Object.class.getName(), new String[]{ParameterConverter.class.getName()});){
                MethodCreator mc = classCreator.getMethodCreator("convert", Object.class, new Class[]{Object.class});
                if (stringCtor != null) {
                    ResultHandle ret = mc.newInstance(stringCtor, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                } else if (valueOf != null) {
                    ResultHandle ret = mc.invokeStaticMethod(valueOf, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                } else if (fromString != null) {
                    ResultHandle ret = mc.invokeStaticMethod(fromString, new ResultHandle[]{mc.getMethodParam(0)});
                    mc.returnValue(ret);
                }
            }
            delegate = new LoadedParameterConverter().setClassName(baseName);
        } else {
            baseName = null;
            delegate = null;
        }
        existingConverters.put(elementType, baseName);
        if (hasRuntimeConverters) {
            return new RuntimeResolvedConverter.Supplier().setDelegate(delegate);
        }
        if (delegate == null) {
            throw new RuntimeException("Failed to find converter for " + elementType);
        }
        return delegate;
    }
}

