/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.LegacyUserCredentialManager;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SubjectCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserModelDefaultMethods;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public abstract class AbstractUserAdapterFederatedStorage
extends UserModelDefaultMethods {
    public static String FIRST_NAME_ATTRIBUTE = "FIRST_NAME";
    public static String LAST_NAME_ATTRIBUTE = "LAST_NAME";
    public static String EMAIL_ATTRIBUTE = "EMAIL";
    public static String EMAIL_VERIFIED_ATTRIBUTE = "EMAIL_VERIFIED";
    public static String CREATED_TIMESTAMP_ATTRIBUTE = "CREATED_TIMESTAMP";
    public static String ENABLED_ATTRIBUTE = "ENABLED";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;

    public AbstractUserAdapterFederatedStorage(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return UserStorageUtil.userFederatedStorage(this.session);
    }

    public Set<String> getRequiredActions() {
        return this.getFederatedStorage().getRequiredActions(this.realm, this.getId());
    }

    public void addRequiredAction(String action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this.getId(), action);
    }

    public void removeRequiredAction(String action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this.getId(), action);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this.getId(), action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this.getId(), action.name());
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.emptySet();
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>(this.getFederatedStorage().getGroups(this.realm, this.getId()));
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroupsStream().collect(Collectors.toSet()));
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    public void joinGroup(GroupModel group) {
        this.getFederatedStorage().joinGroup(this.realm, this.getId(), group);
    }

    public void leaveGroup(GroupModel group) {
        this.getFederatedStorage().leaveGroup(this.realm, this.getId(), group);
    }

    public boolean isMemberOf(GroupModel group) {
        return RoleUtils.isMember(this.getGroups().stream(), (GroupModel)group);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        return this.getRoleMappings().stream().filter(RoleUtils::isRealmRole).collect(Collectors.toSet());
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        return this.getRoleMappings().stream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app)).collect(Collectors.toSet());
    }

    public boolean hasRole(RoleModel role) {
        return RoleUtils.hasRole(this.getRoleMappings().stream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroups().stream(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        this.getFederatedStorage().grantRole(this.realm, this.getId(), role);
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.emptySet();
    }

    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>(this.getFederatedRoleMappings());
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(this.realm.getDefaultRole().getCompositesStream().collect(Collectors.toSet()));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    protected Set<RoleModel> getFederatedRoleMappings() {
        return this.getFederatedStorage().getRoleMappings(this.realm, this.getId());
    }

    public void deleteRoleMapping(RoleModel role) {
        this.getFederatedStorage().deleteRoleMapping(this.realm, this.getId(), role);
    }

    public boolean isEnabled() {
        String val = this.getFirstAttribute(ENABLED_ATTRIBUTE);
        if (val == null) {
            return true;
        }
        return Boolean.valueOf(val);
    }

    public void setEnabled(boolean enabled) {
        this.setSingleAttribute(ENABLED_ATTRIBUTE, Boolean.toString(enabled));
    }

    public String getFederationLink() {
        return null;
    }

    public void setFederationLink(String link) {
    }

    public String getServiceAccountClientLink() {
        return null;
    }

    public void setServiceAccountClientLink(String clientInternalId) {
    }

    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    public Long getCreatedTimestamp() {
        String val = this.getFirstAttribute(CREATED_TIMESTAMP_ATTRIBUTE);
        if (val == null) {
            return null;
        }
        return Long.valueOf(val);
    }

    public void setCreatedTimestamp(Long timestamp) {
        if (timestamp == null) {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, null);
        } else {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, Long.toString(timestamp));
        }
    }

    public void setSingleAttribute(String name, String value) {
        if ("username".equals(name)) {
            this.setUsername(value);
        } else {
            this.getFederatedStorage().setSingleAttribute(this.realm, this.getId(), this.mapAttribute(name), value);
        }
    }

    public void removeAttribute(String name) {
        this.getFederatedStorage().removeAttribute(this.realm, this.getId(), name);
    }

    public void setAttribute(String name, List<String> values) {
        if ("username".equals(name)) {
            this.setUsername(values != null && values.size() > 0 ? values.get(0) : null);
        } else {
            this.getFederatedStorage().setAttribute(this.realm, this.getId(), this.mapAttribute(name), values);
        }
    }

    public String getFirstAttribute(String name) {
        if ("username".equals(name)) {
            return this.getUsername();
        }
        return (String)this.getFederatedStorage().getAttributes(this.realm, this.getId()).getFirst((Object)this.mapAttribute(name));
    }

    public Map<String, List<String>> getAttributes() {
        List firstName;
        MultivaluedHashMap attributes = this.getFederatedStorage().getAttributes(this.realm, this.getId());
        if (attributes == null) {
            attributes = new MultivaluedHashMap();
        }
        attributes.add((Object)"firstName", (firstName = (List)attributes.remove((Object)FIRST_NAME_ATTRIBUTE)) != null && firstName.size() >= 1 ? (String)firstName.get(0) : null);
        List lastName = (List)attributes.remove((Object)LAST_NAME_ATTRIBUTE);
        attributes.add((Object)"lastName", lastName != null && lastName.size() >= 1 ? (String)lastName.get(0) : null);
        List email = (List)attributes.remove((Object)EMAIL_ATTRIBUTE);
        attributes.add((Object)"email", email != null && email.size() >= 1 ? (String)email.get(0) : null);
        attributes.add((Object)"username", (Object)this.getUsername());
        return attributes;
    }

    public List<String> getAttribute(String name) {
        if ("username".equals(name)) {
            return Collections.singletonList(this.getUsername());
        }
        List result = (List)this.getFederatedStorage().getAttributes(this.realm, this.getId()).get((Object)this.mapAttribute(name));
        return result == null ? Collections.emptyList() : result;
    }

    protected String mapAttribute(String attributeName) {
        if ("firstName".equals(attributeName)) {
            return FIRST_NAME_ATTRIBUTE;
        }
        if ("lastName".equals(attributeName)) {
            return LAST_NAME_ATTRIBUTE;
        }
        if ("email".equals(attributeName)) {
            return EMAIL_ATTRIBUTE;
        }
        return attributeName;
    }

    public boolean isEmailVerified() {
        String val = this.getFirstAttribute(EMAIL_VERIFIED_ATTRIBUTE);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    public void setEmailVerified(boolean verified) {
        this.setSingleAttribute(EMAIL_VERIFIED_ATTRIBUTE, Boolean.toString(verified));
    }

    public SubjectCredentialManager credentialManager() {
        return new LegacyUserCredentialManager(this.session, this.realm, (UserModel)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static abstract class Streams
    extends AbstractUserAdapterFederatedStorage
    implements UserModel.Streams {
        public Streams(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
            super(session, realm, storageProviderModel);
        }

        @Override
        public Set<String> getRequiredActions() {
            return this.getRequiredActionsStream().collect(Collectors.toSet());
        }

        public Stream<String> getRequiredActionsStream() {
            return super.getFederatedStorage().getRequiredActionsStream(this.realm, super.getId());
        }

        @Override
        public List<String> getAttribute(String name) {
            return this.getAttributeStream(name).collect(Collectors.toList());
        }

        public Stream<String> getAttributeStream(String name) {
            if ("username".equals(name)) {
                return Stream.of(this.getUsername());
            }
            List result = (List)super.getFederatedStorage().getAttributes(this.realm, this.getId()).get((Object)super.mapAttribute(name));
            return result == null ? Stream.empty() : result.stream();
        }

        @Override
        public Set<GroupModel> getGroups() {
            return this.getGroupsStream().collect(Collectors.toSet());
        }

        public Stream<GroupModel> getGroupsStream() {
            Stream groups = this.getFederatedStorage().getGroupsStream(this.realm, this.getId());
            if (this.appendDefaultGroups()) {
                groups = Stream.concat(groups, this.realm.getDefaultGroupsStream());
            }
            return Stream.concat(groups, this.getGroupsInternal().stream());
        }

        @Override
        public boolean isMemberOf(GroupModel group) {
            return RoleUtils.isMember(this.getGroupsStream(), (GroupModel)group);
        }

        @Override
        public Set<RoleModel> getRealmRoleMappings() {
            return this.getRealmRoleMappingsStream().collect(Collectors.toSet());
        }

        public Stream<RoleModel> getRealmRoleMappingsStream() {
            return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
        }

        @Override
        public Set<RoleModel> getClientRoleMappings(ClientModel app) {
            return this.getClientRoleMappingsStream(app).collect(Collectors.toSet());
        }

        public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
            return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
        }

        @Override
        public Set<RoleModel> getRoleMappings() {
            return this.getRoleMappingsStream().collect(Collectors.toSet());
        }

        public Stream<RoleModel> getRoleMappingsStream() {
            Stream roleMappings = this.getFederatedRoleMappings().stream();
            if (this.appendDefaultRolesToRoleMappings()) {
                roleMappings = Stream.concat(roleMappings, this.realm.getDefaultRole().getCompositesStream());
            }
            return Stream.concat(roleMappings, this.getRoleMappingsInternal().stream());
        }

        @Override
        public boolean hasRole(RoleModel role) {
            return RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role) || RoleUtils.hasRoleFromGroup(this.getGroupsStream(), (RoleModel)role, (boolean)true);
        }
    }
}

