/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;

public final class Environment {
    public static final String IMPORT_EXPORT_MODE = "import_export";
    public static final String PROFILE = "kc.profile";
    public static final String ENV_PROFILE = "KC_PROFILE";
    public static final String DATA_PATH = "/data";
    public static final String DEFAULT_THEMES_PATH = "/themes";
    public static final String DEV_PROFILE_VALUE = "dev";
    public static final String PROD_PROFILE_VALUE = "prod";
    public static final String LAUNCH_MODE = "kc.launch.mode";

    private Environment() {
    }

    public static Boolean isRebuild() {
        return Boolean.getBoolean("quarkus.launch.rebuild");
    }

    public static Boolean isRuntimeMode() {
        return Environment.isRebuild() == false;
    }

    public static String getHomeDir() {
        return System.getProperty("kc.home.dir");
    }

    public static Path getHomePath() {
        String homeDir = Environment.getHomeDir();
        if (homeDir != null) {
            return Paths.get(homeDir, new String[0]);
        }
        return null;
    }

    public static String getDataDir() {
        return Environment.getHomeDir() + DATA_PATH;
    }

    public static String getDefaultThemeRootDir() {
        return Environment.getHomeDir() + DEFAULT_THEMES_PATH;
    }

    public static Path getProvidersPath() {
        Path homePath = Environment.getHomePath();
        if (homePath != null) {
            return homePath.resolve("providers");
        }
        return null;
    }

    public static String getCommand() {
        if (Environment.isWindows()) {
            return "kc.bat";
        }
        return "kc.sh";
    }

    public static String getProfile() {
        String profile = System.getProperty(PROFILE);
        if (profile == null) {
            profile = System.getenv(ENV_PROFILE);
        }
        return profile;
    }

    public static void setProfile(String profile) {
        System.setProperty(PROFILE, profile);
        System.setProperty("quarkus.profile", profile);
        if (Environment.isTestLaunchMode()) {
            System.setProperty("mp.config.profile", profile);
        }
    }

    public static String getCurrentOrPersistedProfile() {
        String profile = Environment.getProfile();
        if (profile == null) {
            profile = PersistedConfigSource.getInstance().getValue(PROFILE);
        }
        return profile;
    }

    public static String getProfileOrDefault(String defaultProfile) {
        String profile = Environment.getProfile();
        if (profile == null) {
            profile = defaultProfile;
        }
        return profile;
    }

    public static boolean isDevMode() {
        if (DEV_PROFILE_VALUE.equalsIgnoreCase(Environment.getProfile())) {
            return true;
        }
        return DEV_PROFILE_VALUE.equals(Configuration.getBuildTimeProperty(PROFILE).orElse(null));
    }

    public static boolean isDevProfile() {
        return Optional.ofNullable(Environment.getProfile()).orElse("").equalsIgnoreCase(DEV_PROFILE_VALUE);
    }

    public static boolean isImportExportMode() {
        return IMPORT_EXPORT_MODE.equalsIgnoreCase(Environment.getProfile());
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static void forceDevProfile() {
        Environment.setProfile(DEV_PROFILE_VALUE);
    }

    public static Map<String, File> getProviderFiles() {
        Path providersPath = Environment.getProvidersPath();
        if (providersPath == null) {
            return Collections.emptyMap();
        }
        File providersDir = providersPath.toFile();
        if (!providersDir.exists() || !providersDir.isDirectory()) {
            throw new RuntimeException("The 'providers' directory does not exist or is not a valid directory.");
        }
        return Arrays.stream(providersDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })).collect(Collectors.toMap(File::getName, Function.identity()));
    }

    public static boolean isQuarkusDevMode() {
        return ProfileManager.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT);
    }

    public static boolean isTestLaunchMode() {
        return "test".equals(System.getProperty(LAUNCH_MODE));
    }

    public static void forceTestLaunchMode() {
        System.setProperty(LAUNCH_MODE, "test");
    }

    public static String getKeycloakModeFromProfile(String profile) {
        if (profile == null || profile.isEmpty()) {
            return "none";
        }
        if (profile.equals(LaunchMode.DEVELOPMENT.getDefaultProfile())) {
            return "development";
        }
        if (profile.equals(LaunchMode.TEST.getDefaultProfile())) {
            return "test";
        }
        if (profile.equals(LaunchMode.NORMAL.getDefaultProfile())) {
            return "production";
        }
        return profile;
    }

    public static boolean isDistribution() {
        if (Environment.isQuarkusDevMode()) {
            return false;
        }
        return Environment.getHomeDir() != null;
    }

    public static boolean isRebuildCheck() {
        return Boolean.getBoolean("kc.config.build-and-exit");
    }

    public static boolean isRebuilt() {
        return Boolean.getBoolean("kc.config.built");
    }
}

