/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.hostname;

import java.net.URI;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.Config;
import org.keycloak.common.util.Resteasy;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.StringUtil;

public final class DefaultHostnameProvider
implements HostnameProvider,
HostnameProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultHostnameProvider.class);
    private static final String REALM_URI_SESSION_ATTRIBUTE = DefaultHostnameProvider.class.getName() + ".realmUrl";
    private static final int DEFAULT_HTTPS_PORT_VALUE = 443;
    private static final int RESTEASY_DEFAULT_PORT_VALUE = -1;
    private String frontChannelHostName;
    private String defaultPath;
    private String defaultHttpScheme;
    private int defaultTlsPort;
    private boolean noProxy;
    private String adminHostName;
    private Boolean strictBackChannel;
    private boolean hostnameEnabled;
    private boolean strictHttps;
    private int hostnamePort;

    public String getScheme(UriInfo originalUriInfo, UrlType urlType) {
        String scheme = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getScheme, arg_0 -> ((DefaultHostnameProvider)this).getScheme(arg_0));
        if (scheme != null) {
            return scheme;
        }
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.getScheme(originalUriInfo);
        }
        return this.fromFrontChannel(originalUriInfo, URI::getScheme, arg_0 -> ((DefaultHostnameProvider)this).getScheme(arg_0), this.defaultHttpScheme);
    }

    public String getHostname(UriInfo originalUriInfo, UrlType urlType) {
        String hostname = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getHostname, arg_0 -> ((DefaultHostnameProvider)this).getHostname(arg_0));
        if (hostname != null) {
            return hostname;
        }
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.adminHostName == null ? this.getHostname(originalUriInfo) : this.adminHostName;
        }
        return this.fromFrontChannel(originalUriInfo, URI::getHost, arg_0 -> ((DefaultHostnameProvider)this).getHostname(arg_0), this.frontChannelHostName);
    }

    public String getContextPath(UriInfo originalUriInfo, UrlType urlType) {
        String path = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getContextPath, arg_0 -> ((DefaultHostnameProvider)this).getContextPath(arg_0));
        if (path != null) {
            return path;
        }
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.getContextPath(originalUriInfo);
        }
        return this.fromFrontChannel(originalUriInfo, URI::getPath, arg_0 -> ((DefaultHostnameProvider)this).getContextPath(arg_0), this.defaultPath);
    }

    public int getPort(UriInfo originalUriInfo, UrlType urlType) {
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.getRequestPort();
        }
        Integer port = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getPort, this::getPort);
        if (port != null) {
            return port;
        }
        if (this.hostnameEnabled && !this.noProxy) {
            return this.hostnamePort;
        }
        return this.fromFrontChannel(originalUriInfo, URI::getPort, this::getPort, this.hostnamePort == -1 ? this.getPort(originalUriInfo) : this.hostnamePort);
    }

    public int getPort(UriInfo originalUriInfo) {
        return this.noProxy && this.strictHttps ? this.defaultTlsPort : this.getRequestPort();
    }

    private <T> T forNonStrictBackChannel(UriInfo originalUriInfo, UrlType urlType, BiFunction<UriInfo, UrlType, T> frontEndTypeResolver, Function<UriInfo, T> defaultResolver) {
        if (UrlType.BACKEND.equals((Object)urlType) && !this.strictBackChannel.booleanValue()) {
            if (this.isHostFromFrontEndUrl(originalUriInfo)) {
                return frontEndTypeResolver.apply(originalUriInfo, UrlType.FRONTEND);
            }
            return defaultResolver.apply(originalUriInfo);
        }
        return null;
    }

    private <T> T fromFrontChannel(UriInfo originalUriInfo, Function<URI, T> frontEndTypeResolver, Function<UriInfo, T> defaultResolver, T defaultValue) {
        URI frontEndUrl = this.getRealmFrontEndUrl();
        if (frontEndUrl != null) {
            return frontEndTypeResolver.apply(frontEndUrl);
        }
        return defaultValue == null ? defaultResolver.apply(originalUriInfo) : defaultValue;
    }

    private boolean isHostFromFrontEndUrl(UriInfo originalUriInfo) {
        String frontendUrl;
        String requestHost = this.getHostname(originalUriInfo);
        if (requestHost.equals(frontendUrl = this.getHostname(originalUriInfo, UrlType.FRONTEND))) {
            return true;
        }
        URI realmUrl = this.getRealmFrontEndUrl();
        return realmUrl != null && requestHost.equals(realmUrl.getHost());
    }

    protected URI getRealmFrontEndUrl() {
        String frontendUrl;
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            return null;
        }
        String realmUriKey = realm.getId() + REALM_URI_SESSION_ATTRIBUTE;
        URI realmUrl = (URI)session.getAttribute(realmUriKey);
        if (realmUrl == null && StringUtil.isNotBlank((String)(frontendUrl = realm.getAttribute("frontendUrl")))) {
            realmUrl = URI.create(frontendUrl);
            session.setAttribute(realmUriKey, (Object)realmUrl);
            return realmUrl;
        }
        return realmUrl;
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public HostnameProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        this.frontChannelHostName = config.get("hostname");
        if (config.getBoolean("strict", Boolean.valueOf(false)).booleanValue() && this.frontChannelHostName == null) {
            throw new RuntimeException("Strict hostname resolution configured but no hostname was set");
        }
        this.hostnameEnabled = this.frontChannelHostName != null;
        this.strictHttps = config.getBoolean("strict-https", Boolean.valueOf(false));
        if (this.strictHttps) {
            this.defaultHttpScheme = "https";
        }
        this.defaultPath = config.get("path");
        this.noProxy = Configuration.getConfigValue("kc.proxy").getValue().equals("false");
        this.defaultTlsPort = Integer.parseInt(Configuration.getConfigValue("kc.https-port").getValue());
        if (this.defaultTlsPort == 443) {
            this.defaultTlsPort = -1;
        }
        this.hostnamePort = Integer.parseInt(Configuration.getConfigValue("kc.hostname-port").getValue());
        this.adminHostName = config.get("admin");
        this.strictBackChannel = config.getBoolean("strict-backchannel", Boolean.valueOf(false));
        LOGGER.infov("Hostname settings: FrontEnd: {0}, Strict HTTPS: {1}, Path: {2}, Strict BackChannel: {3}, Admin: {4}, Port: {5}, Proxied: {6}", new Object[]{this.frontChannelHostName == null ? "<request>" : this.frontChannelHostName, this.strictHttps, this.defaultPath == null ? "<request>" : this.defaultPath, this.strictBackChannel, this.adminHostName == null ? "<request>" : this.adminHostName, this.hostnamePort, !this.noProxy});
    }

    private int getRequestPort() {
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        return ((HttpRequest)session.getContext().getContextObject(HttpRequest.class)).getUri().getBaseUri().getPort();
    }
}

