/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.Scope;
import org.wildfly.security.http.oidc.AuthChallenge;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcAccount;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcPrincipal;
import org.wildfly.security.http.oidc.OidcRequestAuthenticator;
import org.wildfly.security.http.oidc.RefreshableOidcSecurityContext;

public class RequestAuthenticator {
    protected OidcHttpFacade facade;
    protected AuthChallenge challenge;
    protected OidcClientConfiguration deployment;
    protected int sslRedirectPort;

    public RequestAuthenticator(OidcHttpFacade facade, OidcClientConfiguration deployment, int sslRedirectPort) {
        this.facade = facade;
        this.deployment = deployment;
        this.sslRedirectPort = sslRedirectPort;
    }

    public Oidc.AuthOutcome authenticate() {
        Oidc.AuthOutcome authenticate = this.doAuthenticate();
        if (Oidc.AuthOutcome.AUTHENTICATED.equals((Object)authenticate) && !this.facade.isAuthorized()) {
            return Oidc.AuthOutcome.FAILED;
        }
        return authenticate;
    }

    protected OidcRequestAuthenticator createOidcAuthenticator() {
        return new OidcRequestAuthenticator(this, this.facade, this.deployment, this.sslRedirectPort, this.facade.getTokenStore());
    }

    protected void completeOidcAuthentication(OidcPrincipal<RefreshableOidcSecurityContext> principal) {
        this.facade.authenticationComplete(new OidcAccount(principal), true);
    }

    protected String changeHttpSessionId(boolean create) {
        HttpScope session = this.facade.getScope(Scope.SESSION);
        if (create && !session.exists()) {
            session.create();
        }
        return session != null ? session.getID() : null;
    }

    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    private Oidc.AuthOutcome doAuthenticate() {
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("--> authenticate()");
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("try oidc");
        }
        if (this.facade.getTokenStore().isCached(this)) {
            if (this.verifySSL()) {
                return Oidc.AuthOutcome.FAILED;
            }
            ElytronMessages.log.debug("AUTHENTICATED: was cached");
            return Oidc.AuthOutcome.AUTHENTICATED;
        }
        OidcRequestAuthenticator oidc = this.createOidcAuthenticator();
        Oidc.AuthOutcome outcome = oidc.authenticate();
        if (outcome == Oidc.AuthOutcome.FAILED) {
            this.challenge = oidc.getChallenge();
            return Oidc.AuthOutcome.FAILED;
        }
        if (outcome == Oidc.AuthOutcome.NOT_ATTEMPTED) {
            this.challenge = oidc.getChallenge();
            return Oidc.AuthOutcome.NOT_ATTEMPTED;
        }
        if (this.verifySSL()) {
            return Oidc.AuthOutcome.FAILED;
        }
        this.completeAuthentication(oidc);
        this.facade.getResponse().setHeader("Location", oidc.getStrippedOauthParametersRequestUri());
        this.facade.getResponse().setStatus(302);
        this.facade.getResponse().end();
        ElytronMessages.log.debug("AUTHENTICATED");
        return Oidc.AuthOutcome.AUTHENTICATED;
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSSLRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            ElytronMessages.log.warnf("SSL is required to authenticate. Remote address %s is secure: %s, SSL required for: %s .", this.facade.getRequest().getRemoteAddr(), this.facade.getRequest().isSecure(), this.deployment.getSSLRequired().name());
            return true;
        }
        return false;
    }

    protected void completeAuthentication(OidcRequestAuthenticator oidc) {
        RefreshableOidcSecurityContext session = new RefreshableOidcSecurityContext(this.deployment, this.facade.getTokenStore(), oidc.getTokenString(), oidc.getToken(), oidc.getIDTokenString(), oidc.getIDToken(), oidc.getRefreshToken());
        OidcPrincipal<RefreshableOidcSecurityContext> principal = new OidcPrincipal<RefreshableOidcSecurityContext>(oidc.getIDToken().getPrincipalName(this.deployment), session);
        this.completeOidcAuthentication(principal);
        ElytronMessages.log.debugv("User ''{0}'' invoking ''{1}'' on client ''{2}''", principal.getName(), this.facade.getRequest().getURI(), this.deployment.getResourceName());
    }
}

