/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.DerUtils;
import org.keycloak.common.util.PemException;

public abstract class PemUtilsProvider {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";

    public X509Certificate decodeCertificate(String cert) {
        if (cert == null) {
            return null;
        }
        try {
            byte[] der = this.pemToDer(cert);
            ByteArrayInputStream bis = new ByteArrayInputStream(der);
            return DerUtils.decodeCertificate(bis);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public PublicKey decodePublicKey(String pem) {
        return this.decodePublicKey(pem, "RSA");
    }

    public PublicKey decodePublicKey(String pem, String type) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = this.pemToDer(pem);
            return DerUtils.decodePublicKey(der, type);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = this.pemToDer(pem);
            return DerUtils.decodePrivateKey(der);
        }
        catch (Exception e) {
            throw new PemException(e);
        }
    }

    public String encodeKey(Key key) {
        return this.encode(key);
    }

    public String encodeCertificate(Certificate certificate) {
        return this.encode(certificate);
    }

    public byte[] pemToDer(String pem) {
        try {
            pem = this.removeBeginEnd(pem);
            return Base64.decode(pem);
        }
        catch (IOException ioe) {
            throw new PemException(ioe);
        }
    }

    public String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    public String generateThumbprint(String[] certChain, String encoding) throws NoSuchAlgorithmException {
        return Base64Url.encode(this.generateThumbprintBytes(certChain, encoding));
    }

    private byte[] generateThumbprintBytes(String[] certChain, String encoding) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(encoding).digest(this.pemToDer(certChain[0]));
    }

    protected abstract String encode(Object var1);
}

