/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authorization;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.authorization.HotRodPolicyEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class HotRodPolicyEntityDelegate
extends HotRodPolicyEntity.AbstractHotRodPolicyEntity
implements MapPolicyEntity {
    private final HotRodPolicyEntity hotRodEntity;

    public HotRodPolicyEntityDelegate() {
        this.hotRodEntity = new HotRodPolicyEntity();
    }

    public HotRodPolicyEntityDelegate(HotRodPolicyEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodPolicyEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodPolicyEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodPolicyEntityDelegate)) {
            return false;
        }
        HotRodPolicyEntityDelegate other = (HotRodPolicyEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAssociatedPolicyIds(), other.getAssociatedPolicyIds()) && Objects.equals(this.getConfigs(), other.getConfigs()) && Objects.equals(this.getDecisionStrategy(), other.getDecisionStrategy()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getLogic(), other.getLogic()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getOwner(), other.getOwner()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getResourceIds(), other.getResourceIds()) && Objects.equals(this.getResourceServerId(), other.getResourceServerId()) && Objects.equals(this.getScopeIds(), other.getScopeIds()) && Objects.equals(this.getType(), other.getType());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodPolicyEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodPolicyEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodPolicyEntity e1 = (HotRodPolicyEntity)o1;
        HotRodPolicyEntity e2 = (HotRodPolicyEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.nameLowercase, e2.nameLowercase) && Objects.equals(e1.description, e2.description) && Objects.equals(e1.type, e2.type) && Objects.equals(e1.decisionStrategy, e2.decisionStrategy) && Objects.equals(e1.logic, e2.logic) && Objects.equals(e1.configs, e2.configs) && Objects.equals(e1.resourceServerId, e2.resourceServerId) && Objects.equals(e1.associatedPolicyIds, e2.associatedPolicyIds) && Objects.equals(e1.resourceIds, e2.resourceIds) && Objects.equals(e1.scopeIds, e2.scopeIds) && Objects.equals(e1.owner, e2.owner);
    }

    public static int entityHashCode(HotRodPolicyEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public void addAssociatedPolicyId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.associatedPolicyIds == null) {
            this.hotRodEntity.associatedPolicyIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.associatedPolicyIds.add(migrated);
    }

    public Set<String> getAssociatedPolicyIds() {
        return this.hotRodEntity.associatedPolicyIds == null ? null : this.hotRodEntity.associatedPolicyIds;
    }

    public void removeAssociatedPolicyId(String p0) {
        if (this.hotRodEntity.associatedPolicyIds == null) {
            return;
        }
        boolean removed = this.hotRodEntity.associatedPolicyIds.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public String getConfig(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.configs, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, String> getConfigs() {
        return this.hotRodEntity.configs == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.configs, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setConfig(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.configs == null && !valueUndefined) {
            this.hotRodEntity.configs = new HashSet<HotRodStringPair>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.configs, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.configs.add(new HotRodStringPair(p0, p1)));
    }

    public void removeConfig(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.configs, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setConfigs(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodStringPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodStringPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.configs, migrated);
        this.hotRodEntity.configs = migrated;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.hotRodEntity.decisionStrategy == null ? null : DecisionStrategy.valueOfInteger((Integer)this.hotRodEntity.decisionStrategy);
    }

    public void setDecisionStrategy(DecisionStrategy p0) {
        Integer migrated = p0 == null ? null : Integer.valueOf(p0.getStableIndex());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.decisionStrategy, migrated);
        this.hotRodEntity.decisionStrategy = migrated;
    }

    public String getDescription() {
        return this.hotRodEntity.description == null ? null : this.hotRodEntity.description;
    }

    public void setDescription(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.description, migrated);
        this.hotRodEntity.description = migrated;
    }

    public void setLogic(Logic p0) {
        Integer migrated = p0 == null ? null : Integer.valueOf(p0.getStableIndex());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.logic, migrated);
        this.hotRodEntity.logic = migrated;
    }

    public Logic getLogic() {
        return this.hotRodEntity.logic == null ? null : Logic.valueOfInteger((Integer)this.hotRodEntity.logic);
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setOwner(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.owner, migrated);
        this.hotRodEntity.owner = migrated;
    }

    public String getOwner() {
        return this.hotRodEntity.owner == null ? null : this.hotRodEntity.owner;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public Set<String> getResourceIds() {
        return this.hotRodEntity.resourceIds == null ? null : this.hotRodEntity.resourceIds;
    }

    public void removeResourceId(String p0) {
        if (this.hotRodEntity.resourceIds == null) {
            return;
        }
        boolean removed = this.hotRodEntity.resourceIds.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public void addResourceId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.resourceIds == null) {
            this.hotRodEntity.resourceIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.resourceIds.add(migrated);
    }

    public void setResourceServerId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.resourceServerId, migrated);
        this.hotRodEntity.resourceServerId = migrated;
    }

    public String getResourceServerId() {
        return this.hotRodEntity.resourceServerId == null ? null : this.hotRodEntity.resourceServerId;
    }

    public void removeScopeId(String p0) {
        if (this.hotRodEntity.scopeIds == null) {
            return;
        }
        boolean removed = this.hotRodEntity.scopeIds.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public Set<String> getScopeIds() {
        return this.hotRodEntity.scopeIds == null ? null : this.hotRodEntity.scopeIds;
    }

    public void addScopeId(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.scopeIds == null) {
            this.hotRodEntity.scopeIds = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.scopeIds.add(migrated);
    }

    public void setType(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.type, migrated);
        this.hotRodEntity.type = migrated;
    }

    public String getType() {
        return this.hotRodEntity.type == null ? null : this.hotRodEntity.type;
    }

    @Override
    public HotRodPolicyEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

