/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.user;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserConsentEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserConsentEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserCredentialEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserCredentialEntityDelegate;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserFederatedIdentityEntity;
import org.keycloak.models.map.storage.hotRod.user.HotRodUserFederatedIdentityEntityDelegate;
import org.keycloak.models.map.user.MapUserConsentEntity;
import org.keycloak.models.map.user.MapUserCredentialEntity;
import org.keycloak.models.map.user.MapUserEntity;
import org.keycloak.models.map.user.MapUserFederatedIdentityEntity;

public class HotRodUserEntityDelegate
extends HotRodUserEntity.AbstractHotRodUserEntityDelegate
implements MapUserEntity {
    private final HotRodUserEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodUserEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodUserEntity();
    }

    public HotRodUserEntityDelegate(HotRodUserEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodUserEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodUserEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodUserEntityDelegate)) {
            return false;
        }
        HotRodUserEntityDelegate other = (HotRodUserEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getCreatedTimestamp(), other.getCreatedTimestamp()) && Objects.equals(this.getCredentials(), other.getCredentials()) && Objects.equals(this.getEmail(), other.getEmail()) && Objects.equals(this.getEmailConstraint(), other.getEmailConstraint()) && Objects.equals(this.getFederatedIdentities(), other.getFederatedIdentities()) && Objects.equals(this.getFederationLink(), other.getFederationLink()) && Objects.equals(this.getFirstName(), other.getFirstName()) && Objects.equals(this.getGroupsMembership(), other.getGroupsMembership()) && Objects.equals(this.getLastName(), other.getLastName()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getRequiredActions(), other.getRequiredActions()) && Objects.equals(this.getRolesMembership(), other.getRolesMembership()) && Objects.equals(this.getServiceAccountClientLink(), other.getServiceAccountClientLink()) && Objects.equals(this.getUserConsents(), other.getUserConsents()) && Objects.equals(this.getUsername(), other.getUsername()) && Objects.equals(this.isEmailVerified(), other.isEmailVerified()) && Objects.equals(this.isEnabled(), other.isEnabled());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodUserEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodUserEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodUserEntity e1 = (HotRodUserEntity)o1;
        HotRodUserEntity e2 = (HotRodUserEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.username, e2.username) && Objects.equals(e1.usernameLowercase, e2.usernameLowercase) && Objects.equals(e1.firstName, e2.firstName) && Objects.equals(e1.createdTimestamp, e2.createdTimestamp) && Objects.equals(e1.lastName, e2.lastName) && Objects.equals(e1.email, e2.email) && Objects.equals(e1.enabled, e2.enabled) && Objects.equals(e1.emailVerified, e2.emailVerified) && Objects.equals(e1.emailConstraint, e2.emailConstraint) && Objects.equals(e1.attributes, e2.attributes) && Objects.equals(e1.requiredActions, e2.requiredActions) && Objects.equals(e1.credentials, e2.credentials) && Objects.equals(e1.federatedIdentities, e2.federatedIdentities) && Objects.equals(e1.userConsents, e2.userConsents) && Objects.equals(e1.groupsMembership, e2.groupsMembership) && Objects.equals(e1.rolesMembership, e2.rolesMembership) && Objects.equals(e1.federationLink, e2.federationLink) && Objects.equals(e1.serviceAccountClientLink, e2.serviceAccountClientLink) && Objects.equals(e1.notBefore, e2.notBefore);
    }

    public static int entityHashCode(HotRodUserEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntity>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntity(p0, p1)));
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public void setCreatedTimestamp(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.createdTimestamp, migrated);
        this.hotRodEntity.createdTimestamp = migrated;
    }

    public Long getCreatedTimestamp() {
        return this.hotRodEntity.createdTimestamp == null ? null : this.hotRodEntity.createdTimestamp;
    }

    public void addCredential(MapUserCredentialEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.credentials == null) {
            this.hotRodEntity.credentials = new LinkedList<HotRodUserCredentialEntity>();
        }
        HotRodUserCredentialEntity migrated = (HotRodUserCredentialEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.credentials.add(migrated);
        this.hotRodEntity.updated = true;
    }

    public List<MapUserCredentialEntity> getCredentials() {
        return this.hotRodEntity.credentials == null ? null : HotRodTypesUtils.migrateList(this.hotRodEntity.credentials, collectionItem -> new HotRodUserCredentialEntityDelegate((HotRodUserCredentialEntity)collectionItem));
    }

    public Boolean removeCredential(MapUserCredentialEntity p0) {
        if (this.hotRodEntity.credentials == null) {
            return false;
        }
        boolean removed = this.hotRodEntity.credentials.remove(p0);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public void setCredentials(List<MapUserCredentialEntity> p0) {
        List<MapUserCredentialEntity> list = p0 = p0 == null ? null : (List<MapUserCredentialEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(LinkedList::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        List<HotRodUserCredentialEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateList(p0, collectionItem -> (HotRodUserCredentialEntity)((HotRodEntityDelegate)collectionItem).getHotRodEntity());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.credentials, migrated);
        this.hotRodEntity.credentials = migrated;
    }

    public void setEmail(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.email, migrated);
        this.hotRodEntity.email = migrated;
    }

    public String getEmail() {
        return this.hotRodEntity.email == null ? null : this.hotRodEntity.email;
    }

    public void setEmailConstraint(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.emailConstraint, migrated);
        this.hotRodEntity.emailConstraint = migrated;
    }

    public String getEmailConstraint() {
        return this.hotRodEntity.emailConstraint == null ? null : this.hotRodEntity.emailConstraint;
    }

    public Boolean isEmailVerified() {
        return this.hotRodEntity.emailVerified == null ? null : this.hotRodEntity.emailVerified;
    }

    public void setEmailVerified(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.emailVerified, migrated);
        this.hotRodEntity.emailVerified = migrated;
    }

    public Boolean isEnabled() {
        return this.hotRodEntity.enabled == null ? null : this.hotRodEntity.enabled;
    }

    public void setEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.enabled, migrated);
        this.hotRodEntity.enabled = migrated;
    }

    public void addFederatedIdentity(MapUserFederatedIdentityEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.federatedIdentities == null) {
            this.hotRodEntity.federatedIdentities = new HashSet<HotRodUserFederatedIdentityEntity>();
        }
        HotRodUserFederatedIdentityEntity migrated = (HotRodUserFederatedIdentityEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.federatedIdentities.add(migrated);
    }

    public Boolean removeFederatedIdentity(MapUserFederatedIdentityEntity p0) {
        if (this.hotRodEntity.federatedIdentities == null) {
            return false;
        }
        boolean removed = this.hotRodEntity.federatedIdentities.remove(p0);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapUserFederatedIdentityEntity> getFederatedIdentities() {
        return this.hotRodEntity.federatedIdentities == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.federatedIdentities, collectionItem -> new HotRodUserFederatedIdentityEntityDelegate((HotRodUserFederatedIdentityEntity)collectionItem));
    }

    public void setFederatedIdentities(Set<MapUserFederatedIdentityEntity> p0) {
        Set<MapUserFederatedIdentityEntity> set = p0 = p0 == null ? null : (Set<MapUserFederatedIdentityEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodUserFederatedIdentityEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateSet(p0, collectionItem -> (HotRodUserFederatedIdentityEntity)((HotRodEntityDelegate)collectionItem).getHotRodEntity());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.federatedIdentities, migrated);
        this.hotRodEntity.federatedIdentities = migrated;
    }

    public String getFederationLink() {
        return this.hotRodEntity.federationLink == null ? null : this.hotRodEntity.federationLink;
    }

    public void setFederationLink(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.federationLink, migrated);
        this.hotRodEntity.federationLink = migrated;
    }

    public String getFirstName() {
        return this.hotRodEntity.firstName == null ? null : this.hotRodEntity.firstName;
    }

    public void setFirstName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.firstName, migrated);
        this.hotRodEntity.firstName = migrated;
    }

    public void addGroupsMembership(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.groupsMembership == null) {
            this.hotRodEntity.groupsMembership = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.groupsMembership.add(migrated);
    }

    public void removeGroupsMembership(String p0) {
        if (this.hotRodEntity.groupsMembership == null) {
            return;
        }
        boolean removed = this.hotRodEntity.groupsMembership.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public void setGroupsMembership(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.groupsMembership, migrated);
        this.hotRodEntity.groupsMembership = migrated;
    }

    public Set<String> getGroupsMembership() {
        return this.hotRodEntity.groupsMembership == null ? null : this.hotRodEntity.groupsMembership;
    }

    public void setLastName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.lastName, migrated);
        this.hotRodEntity.lastName = migrated;
    }

    public String getLastName() {
        return this.hotRodEntity.lastName == null ? null : this.hotRodEntity.lastName;
    }

    public Long getNotBefore() {
        return this.hotRodEntity.notBefore == null ? null : this.hotRodEntity.notBefore;
    }

    public void setNotBefore(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notBefore, migrated);
        this.hotRodEntity.notBefore = migrated;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void setRequiredActions(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.requiredActions, migrated);
        this.hotRodEntity.requiredActions = migrated;
    }

    public void removeRequiredAction(String p0) {
        if (this.hotRodEntity.requiredActions == null) {
            return;
        }
        boolean removed = this.hotRodEntity.requiredActions.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public void addRequiredAction(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.requiredActions == null) {
            this.hotRodEntity.requiredActions = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.requiredActions.add(migrated);
    }

    public Set<String> getRequiredActions() {
        return this.hotRodEntity.requiredActions == null ? null : this.hotRodEntity.requiredActions;
    }

    public void addRolesMembership(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.rolesMembership == null) {
            this.hotRodEntity.rolesMembership = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.rolesMembership.add(migrated);
    }

    public void removeRolesMembership(String p0) {
        if (this.hotRodEntity.rolesMembership == null) {
            return;
        }
        boolean removed = this.hotRodEntity.rolesMembership.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public Set<String> getRolesMembership() {
        return this.hotRodEntity.rolesMembership == null ? null : this.hotRodEntity.rolesMembership;
    }

    public void setRolesMembership(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.rolesMembership, migrated);
        this.hotRodEntity.rolesMembership = migrated;
    }

    public void setServiceAccountClientLink(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.serviceAccountClientLink, migrated);
        this.hotRodEntity.serviceAccountClientLink = migrated;
    }

    public String getServiceAccountClientLink() {
        return this.hotRodEntity.serviceAccountClientLink == null ? null : this.hotRodEntity.serviceAccountClientLink;
    }

    public void setUserConsents(Set<MapUserConsentEntity> p0) {
        Set<MapUserConsentEntity> set = p0 = p0 == null ? null : (Set<MapUserConsentEntity>)p0.stream().map(entry -> this.deepClone(entry)).collect(Collectors.toCollection(HashSet::new));
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodUserConsentEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateSet(p0, collectionItem -> (HotRodUserConsentEntity)((HotRodEntityDelegate)collectionItem).getHotRodEntity());
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.userConsents, migrated);
        this.hotRodEntity.userConsents = migrated;
    }

    public Boolean removeUserConsent(MapUserConsentEntity p0) {
        if (this.hotRodEntity.userConsents == null) {
            return false;
        }
        boolean removed = this.hotRodEntity.userConsents.remove(p0);
        this.hotRodEntity.updated |= removed;
        return removed;
    }

    public Set<MapUserConsentEntity> getUserConsents() {
        return this.hotRodEntity.userConsents == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.userConsents, collectionItem -> new HotRodUserConsentEntityDelegate((HotRodUserConsentEntity)collectionItem));
    }

    public void addUserConsent(MapUserConsentEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.userConsents == null) {
            this.hotRodEntity.userConsents = new HashSet<HotRodUserConsentEntity>();
        }
        HotRodUserConsentEntity migrated = (HotRodUserConsentEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.userConsents.add(migrated);
    }

    public String getUsername() {
        return this.hotRodEntity.username == null ? null : this.hotRodEntity.username;
    }

    @Override
    public HotRodUserEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

